/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.monitoring.servertimeout;

import java.io.IOException;
import java.security.Principal;
import java.util.Date;
import javax.servlet.HttpConstraintElement;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletSecurityElement;
import javax.servlet.annotation.ServletSecurity;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclnt.jsfserver.monitoring.servertimeout.IServerTimeOutManager;
import org.eclnt.jsfserver.monitoring.servertimeout.ServerTimeOutInfo;
import org.eclnt.jsfserver.monitoring.servertimeout.ServerTimeOutManagerFactory;
import org.eclnt.jsfserver.util.CCServletBase;
import org.eclnt.jsfserver.util.ICCServerConstants;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.JAXBManager;
import org.eclnt.util.valuemgmt.ValueManager;

public class ServerTimeOutServlet
extends CCServletBase
implements ICCServerConstants {
    public static void manageSecuritySettings(ServletContext context, ServletRegistration.Dynamic reg) {
        try {
            HttpConstraintElement hce = new HttpConstraintElement(ServletSecurity.TransportGuarantee.NONE, new String[]{"ccadmin"});
            ServletSecurityElement sse = new ServletSecurityElement(hce);
            reg.setServletSecurity(sse);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Problem when managing security of " + ServerTimeOutServlet.class, t);
            throw new Error(t);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.checkIfAllowed(req);
        String duration = req.getParameter("duration");
        if (duration == null) {
            throw new Error("duration not passed as request parameter");
        }
        long durationLong = ValueManager.decodeLong(duration, Long.MIN_VALUE);
        if (durationLong == Long.MIN_VALUE) {
            throw new Error("duration could not be interpreted: " + duration);
        }
        IServerTimeOutManager stom = ServerTimeOutManagerFactory.instance();
        if (durationLong >= 0L) {
            String comment = req.getParameter("comment");
            if (comment == null) {
                comment = "By ServerTimeOutServlet.";
            }
            ServerTimeOutInfo sti = new ServerTimeOutInfo();
            sti.setTimeOutAt(new Date(System.currentTimeMillis() + durationLong * 60L * 1000L));
            sti.setComment(comment);
            stom.triggerServerTimeout(sti);
            resp.getWriter().write(JAXBManager.marshal(sti));
        } else {
            stom.removeCurrentServerTimeOut();
            resp.getWriter().write("<removed/>");
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    private void checkIfAllowed(HttpServletRequest req) {
        try {
            Principal p = req.getUserPrincipal();
            if (p == null) {
                throw new Error("User principal is not avavilable. Log on required.");
            }
            CLog.L.log(CLog.LL_INF, "User principal: " + p.getName());
        }
        catch (Throwable t) {
            throw new Error("Problem when checking security", t);
        }
    }
}

