/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.pagebean;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclnt.jsfserver.pagebean.IPageBean;
import org.eclnt.jsfserver.pagebean.componentascontrol.IAttributeReferenceProvider;
import org.eclnt.jsfserver.pagebean.componentascontrol.attributeReference;
import org.eclnt.jsfserver.pagebean.componentascontrol.valuemgmt.AttributeReference;
import org.eclnt.jsfserver.util.valuemgmt.IValueDelegation;
import org.eclnt.util.valuemgmt.ValueManager;

public class PageBeanUtil {
    public static String buildContentReplace(IPageBean pageBean) {
        if (pageBean == null) {
            return null;
        }
        String from = pageBean.getRootExpressionUsedInPage();
        if (from == null) {
            return null;
        }
        String to = pageBean.getActualRootExpression();
        if (to == null) {
            return null;
        }
        from = from.substring(0, from.length() - 1) + ".";
        to = to.substring(0, to.length() - 1) + ".";
        from = ValueManager.decodeFromXML(from);
        to = ValueManager.decodeFromXML(to);
        String result = from + ":" + to;
        return result;
    }

    public static void transferAttributeReferencesIntoPageBeanInstance(Object instance, Map<String, String> fixParams, Map<String, IValueDelegation<?>> dynParams) {
        if (instance == null) {
            return;
        }
        PageBeanUtil.transferAttributeReferencesByAnnotationIntoInstance(instance, fixParams, dynParams);
        PageBeanUtil.transferAttributeReferencesByIAttributeReferenceProvider(instance, fixParams, dynParams);
    }

    public static Field[] junit_findDeclaredFieldsWithDrillup(Class<? extends Object> clazz) {
        return PageBeanUtil.findDeclaredFieldsWithDrillUp(clazz);
    }

    private static Field[] findDeclaredFieldsWithDrillUp(Class<? extends Object> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        PageBeanUtil.addDeclaredFields(fields, clazz);
        Field[] result = new Field[fields.size()];
        fields.toArray(result);
        return result;
    }

    private static void addDeclaredFields(List<Field> fieldsList, Class<? extends Object> clazz) {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            fieldsList.add(field);
        }
        Class<? extends Object> superClazz = clazz.getSuperclass();
        if (superClazz != null && superClazz != Object.class) {
            PageBeanUtil.addDeclaredFields(fieldsList, superClazz);
        }
    }

    private static void transferAttributeReferencesByIAttributeReferenceProvider(Object instance, Map<String, String> fixParams, Map<String, IValueDelegation<?>> dynParams) {
        if (!(instance instanceof IAttributeReferenceProvider)) {
            return;
        }
        IAttributeReferenceProvider arpInstance = (IAttributeReferenceProvider)instance;
        Set<String> attributes = arpInstance.getAttributesWithAttributeReference();
        for (String attribute : attributes) {
            try {
                IValueDelegation<?> dyn;
                AttributeReference<?> attributeReference2 = arpInstance.getAttributeReference(attribute);
                if (attributeReference2 == null) continue;
                String fix = fixParams.get(attribute);
                if (fix != null) {
                    attributeReference2.initializeValue(fix);
                }
                if ((dyn = dynParams.get(attribute)) == null) continue;
                attributeReference2.initializeValue(dyn);
            }
            catch (Throwable t) {
                throw new Error("Problem assigning attribute reference content for " + attribute + ", IAttributeReferenceProvider");
            }
        }
    }

    private static void transferAttributeReferencesByAnnotationIntoInstance(Object instance, Map<String, String> fixParams, Map<String, IValueDelegation<?>> dynParams) {
        Field[] fields;
        for (Field field : fields = PageBeanUtil.findDeclaredFieldsWithDrillUp(instance.getClass())) {
            attributeReference ar;
            if (!field.isAnnotationPresent(attributeReference.class) || (ar = field.getAnnotation(attributeReference.class)) == null) continue;
            String attribute = ar.attribute();
            if ("UNDEFINED".equals(attribute)) {
                attribute = field.getName();
                if (attribute.startsWith("_")) {
                    attribute = attribute.substring(1);
                } else if (attribute.startsWith("m_")) {
                    attribute = attribute.substring(2);
                }
                if (attribute.endsWith("Ref")) {
                    attribute = attribute.substring(0, attribute.length() - 3);
                }
            }
            try {
                IValueDelegation<?> dyn;
                field.setAccessible(true);
                AttributeReference attributeReference2 = (AttributeReference)field.get(instance);
                if (attributeReference2 == null) continue;
                String fix = fixParams.get(attribute);
                if (fix != null) {
                    attributeReference2.initializeValue(fix);
                }
                if ((dyn = dynParams.get(attribute)) == null) continue;
                attributeReference2.initializeValue(dyn);
            }
            catch (Throwable t) {
                throw new Error("Problem assigning attribute reference content for " + field + ", annotation");
            }
        }
    }
}

