/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.polling;

import java.io.IOException;
import javax.faces.FactoryFinder;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclnt.jsfserver.polling.DefaultLongPolling;
import org.eclnt.jsfserver.polling.ILongPolling;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.ServletUtil;
import org.eclnt.util.log.CLog;

public class LongPollingServlet
extends HttpServlet {
    private static long MAXWAIT_DURATION_MILLISECONDS = 1800000L;
    private FacesContextFactory m_facesContextFactory;
    private Lifecycle m_lifecycle;
    private static int s_threadCounter = 0;

    private static synchronized void updateThreadCounter(boolean up) {
        s_threadCounter = up ? ++s_threadCounter : --s_threadCounter;
        CLog.L.log(CLog.LL_INF, "LONGPOLLING: current number of threads is " + s_threadCounter + ", (" + up + ")");
    }

    public static int getThreadCounter() {
        return s_threadCounter;
    }

    public void init() throws ServletException {
        super.init();
        try {
            LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
            this.m_facesContextFactory = (FacesContextFactory)FactoryFinder.getFactory((String)"javax.faces.context.FacesContextFactory");
            this.m_lifecycle = lifecycleFactory.getLifecycle("DEFAULT");
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problems in init() of LongPollingServlet - only relevant if accessing FacesContext during servlet processing");
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HttpSession session = req.getSession(false);
        if (session == null) {
            CLog.L.log(CLog.LL_WAR, "Server side processing not possible without http session being associated: " + ((Object)((Object)this)).getClass().getName());
            throw new Error("Server side processing not possible without http session being associated: " + ((Object)((Object)this)).getClass().getName());
        }
        String method = req.getMethod();
        if ("GET".equals(method)) {
            ServletUtil.ensureServletGetIsAllowed(((Object)((Object)this)).getClass());
        }
        String threadName = Thread.currentThread().getName();
        String sessionId = null;
        ServletUtil.setResponseContentType(resp, "text/plain");
        try {
            LongPollingServlet.updateThreadCounter(true);
            try {
                Thread.currentThread().setName("CC LongPolling");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            CLog.L.log(CLog.LL_INF, "LongPollingServlet called via http-request");
            FacesContext context = null;
            try {
                context = this.m_facesContextFactory.getFacesContext((Object)this.getServletContext(), (Object)req, (Object)resp, this.m_lifecycle);
                FacesContext facesContext = HttpSessionAccess.getCurrentFacesContext();
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_INF, "Problems in init() of LongPollingServlet - only relevant if accessing FacesContext during servlet processing");
            }
            sessionId = session.getId();
            String pollerId = req.getRequestURI();
            CLog.L.log(CLog.LL_INF, "LongPollingServlet called session id: " + sessionId);
            int index = pollerId.indexOf(".cclongpolling");
            if (index > 0) {
                pollerId = pollerId.substring(0, index);
                index = pollerId.lastIndexOf(47);
                pollerId = pollerId.substring(index + 1);
                pollerId = "cclongpolling_" + pollerId;
                Object bufferedObject = session.getAttribute(pollerId);
                if (bufferedObject instanceof ILongPolling) {
                    DefaultLongPolling lp = (DefaultLongPolling)bufferedObject;
                    try {
                        lp.abortThreadWithErrorIfWaiting();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    lp.waitForEvent(resp);
                    if (lp.getLongPollingResponse() == null) {
                        resp.getWriter().write("" + lp.getContinuePolling());
                    } else {
                        resp.getWriter().write("" + lp.getLongPollingResponse());
                    }
                } else {
                    resp.getWriter().write("false");
                }
            } else {
                resp.getWriter().write("false");
            }
            if (context != null) {
                context.release();
            }
            CLog.L.log(CLog.LL_INF, "BufferedContentServlet finished, Session Id: " + sessionId);
            LongPollingServlet.updateThreadCounter(false);
            try {
                Thread.currentThread().setName(threadName);
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable t) {
            LongPollingServlet.updateThreadCounter(false);
            try {
                Thread.currentThread().setName(threadName);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            resp.getWriter().write("Error on server side: " + t.toString());
            CLog.L.log(CLog.LL_INF, "BufferedContentServlet finished, Session Id: " + sessionId);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }
}

