/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.polling.comet;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.catalina.comet.CometEvent;
import org.apache.catalina.comet.CometProcessor;
import org.eclnt.jsfserver.polling.comet.DefaultLongPollingComet;
import org.eclnt.jsfserver.util.ServletUtil;
import org.eclnt.util.log.CLog;

public class LongPollingServletComet
extends HttpServlet
implements CometProcessor {
    public void event(CometEvent event) throws IOException, ServletException {
        CLog.L.log(CLog.LL_INF, "##### Comet-event received: " + event.getEventType().toString());
        HttpServletRequest request = event.getHttpServletRequest();
        HttpServletResponse response = event.getHttpServletResponse();
        ServletUtil.setResponseContentType(response, "text/plain");
        HttpSession session = request.getSession(false);
        if (session == null) {
            CLog.L.log(CLog.LL_INF, "No session for request found");
            response.getWriter().flush();
            response.getWriter().close();
            return;
        }
        CLog.L.log(CLog.LL_INF, "Session id: " + session.getId());
        String pollerId = this.getPollerId(request);
        CLog.L.log(CLog.LL_INF, "Poller id: " + pollerId);
        if (pollerId == null) {
            response.getWriter().flush();
            response.getWriter().close();
            return;
        }
        Object bufferedObject = session.getAttribute(pollerId);
        DefaultLongPollingComet lp = null;
        if (bufferedObject == null || !(bufferedObject instanceof DefaultLongPollingComet)) {
            response.getWriter().write("false");
            response.getWriter().flush();
            response.getWriter().close();
            return;
        }
        lp = (DefaultLongPollingComet)bufferedObject;
        if (event.getEventType() == CometEvent.EventType.BEGIN) {
            try {
                lp.abortThreadWithErrorIfWaiting();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            lp.waitForEvent(response, event);
        } else if (event.getEventType() == CometEvent.EventType.ERROR || event.getEventType() == CometEvent.EventType.END || event.getEventType() == CometEvent.EventType.READ) {
            // empty if block
        }
    }

    private String getPollerId(HttpServletRequest req) {
        String pollerId = req.getRequestURI();
        int index = pollerId.indexOf(".cclongpollingcomet");
        if (index > 0) {
            pollerId = pollerId.substring(0, index);
            index = pollerId.lastIndexOf(47);
            pollerId = pollerId.substring(index + 1);
            pollerId = "cclongpolling_" + pollerId;
            return pollerId;
        }
        return null;
    }
}

