/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.session;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;
import org.eclnt.jsfserver.defaultscreens.DefaultScreens;
import org.eclnt.jsfserver.elements.ThreadData;
import org.eclnt.jsfserver.session.SessionInfo;
import org.eclnt.jsfserver.util.SubpageContext;
import org.eclnt.util.file.FileManager;
import org.eclnt.util.valuemgmt.UniqueIdCreator;
import org.eclnt.util.valuemgmt.ValueManager;

public class UsageWithoutSessionContext {
    static boolean s_usageWihtoutSessionContext = false;
    static SessionInfo s_sessionInfo;
    static DefaultScreens.SessionAccess s_sessionAccess;
    static HttpSession s_httpSession;
    static SubpageContext s_subpageContext;
    static final Object SYNCHER;
    static String s_webcontentDirectory;
    static String s_servletTempDirectory;
    static Set<Thread> s_threadsWithoutSessionContext;

    public static void initUsageWithoutSessionContext() {
        s_usageWihtoutSessionContext = true;
    }

    public static void initUsageWithSessionContext() {
        s_usageWihtoutSessionContext = false;
        ThreadData td = ThreadData.getInstance(false);
        if (td != null) {
            td.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initCurrentThreadWithoutSessionContext() {
        Object object = SYNCHER;
        synchronized (object) {
            if (s_threadsWithoutSessionContext == null) {
                s_threadsWithoutSessionContext = new HashSet<Thread>();
            }
            s_threadsWithoutSessionContext.add(Thread.currentThread());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initCurrentThreadWithSessionContext() {
        Object object = SYNCHER;
        synchronized (object) {
            if (s_threadsWithoutSessionContext == null) {
                return;
            }
            s_threadsWithoutSessionContext.remove(Thread.currentThread());
            if (s_threadsWithoutSessionContext.isEmpty()) {
                s_threadsWithoutSessionContext = null;
            }
        }
        ThreadData td = ThreadData.getInstance(false);
        if (td != null) {
            td.destroy();
        }
    }

    public static boolean isUsedWithSessionContext() {
        return !UsageWithoutSessionContext.isUsedWithoutSessionContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isUsedWithoutSessionContext() {
        if (s_usageWihtoutSessionContext) {
            return true;
        }
        if (s_threadsWithoutSessionContext != null) {
            Object object = SYNCHER;
            synchronized (object) {
                if (s_threadsWithoutSessionContext.contains(Thread.currentThread())) {
                    return true;
                }
            }
        }
        return false;
    }

    public static SessionInfo getDummySessionInfo() {
        if (s_sessionInfo == null) {
            s_sessionInfo = SessionInfo.createDummySessionInfo();
        }
        return s_sessionInfo;
    }

    public static void setSessionInfo(SessionInfo si) {
        s_sessionInfo = si;
    }

    public static DefaultScreens.SessionAccess getDummySessionAccess() {
        if (s_sessionAccess == null) {
            s_sessionAccess = new DefaultScreens.SessionAccess(null);
        }
        return s_sessionAccess;
    }

    public static HttpSession getDummyHttpSession(boolean createIfNotExists) {
        if (s_httpSession == null && createIfNotExists) {
            s_httpSession = new DummyHttpSession();
        }
        return s_httpSession;
    }

    public static SubpageContext getDummySubpageContext() {
        if (s_subpageContext == null) {
            s_subpageContext = new SubpageContext(UsageWithoutSessionContext.getDummyHttpSession(true), "DUMMY");
        }
        return s_subpageContext;
    }

    public static void processThrowable(Throwable t) {
        if (s_usageWihtoutSessionContext) {
            return;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        throw new Error(t);
    }

    public static String getWebcontentDirectory() {
        return s_webcontentDirectory;
    }

    public static void setWebcontentDirectory(String webcontentDirectory) {
        s_webcontentDirectory = webcontentDirectory;
        if (s_webcontentDirectory != null) {
            FileManager.ensureDirectoryForFileExists(s_webcontentDirectory + "/dummy.txt");
        }
    }

    public static String getServletTempDirectory() {
        if (s_servletTempDirectory != null) {
            return s_servletTempDirectory;
        }
        try {
            String result = File.createTempFile("test", "test").getAbsolutePath();
            result = ValueManager.encodeIntoValidFileName(result, true);
            result = result.substring(0, result.length() - 9) + "cc/usagewithoutsessioncontext/servlettempdirectory/";
            FileManager.ensureDirectoryForFileExists(result + "test.test");
            return result;
        }
        catch (Throwable t) {
            throw new Error(t);
        }
    }

    public static void setServletTempDirectory(String servletTempDirectory) {
        s_servletTempDirectory = servletTempDirectory;
        if (s_servletTempDirectory != null) {
            FileManager.ensureDirectoryForFileExists(s_servletTempDirectory + "/dummy.txt");
        }
    }

    public static String findWebcontentDirectory() {
        if (s_webcontentDirectory != null) {
            return s_webcontentDirectory;
        }
        String s = System.getProperty("usagewithoutsessioncontext.webcontent.dir");
        if (s != null) {
            return s;
        }
        return null;
    }

    static {
        SYNCHER = new Object();
        s_webcontentDirectory = null;
        s_servletTempDirectory = null;
    }

    public static class DummyHttpSession
    implements HttpSession {
        Map<String, Object> i_attributes = new HashMap<String, Object>();
        long i_creationTime = System.currentTimeMillis();
        String i_id = UniqueIdCreator.createUUID();

        public Object getAttribute(String arg0) {
            return this.i_attributes.get(arg0);
        }

        public Enumeration<String> getAttributeNames() {
            ArrayList<String> keys = new ArrayList<String>(this.i_attributes.keySet());
            return Collections.enumeration(keys);
        }

        public long getCreationTime() {
            return this.i_creationTime;
        }

        public String getId() {
            return this.i_id;
        }

        public long getLastAccessedTime() {
            return this.i_creationTime;
        }

        public int getMaxInactiveInterval() {
            return 0;
        }

        public ServletContext getServletContext() {
            throw new Error("This function is not callable in mode UsageWithoutSessionContext");
        }

        public HttpSessionContext getSessionContext() {
            throw new Error("This function is not callable in mode UsageWithoutSessionContext");
        }

        public Object getValue(String arg0) {
            return this.getAttribute(arg0);
        }

        public String[] getValueNames() {
            String[] result = new String[this.i_attributes.keySet().size()];
            this.i_attributes.keySet().toArray(result);
            return result;
        }

        public void invalidate() {
        }

        public boolean isNew() {
            return false;
        }

        public void putValue(String arg0, Object arg1) {
            this.setAttribute(arg0, arg1);
        }

        public void removeAttribute(String arg0) {
            this.i_attributes.remove(arg0);
        }

        public void removeValue(String arg0) {
            this.i_attributes.remove(arg0);
        }

        public void setAttribute(String arg0, Object arg1) {
            this.i_attributes.put(arg0, arg1);
        }

        public void setMaxInactiveInterval(int arg0) {
        }
    }
}

