/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import java.lang.reflect.Method;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.HashSet;
import javax.faces.webapp.FacesServlet;
import javax.servlet.DispatcherType;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import org.eclnt.jsfserver.bufferedcontent.BufferedContentServlet;
import org.eclnt.jsfserver.bufferedcontent.UploadContentServlet;
import org.eclnt.jsfserver.calendar.ExtCalendarServlet;
import org.eclnt.jsfserver.configuration.CCConfigurationObjectLoader;
import org.eclnt.jsfserver.monitoring.MonitoringServlet;
import org.eclnt.jsfserver.monitoring.servertimeout.ServerTimeOutServlet;
import org.eclnt.jsfserver.polling.LongPollingServlet;
import org.eclnt.jsfserver.starter.RISCStarter;
import org.eclnt.jsfserver.util.AutoCompleteServlet;
import org.eclnt.jsfserver.util.CCInitializeServletsBase;
import org.eclnt.jsfserver.util.CCRedirectRiscExtensionServlet;
import org.eclnt.jsfserver.util.CLResourceAccessServlet;
import org.eclnt.jsfserver.util.CacheFilter;
import org.eclnt.jsfserver.util.ClientI18NReaderServlet;
import org.eclnt.jsfserver.util.CompressionFilter;
import org.eclnt.jsfserver.util.DynamicImageServlet;
import org.eclnt.jsfserver.util.ErrorAnonymizerFilter;
import org.eclnt.jsfserver.util.HttpHeaderAttributesForPagesFilter;
import org.eclnt.jsfserver.util.HttpSessionListenerDelegator;
import org.eclnt.jsfserver.util.ICCServerConstants;
import org.eclnt.jsfserver.util.ImageSizeServlet;
import org.eclnt.jsfserver.util.NoCacheNoStoreFilter;
import org.eclnt.jsfserver.util.RemoveBorderRadiusCssFilter;
import org.eclnt.jsfserver.util.ResourceAccessFilter;
import org.eclnt.jsfserver.util.ResponseLoggerFilter;
import org.eclnt.jsfserver.util.SameOriginFilterForHtml;
import org.eclnt.jsfserver.util.SecurityFilter;
import org.eclnt.jsfserver.util.SecurityFilterGeneral;
import org.eclnt.jsfserver.util.SecurityFilterPreflights;
import org.eclnt.jsfserver.util.SecurityFilterRemoteAddress;
import org.eclnt.jsfserver.util.SecurityFilterURLCheck;
import org.eclnt.jsfserver.util.SessionInvalidationServlet;
import org.eclnt.jsfserver.util.StyleReaderServlet;
import org.eclnt.jsfserver.util.SystemXml;
import org.eclnt.jsfserver.util.ThreadContextInitializerFilter;
import org.eclnt.jsfserver.util.ThreadingFilter;
import org.eclnt.jsfserver.util.security.ResourceSecurity;
import org.eclnt.jsfserver.util.tempfile.TempFileAccessServlet;
import org.eclnt.util.classresolver.CCClassResolver;
import org.eclnt.util.classresolver.ENUMCallerType;
import org.eclnt.util.file.ClassloaderReader;
import org.eclnt.util.log.CLog;

public class CCInitializeServlets
implements ICCServerConstants {
    static CCInitializeServlets s_instance;

    public static CCInitializeServlets instance() {
        return s_instance;
    }

    public static void initialize(ServletContext servletContext) {
        CCInitializeServlets.instance().initializeInstance(servletContext);
    }

    protected void initializeInstance(ServletContext servletContext) {
        CLog.L.log(CLog.LL_INF, "***********************************************************");
        CLog.L.log(CLog.LL_INF, "* CCInitializeServlets of: " + servletContext.getContextPath());
        try {
            CCInitializeServletsBase.initialize(servletContext);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.initializeFilters(servletContext);
        this.initializeListeners(servletContext);
        this.initializeServlets(servletContext);
        CLog.L.log(CLog.LL_INF, "***********************************************************");
    }

    protected void initializeFilters(ServletContext servletContext) {
        this.initializeFilter(servletContext, RemoveBorderRadiusCssFilter.class, "*.css");
        this.initializeFilter(servletContext, ErrorAnonymizerFilter.class, "/*");
        this.initializeFilter(servletContext, ThreadContextInitializerFilter.class, "/*");
        this.initializeFilter(servletContext, SecurityFilterPreflights.class, "/*");
        this.initializeFilter(servletContext, SecurityFilterURLCheck.class, "/faces/*", "*.ccbuffer", "/ccbuffer/*", "*.ccupload", "/cctempfileaccess/*");
        this.initializeFilter(servletContext, NoCacheNoStoreFilter.class, "*.jsp", "*.risc", "*.ccbuffer", "/ccbuffer/*", "/cctempfileaccess/*");
        this.initializeFilter(servletContext, HttpHeaderAttributesForPagesFilter.class, "*.risc", "*.html");
        this.initializeFilter(servletContext, SameOriginFilterForHtml.class, "/eclnt/risc/*");
        this.initializeFilter(servletContext, CacheFilter.class, "*.js", "*.css");
        this.initializeFilter(servletContext, CompressionFilter.class, "*.jsp", "*.xml", "*.css", "*.js", "*.ttf", "*.i18n", "*.json");
        this.initializeFilter(servletContext, ResponseLoggerFilter.class, "/*");
        this.initializeFilter(servletContext, SecurityFilterRemoteAddress.class, "/*");
        this.initializeFilter(servletContext, SecurityFilter.class, "*.jsp", "*.ccupload", "*.ccinvalidatesession");
        this.initializeFilter(servletContext, SecurityFilterGeneral.class, "/faces/*", "*.jsp", "*.ccbuffer", "/ccbuffer/*", "*.ccupload", "*.ccinvalidatesession", "*.ccautocomplete", "*.ccextcalendar", "*.cclongpolling", "/cctempfileaccess/*");
        this.initializeFilter(servletContext, ThreadingFilter.class, "/faces/*");
        this.initializeResourceAccessFilter(servletContext);
    }

    protected void initializeListeners(ServletContext servletContext) {
        this.initializeListener(servletContext, HttpSessionListenerDelegator.class);
    }

    protected void initializeServlets(ServletContext servletContext) {
        this.initializeServlet(servletContext, "Faces Servlet", FacesServlet.class, "/faces/*");
        this.initializeServlet(servletContext, BufferedContentServlet.class, "*.ccbuffer", "/ccbuffer/*");
        this.initializeServlet(servletContext, UploadContentServlet.class, "*.ccupload");
        this.initializeServlet(servletContext, SessionInvalidationServlet.class, "*.ccinvalidatesession");
        this.initializeServlet(servletContext, AutoCompleteServlet.class, "*.ccautocomplete");
        this.initializeServlet(servletContext, ExtCalendarServlet.class, "*.ccextcalendar");
        this.initializeServlet(servletContext, LongPollingServlet.class, "*.cclongpolling");
        this.initializeServlet(servletContext, RISCStarter.class, "*.risc");
        this.initializeServlet(servletContext, ImageSizeServlet.class, "/ccimagesize/*");
        this.initializeServlet(servletContext, DynamicImageServlet.class, "/ccdynamicimage/*", "*.ccsvg");
        this.initializeServlet(servletContext, CLResourceAccessServlet.class, "*.ccclresource");
        this.initializeServlet(servletContext, TempFileAccessServlet.class, "/cctempfileaccess/*");
        this.initializeServlet(servletContext, StyleReaderServlet.class, "/eclntjsfserver/styles/*");
        this.initializeServlet(servletContext, ClientI18NReaderServlet.class, "/clientlocalization.i18n");
        this.initializeServlet(servletContext, MonitoringServlet.class, "/ccstatus.ccstatus");
        this.initializeServlet(servletContext, ServerTimeOutServlet.class, "/cctimeout.cctimeout");
        String alternativeExtension = SystemXml.getRiscStarter().getAlternativeextension();
        if (alternativeExtension != null) {
            this.initializeServlet(servletContext, CCRedirectRiscExtensionServlet.class, "*" + alternativeExtension);
        }
        for (SystemXml.ServletData servletData : SystemXml.getAdditionalServlets()) {
            this.initializeServlet(servletContext, servletData.getClassname(), servletData.getMappings());
        }
    }

    protected void initializeListener(ServletContext servletContext, Class listenerClass) {
        try {
            CLog.L.log(CLog.LL_INF, "* Registration of listener: " + listenerClass.getName());
            EventListener listener = servletContext.createListener(listenerClass);
            servletContext.addListener(listener);
            servletContext.setAttribute("CCLISTENER_" + listenerClass.getName(), (Object)listener);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "* Registration of listener - failed: " + listenerClass.getName() + ": " + t.toString(), t);
            this.logTypicalErrorInfo();
        }
    }

    protected FilterRegistration initializeFilter(ServletContext servletContext, Class filterClass, String ... mappings) {
        try {
            CLog.L.log(CLog.LL_INF, "* Registration of filter: " + filterClass.getName());
            SystemXml.FilterConfiguration fc = SystemXml.getFilterConfiguration(filterClass);
            if (fc != null && !fc.isActive()) {
                CLog.L.log(CLog.LL_INF, "* ...filter is inactive due to system.xml configuration");
                return null;
            }
            FilterRegistration.Dynamic filter = servletContext.addFilter(filterClass.getName(), filterClass);
            if (filter == null) {
                filter = servletContext.getFilterRegistration(filterClass.getName());
            }
            if (filter != null) {
                EnumSet<DispatcherType> es = this.createDispatcherTypeEnumSetForFilter(filterClass);
                if (mappings != null) {
                    for (String mapping : mappings) {
                        try {
                            filter.addMappingForUrlPatterns(es, true, new String[]{mapping});
                            CLog.L.log(CLog.LL_INF, "*     added mapping: " + mapping);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
                if (fc != null && fc.getAdditionalMappings() != null) {
                    for (String mapping : fc.getAdditionalMappings()) {
                        try {
                            filter.addMappingForUrlPatterns(es, true, new String[]{mapping});
                            CLog.L.log(CLog.LL_INF, "*     added mapping: " + mapping);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
            }
            return filter;
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "* Registration of filter: " + filterClass.getName() + ": " + t.toString(), t);
            this.logTypicalErrorInfo();
            return null;
        }
    }

    private void logTypicalErrorInfo() {
        try {
            String path = this.getClass().getName().replace(".", "/") + "_error_registration.txt";
            String s = new ClassloaderReader(true).readUTF8File(path, false);
            CLog.L.log(CLog.LL_INF, s);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected EnumSet<DispatcherType> createDispatcherTypeEnumSetForFilter(Class filterClass) {
        return null;
    }

    protected void initializeResourceAccessFilter(ServletContext servletContext) {
        try {
            HashSet<String> mappings = new HashSet<String>();
            mappings.add("/eclnt/*");
            mappings.add("/eclntjsfserver/*");
            for (String extension : ResourceSecurity.s_extensionsWhiteList) {
                if (SystemXml.getResourceClassloaderAccessIgnoreExtensions().contains(extension)) continue;
                mappings.add("*." + extension);
            }
            for (String extension : SystemXml.getResourceClassloaderAccessAdditionalExtensions()) {
                if (extension == null || extension.equals("")) continue;
                if (extension.startsWith(".")) {
                    extension = extension.substring(1);
                }
                mappings.add("*." + extension);
                CLog.L.log(CLog.LL_INF, "*     added mapping: " + extension);
            }
            String[] mappingsArray = new String[mappings.size()];
            mappings.toArray(mappingsArray);
            FilterRegistration filterRegistration = this.initializeFilter(servletContext, ResourceAccessFilter.class, mappingsArray);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "* Registration of filter - failed: " + ResourceAccessFilter.class.getName(), t);
        }
    }

    protected void initializeServlet(ServletContext servletContext, String className, String ... mappings) {
        try {
            Class c = CCClassResolver.resolveClass(className, ENUMCallerType.CONFIGURATION);
            this.initializeServlet(servletContext, c.getName(), c, mappings);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Problem adding servlet: " + className);
        }
    }

    protected void initializeServlet(ServletContext servletContext, Class servletClass, String ... mappings) {
        this.initializeServlet(servletContext, servletClass.getSimpleName(), servletClass, mappings);
    }

    protected void initializeServlet(ServletContext servletContext, String servletName, Class servletClass, String ... mappings) {
        block15: {
            try {
                CLog.L.log(CLog.LL_INF, "* Registration of servlet: " + servletClass.getName());
                SystemXml.ServletConfiguration sc = SystemXml.getServletConfiguration(servletClass);
                if (sc != null && !sc.isActive()) {
                    CLog.L.log(CLog.LL_INF, "* ...servlet is inactive due to system.xml configuration");
                    return;
                }
                ServletRegistration.Dynamic servletReg = servletContext.addServlet(servletName, servletClass.getName());
                if (servletReg == null) {
                    servletReg = servletContext.getServletRegistration(servletName);
                }
                if (servletReg != null && mappings != null) {
                    for (String mapping : mappings) {
                        try {
                            servletReg.addMapping(new String[]{mapping});
                            CLog.L.log(CLog.LL_INF, "*     added mapping: " + mapping);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    if (servletReg instanceof ServletRegistration.Dynamic) {
                        servletReg.setLoadOnStartup(1);
                    }
                    if (sc != null && sc.getAdditionalMappings() != null) {
                        for (String mapping : sc.getAdditionalMappings()) {
                            try {
                                servletReg.addMapping(new String[]{mapping});
                                CLog.L.log(CLog.LL_INF, "*     added mapping: " + mapping);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }
                }
                if (servletReg == null || !(servletReg instanceof ServletRegistration.Dynamic)) break block15;
                try {
                    this.manageServletSecuritySettings(servletContext, servletClass, servletReg);
                }
                catch (Throwable t) {
                    throw new Error(t);
                }
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_INF, "* Registration of servlet: " + servletClass.getName() + ": " + t.toString(), t);
                this.logTypicalErrorInfo();
            }
        }
    }

    protected void manageServletSecuritySettings(ServletContext servletContext, Class servletClass, ServletRegistration.Dynamic servletReg) {
        String methodName = "manageSecuritySettings";
        try {
            Method m = servletClass.getMethod(methodName, ServletContext.class, ServletRegistration.Dynamic.class);
            m.invoke(null, servletContext, servletReg);
        }
        catch (NoSuchMethodException m) {
        }
        catch (Throwable t) {
            throw new Error("Problem calling method " + methodName + " in class: " + servletClass.getName(), t);
        }
    }

    static {
        try {
            String className = SystemXml.getServletContextConfigurationIntializationClass();
            s_instance = (CCInitializeServlets)CCConfigurationObjectLoader.instance().loadInstance(className, true);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Problem when initializing CCInitializeServlets", t);
            throw new Error(t);
        }
    }
}

