/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.eclnt.jsfserver.util.ServletUtil;
import org.eclnt.jsfserver.util.SystemXml;

public class HttpHeaderAttributesForPagesFilter
implements Filter {
    public static final String DEFAULT_XSSPROTECTION = "1; mode=block";
    public static final String DEFAULT_XCONTENTYPEOPTIONS = "nosniff";
    public static final String DEFAULT_CONTENTSECURITYPOLICY = "default-src 'self' data: 'unsafe-inline' 'unsafe-eval'; img-src * data:";
    public static final String DEFAULT_REFERRERPOLICY = "same-origin";

    public void doFilter(ServletRequest servletrequest, ServletResponse servletresponse, FilterChain filterchain) throws IOException, ServletException {
        if (servletrequest instanceof HttpServletRequest) {
            HttpServletRequest httpservletrequest = (HttpServletRequest)servletrequest;
            HttpServletResponse httpservletresponse = (HttpServletResponse)servletresponse;
            MyResponseWrapper responsewrapper = new MyResponseWrapper(httpservletresponse);
            filterchain.doFilter(servletrequest, (ServletResponse)responsewrapper);
        } else {
            filterchain.doFilter(servletrequest, servletresponse);
        }
    }

    public void init(FilterConfig filterconfig) {
    }

    public void destroy() {
    }

    class MyResponseWrapper
    extends HttpServletResponseWrapper {
        HttpServletResponse i_response;

        public MyResponseWrapper(HttpServletResponse response) {
            super(response);
            this.i_response = response;
        }

        public void setContentType(String contentType) {
            String v = SystemXml.getHttpheaderattributesforpages_xxssprotection();
            if (v == null) {
                v = HttpHeaderAttributesForPagesFilter.DEFAULT_XSSPROTECTION;
            }
            if (v.length() > 0) {
                ServletUtil.setResponseHeader(this.i_response, "x-xss-protection", v);
            }
            if ((v = SystemXml.getHttpheaderattributesforpages_xcontenttypeoptions()) == null) {
                v = HttpHeaderAttributesForPagesFilter.DEFAULT_XCONTENTYPEOPTIONS;
            }
            if (v.length() > 0) {
                ServletUtil.setResponseHeader(this.i_response, "x-content-type-options", v);
            }
            if ((v = SystemXml.getHttpheaderattributesforpages_contentsecuritypolicy()) == null) {
                v = HttpHeaderAttributesForPagesFilter.DEFAULT_CONTENTSECURITYPOLICY;
            }
            if (v.length() > 0) {
                ServletUtil.setResponseHeader(this.i_response, "content-security-policy", v);
            }
            if ((v = SystemXml.getHttpheaderattributesforpages_referrerpolicy()) == null) {
                v = HttpHeaderAttributesForPagesFilter.DEFAULT_REFERRERPOLICY;
            }
            if (v.length() > 0) {
                ServletUtil.setResponseHeader(this.i_response, "referrer-policy", v);
            }
            ServletUtil.setResponseContentType(this.i_response, contentType);
        }
    }
}

