/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclnt.jsfserver.configuration.CCConfigurationObject;
import org.eclnt.jsfserver.util.CCFilterBase;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.ICCServerConstants;
import org.eclnt.jsfserver.util.ServletUtil;
import org.eclnt.jsfserver.util.SessionCheckError;
import org.eclnt.jsfserver.util.SystemXml;
import org.eclnt.jsfserver.util.ThreadingFilter;
import org.eclnt.jsfserver.util.TypeOfSessionMgmt;
import org.eclnt.jsfserver.util.security.StringHider;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.UniqueIdCreator;

public class SecurityFilter
extends CCFilterBase
implements Filter,
ICCServerConstants {
    static final String CCSESSIONCHECKID = "ccsessioncheckid";
    static final String CCSESSIONCHECKID_CLIENTTYPE = "ccsessioncheckid_clienttype";
    static final String CCSESSIONCHECKID_TREATED = "ccsessioncheckid_treated";
    static boolean s_initialized = false;
    static CCConfigurationObject<IExtension> s_extension = new CCConfigurationObject<Object>(null);
    static Object SYNCHER = new Object();

    @Override
    public void init(FilterConfig arg0) throws ServletException {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void doFilterExecute(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.initExtension();
        boolean executeCheck = true;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        HttpSession session = httpRequest.getSession(false);
        if (session == null || TypeOfSessionMgmt.getSessionMgmtViaCookie(session)) {
            executeCheck = false;
        } else if (s_extension != null && s_extension.instance() != null) {
            executeCheck = s_extension.instance().checkIfToExecuteCheck(request);
        }
        if (executeCheck && !HttpSessionAccess.checkIfCurrentClientTypeIsRisc(httpRequest) && (httpRequest.getRequestURI().contains("/ccupload/") || httpRequest.getRequestURI().contains(".ccupload"))) {
            executeCheck = false;
        }
        if (executeCheck && request instanceof HttpServletRequest) {
            ThreadingFilter.checkRequestForNoData(httpRequest);
            HttpSession httpSession = httpRequest.getSession();
            String clientType = HttpSessionAccess.getCurrentClientType(httpRequest);
            String ccSessionCheckIdHere = SecurityFilter.getCurrentCCSessionId(httpSession);
            String ccSessionCheckIdRequest = this.readCCSessionCheckIdFromRequest(httpRequest, clientType);
            boolean ccSessionTreated = false;
            try {
                ccSessionTreated = (Boolean)httpSession.getAttribute(CCSESSIONCHECKID_TREATED);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (!ccSessionTreated) {
                ccSessionCheckIdHere = null;
                ccSessionCheckIdRequest = null;
            }
            if (ccSessionCheckIdRequest == null) {
                if (ccSessionCheckIdHere != null) {
                    SessionCheckError se = new SessionCheckError();
                    CLog.L.log(CLog.LL_ERR, "A request without ccsessioncheckid tried to connect into a session with ccsessioncheckid", se);
                    throw se;
                }
                ccSessionCheckIdHere = UniqueIdCreator.createRandomId();
                SecurityFilter.setCurrentCCSessionId(httpSession, ccSessionCheckIdHere);
                httpSession.setAttribute(CCSESSIONCHECKID_CLIENTTYPE, (Object)clientType);
                this.writeCCSessionCheckIdIntoResponse(httpResponse, clientType, ccSessionCheckIdHere);
            } else {
                if (ccSessionCheckIdHere == null) {
                    SessionCheckError se = new SessionCheckError();
                    CLog.L.log(CLog.LL_ERR, "A request with ccsessioncheckid tried to connect into a session without ccsessioncheckid", se);
                    throw se;
                }
                String clientTypeHere = (String)httpSession.getAttribute(CCSESSIONCHECKID_CLIENTTYPE);
                if (clientTypeHere != null && !clientTypeHere.equals(clientType)) {
                    SessionCheckError se = new SessionCheckError();
                    CLog.L.log(CLog.LL_ERR, "A request with ccsessioncheckid tried to connect into a session with ccsessioncheckid. The client type of the session does not correspond to the client type of the request.", se);
                    throw se;
                }
                if (!ccSessionCheckIdRequest.equals(ccSessionCheckIdHere)) {
                    SessionCheckError se = new SessionCheckError();
                    CLog.L.log(CLog.LL_ERR, "A request was processed having a ccsessioncheckid that does not match the server sessions's ccsessioncheckid", se);
                    throw se;
                }
                this.writeCCSessionCheckIdIntoResponse(httpResponse, clientType, ccSessionCheckIdHere);
            }
            httpSession.setAttribute(CCSESSIONCHECKID_TREATED, (Object)true);
        }
        chain.doFilter(request, response);
    }

    public static String getCurrentCCSessionId(HttpSession session) {
        StringHider result = (StringHider)session.getAttribute(CCSESSIONCHECKID);
        if (result == null) {
            return null;
        }
        return result.getValue();
    }

    public static void setCurrentCCSessionId(HttpSession session, String sessionCheckId) {
        session.setAttribute(CCSESSIONCHECKID, (Object)new StringHider(sessionCheckId));
    }

    public void destroy() {
    }

    private String readCCSessionCheckIdFromRequest(HttpServletRequest httpRequest, String clientType) {
        if ("applet".equals(clientType) || "webstart".equals(clientType) || "application".equals(clientType) || "ui5".equals(clientType) || "risc".equals(clientType)) {
            return httpRequest.getParameter(CCSESSIONCHECKID);
        }
        if ("browser".equals(clientType)) {
            Cookie[] cookies = httpRequest.getCookies();
            if (cookies == null) {
                return null;
            }
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(CCSESSIONCHECKID)) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    private void writeCCSessionCheckIdIntoResponse(HttpServletResponse httpResponse, String clientType, String ccSessionCheckId) {
        if ("applet".equals(clientType) || "webstart".equals(clientType) || "application".equals(clientType) || "ui5".equals(clientType) || "risc".equals(clientType)) {
            ServletUtil.setResponseHeader(httpResponse, CCSESSIONCHECKID, ccSessionCheckId);
        } else if ("browser".equals(clientType)) {
            Cookie cookie = new Cookie(CCSESSIONCHECKID, ServletUtil.sanitizeCookieValue(ccSessionCheckId));
            cookie.setSecure(true);
            httpResponse.addCookie(cookie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initExtension() {
        if (!s_initialized) {
            Object object = SYNCHER;
            synchronized (object) {
                if (!s_initialized) {
                    try {
                        String className = SystemXml.getSecurityfilterextensionclassname();
                        if (className != null) {
                            s_extension = new CCConfigurationObject(className, null);
                        }
                    }
                    catch (Throwable t) {
                        CLog.L.log(CLog.LL_ERR, "Problem initializing the security filter extension", t);
                    }
                    s_initialized = true;
                }
            }
        }
    }

    public static interface IExtension {
        public boolean checkIfToExecuteCheck(ServletRequest var1);
    }
}

