/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import java.util.ArrayList;
import java.util.List;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;
import javax.el.ValueExpression;
import javax.faces.application.Application;
import org.eclnt.jsfserver.util.StackedValueExpression;
import org.eclnt.util.valuemgmt.ValueManager;

public class StackedComplexValueExpressionConcat
extends ValueExpression {
    Application m_app;
    String m_vbStringOriginal;
    List<ExpressionLocation> m_expressionLocations = new ArrayList<ExpressionLocation>();

    public StackedComplexValueExpressionConcat(Application app, String vbString) {
        if (vbString == null) {
            throw new Error("Value binding string must not be null");
        }
        if (vbString.length() == 0) {
            throw new Error("Value binding string must not be empty");
        }
        this.m_app = app;
        this.m_vbStringOriginal = vbString;
        this.parseString();
    }

    public Object getValue(ELContext elContext) throws NullPointerException, PropertyNotFoundException, ELException {
        try {
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < this.m_expressionLocations.size(); ++i) {
                ExpressionLocation el = this.m_expressionLocations.get(i);
                if (i == 0) {
                    result.append(this.m_vbStringOriginal.substring(0, el.i_start));
                } else {
                    ExpressionLocation prevEl = this.m_expressionLocations.get(i - 1);
                    result.append(this.m_vbStringOriginal.substring(prevEl.i_end, el.i_start));
                }
                Object expressionValue = el.i_valueExpression.getValue(elContext);
                String sValue = ValueManager.convertObject2ValueString(expressionValue);
                if (sValue != null) {
                    result.append(sValue);
                }
                if (i != this.m_expressionLocations.size() - 1) continue;
                result.append(this.m_vbStringOriginal.substring(el.i_end));
            }
            return result.toString();
        }
        catch (Throwable t) {
            throw new Error("Error when resolving the expression: " + this.m_vbStringOriginal, t);
        }
    }

    public Class<?> getExpectedType() {
        return String.class;
    }

    public Class<?> getType(ELContext arg0) throws NullPointerException, PropertyNotFoundException, ELException {
        return String.class;
    }

    public boolean isReadOnly(ELContext arg0) throws NullPointerException, PropertyNotFoundException, ELException {
        return true;
    }

    public void setValue(ELContext arg0, Object arg1) throws NullPointerException, PropertyNotFoundException, PropertyNotWritableException, ELException {
        throw new Error("Not supported with complex expression");
    }

    public boolean equals(Object arg0) {
        throw new Error("Not supported with complex expression");
    }

    public String getExpressionString() {
        return this.m_vbStringOriginal;
    }

    public int hashCode() {
        return this.m_vbStringOriginal.hashCode();
    }

    public boolean isLiteralText() {
        return false;
    }

    private void parseString() {
        this.m_expressionLocations.clear();
        try {
            int indexEnd;
            int indexStart;
            Object current = null;
            int currentPos = 0;
            while ((indexStart = this.m_vbStringOriginal.indexOf("#{", currentPos)) >= 0 && (indexEnd = this.m_vbStringOriginal.indexOf("}", indexStart)) >= 0) {
                ExpressionLocation el = new ExpressionLocation();
                el.i_start = indexStart;
                el.i_end = indexEnd + 1;
                el.i_valueExpression = new StackedValueExpression(this.m_app, this.m_vbStringOriginal.substring(indexStart, indexEnd + 1));
                this.m_expressionLocations.add(el);
                currentPos = indexEnd + 1;
            }
            if (this.m_expressionLocations.size() == 0) {
                throw new Error("This is not a concatenated value expression: " + this.m_vbStringOriginal);
            }
        }
        catch (Throwable t) {
            throw new Error("Problem parsing expression: " + this.m_vbStringOriginal, t);
        }
    }

    private class ExpressionLocation {
        int i_start = -1;
        int i_end = -1;
        StackedValueExpression i_valueExpression;

        private ExpressionLocation() {
        }
    }
}

