/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util.buffermgmt;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclnt.jsfserver.elements.adapter.ReflectionAnalyzer;
import org.eclnt.jsfserver.elements.impl.ROWINCLUDEComponent;
import org.eclnt.jsfserver.pagebean.component.PageBeanComponentRepository;
import org.eclnt.jsfserver.util.CCELResolver;
import org.eclnt.jsfserver.util.CSSStyleManager;
import org.eclnt.jsfserver.util.ClientI18NReader;
import org.eclnt.jsfserver.util.StyleManager;
import org.eclnt.jsfserver.util.WebResourceClassloaderReader;
import org.eclnt.jsfserver.util.webappfiles.WebappDirectoryManager;
import org.eclnt.util.buffermgmt.IResetBuffer;
import org.eclnt.util.buffermgmt.ResetBuffers;
import org.eclnt.util.file.ClassloaderReader;
import org.eclnt.util.image.ServerImageManager;
import org.eclnt.util.log.CLog;

public class CCResetBuffers {
    static final IResetBuffer s_resetBufferClassSwap;
    static final Set<IResetBuffer> s_resetBuffersLayout;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListenerLayoutReset(IResetBuffer resetBuffer) {
        Set<IResetBuffer> set = s_resetBuffersLayout;
        synchronized (set) {
            s_resetBuffersLayout.add(resetBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeListenerLayoutReset(IResetBuffer resetBuffer) {
        Set<IResetBuffer> set = s_resetBuffersLayout;
        synchronized (set) {
            s_resetBuffersLayout.remove(resetBuffer);
        }
    }

    public static void resetBuffers() {
        CCResetBuffers.resetLayoutRelatedBuffers();
        ResetBuffers.resetBuffers();
    }

    private static void resetLayoutRelatedBuffers() {
        try {
            WebappDirectoryManager.reset();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            StyleManager.reset();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            CSSStyleManager.reset();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            ClientI18NReader.reset();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            ROWINCLUDEComponent.clearLayoutBuffer();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            ServerImageManager.getInstance().clear();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            WebResourceClassloaderReader.resetBuffers();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            ClassloaderReader.resetBuffers();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ArrayList<IResetBuffer> l = new ArrayList<IResetBuffer>(s_resetBuffersLayout);
        for (IResetBuffer rb : l) {
            try {
                rb.reset();
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_ERR, "Problem occurred when resetting buffer: " + rb.getClass().getName(), t);
            }
        }
    }

    public static void resetBuffersForPagePreview() {
        ROWINCLUDEComponent.clearLayoutBuffer();
    }

    private static void resetClassRelatedBuffers() {
        try {
            CCELResolver.resetBuffers();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            ReflectionAnalyzer.resetBuffers();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            PageBeanComponentRepository.resetBuffers();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        s_resetBuffersLayout = new HashSet<IResetBuffer>();
        s_resetBufferClassSwap = new IResetBuffer(){

            @Override
            public void reset() {
                CCResetBuffers.resetClassRelatedBuffers();
            }
        };
        ResetBuffers.addListenerClassSwap(s_resetBufferClassSwap);
    }
}

