/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util.el;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExpressionVariableFinderCL {
    public static List<String> findVariables(String expression) {
        ArrayList<String> variables = new ArrayList<String>();
        ArrayList<String> expressionRegions = new ArrayList<String>();
        Pattern regionPattern = Pattern.compile("#\\{[^}]*\\}");
        Matcher regionMatcher = regionPattern.matcher(expression);
        while (regionMatcher.find()) {
            String region = regionMatcher.group();
            String content = region.substring(2, region.length() - 1);
            expressionRegions.add(content);
        }
        for (String region : expressionRegions) {
            ArrayList<int[]> quotedRanges = new ArrayList<int[]>();
            Pattern doubleQuotePattern = Pattern.compile("\"[^\"]*\"");
            Matcher doubleQuoteMatcher = doubleQuotePattern.matcher(region);
            while (doubleQuoteMatcher.find()) {
                int end;
                int start = doubleQuoteMatcher.start();
                if (ExpressionVariableFinderCL.isInsideBrackets(region, start, end = doubleQuoteMatcher.end())) continue;
                quotedRanges.add(new int[]{start, end});
            }
            Pattern singleQuotePattern = Pattern.compile("'[^']*'");
            Matcher singleQuoteMatcher = singleQuotePattern.matcher(region);
            while (singleQuoteMatcher.find()) {
                int end;
                int start = singleQuoteMatcher.start();
                if (ExpressionVariableFinderCL.isInsideBrackets(region, start, end = singleQuoteMatcher.end())) continue;
                quotedRanges.add(new int[]{start, end});
            }
            String regex = "(?<=^|[ *+\\-()!=<>|&{}#])([a-zA-Z_][a-zA-Z0-9_]*(?:(?:\\[[^\\]]*\\])|(?:\\.\\[[^\\]]*\\])|(?:\\.[a-zA-Z0-9_]+))+)(?=$|[ *+\\-()!=<>|&{}#])|^([a-zA-Z_][a-zA-Z0-9_]*(?:(?:\\[[^\\]]*\\])|(?:\\.\\[[^\\]]*\\])|(?:\\.[a-zA-Z0-9_]+))+)(?=$|[ *+\\-()!=<>|&{}#])";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(region);
            while (matcher.find()) {
                String match = matcher.group();
                int matchStart = matcher.start();
                int matchEnd = matcher.end();
                if (!ExpressionVariableFinderCL.containsDotOutsideBrackets(match) && !match.contains("[")) continue;
                boolean insideQuotes = false;
                for (int[] range : quotedRanges) {
                    if (matchStart < range[0] || matchEnd > range[1]) continue;
                    insideQuotes = true;
                    break;
                }
                if (insideQuotes) continue;
                variables.add(match);
            }
        }
        return variables;
    }

    private static boolean isInsideBrackets(String expression, int start, int end) {
        int openBrackets = 0;
        for (int i = 0; i < start; ++i) {
            if (expression.charAt(i) == '[') {
                ++openBrackets;
                continue;
            }
            if (expression.charAt(i) != ']') continue;
            --openBrackets;
        }
        return openBrackets > 0;
    }

    private static boolean containsDotOutsideBrackets(String str) {
        int bracketDepth = 0;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '[') {
                ++bracketDepth;
                continue;
            }
            if (c == ']') {
                --bracketDepth;
                continue;
            }
            if (c != '.' || bracketDepth != 0) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        String[] testExpressions;
        for (String expr : testExpressions = new String[]{"#{d.xx.xx == null ||d.yy.yy!=d.jj} Hallo", "a.b + c.d.e * (f.g - h.i.j.k)", "simple.var", "(x.y) + (z.w.v)", "no variables here", "a.b==c.d", "Hallo \"sss.sss\" Welt", "a.b + \"ignored.var\" + c.d", "x.y + 'also.ignored' + z.w", "list[0].value + array[i].name", "data[key].property[index].field", "This is aaa.bbb[\"1.2.3\"] it!", "obj.prop['key.with.dots'].value", "array[0].field + \"text.with.dots\"", "#{d.userName && (d.xxx.[0] || !d.yyy.yyy == 34)}", "#{aaa.aaa && bbb.bbb} is ccc.ccc", "#{x.y} and #{z.w} but not a.b"}) {
            System.out.println("Expression: " + expr);
            List<String> vars = ExpressionVariableFinderCL.findVariables(expr);
            System.out.println("Variables found: " + vars);
            System.out.println();
        }
    }
}

