/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util.fixgridpersistence;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.context.FacesContext;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import org.eclnt.jsfserver.elements.impl.FIXGRIDBinding;
import org.eclnt.jsfserver.elements.impl.FIXGRIDComponent;
import org.eclnt.jsfserver.elements.impl.IFIXGRIDBinding;
import org.eclnt.jsfserver.elements.impl.IFIXGRIDColumnInfo;
import org.eclnt.jsfserver.elements.impl.IFIXGRIDPersistence;
import org.eclnt.jsfserver.elements.impl.IFIXGRIDPersistence2;
import org.eclnt.jsfserver.pagebean.IPageBean;
import org.eclnt.jsfserver.streamstore.StreamStore;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.fixgridpersistence.GridColumnSequenceInfo;
import org.eclnt.jsfserver.util.fixgridpersistence.GridColumnSortInfo;
import org.eclnt.jsfserver.util.fixgridpersistence.GridColumnWidthInfo;
import org.eclnt.jsfserver.util.fixgridpersistence.GridInfo;
import org.eclnt.jsfserver.util.useraccess.UserAccessMgr;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;

public class DefaultFIXGRIDPersistence
implements IFIXGRIDPersistence2 {
    static boolean s_storeSortInfo = true;
    static boolean s_appendNewColumnsToTheEnd = true;

    public static void initStoreSortInfo(boolean value) {
        s_storeSortInfo = value;
    }

    public static void initAppendNewColumnsToTheEnd(boolean value) {
        s_appendNewColumnsToTheEnd = value;
    }

    @Override
    public IFIXGRIDPersistence.PersistentInfo readPersistentInfo(FacesContext context, FIXGRIDBinding gridBinding, String pageName, String persistId) {
        try {
            GridInfo gi = this.readGridInfo(context, gridBinding, pageName, persistId);
            if (gi != null) {
                return DefaultFIXGRIDPersistence.applyPersistentInfoFromGridInfo(gridBinding, gi);
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Problem when reading persitent info for grid occurred", t);
        }
        return null;
    }

    public static IFIXGRIDPersistence.PersistentInfo applyPersistentInfoFromGridInfo(final FIXGRIDBinding gridBinding, final GridInfo gi) {
        if (gridBinding.isInitialized()) {
            return DefaultFIXGRIDPersistence.applyPersistentInfoFromGridInfoExecute(gridBinding, gi);
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                DefaultFIXGRIDPersistence.applyPersistentInfoFromGridInfoExecute(gridBinding, gi);
            }
        };
        gridBinding.executeOnInitializedGrid(r);
        return null;
    }

    @Override
    public void updatePersistentInfo(FacesContext context, FIXGRIDBinding gridBinding, String pageName, String persistId, IFIXGRIDPersistence.PersistentInfo persistentInfo) {
        try {
            GridInfo gi = DefaultFIXGRIDPersistence.createGridInfo(gridBinding, persistentInfo);
            this.updateGridInfo(context, gridBinding, pageName, persistId, persistentInfo, gi);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problems when updating persistence of FIXGRID: ", t);
        }
    }

    public GridInfo readGridInfoForGrid(IPageBean pageBean, String persistId) {
        GridInfo result = this.readGridInfo(HttpSessionAccess.getCurrentFacesContext(), null, pageBean.getPageName(), persistId);
        return result;
    }

    public void applySortInfoFromGridInfo(FIXGRIDBinding gridBinding, GridInfo gi) {
        if (gi == null || gi.getColumnSortInfos().size() == 0) {
            return;
        }
        DefaultFIXGRIDPersistence.applyPersistentSortInfoFromGridInfoExecute(gridBinding, gi);
    }

    public static GridInfo createGridInfo(FIXGRIDBinding gridBinding, IFIXGRIDPersistence.PersistentInfo persistentInfo) {
        try {
            Map<String, IFIXGRIDBinding.FIXGRIDSortInfo> sis;
            List<FIXGRIDComponent.ColumnInfo> columnInfos = gridBinding.getColumnInfos();
            GridInfo gi = new GridInfo();
            gi.setNumberOfFixColumns(gridBinding.getNumberOfFixColumns());
            String columnSequence = persistentInfo.getColumnSequence();
            String columnWidths = persistentInfo.getColumnWidths();
            if (columnSequence != null) {
                int[] indices = ValueManager.decodeStraightIntCSV(columnSequence);
                HashSet<Integer> treatedIndices = new HashSet<Integer>();
                for (int index : indices) {
                    treatedIndices.add(index);
                    IFIXGRIDColumnInfo ci = columnInfos.get(index);
                    GridColumnSequenceInfo si = new GridColumnSequenceInfo();
                    si.setIndex(index);
                    si.setPersistId(ci.getPersistId());
                    si.setSortReference(ci.getSortreference());
                    gi.getColumnSequenceInfos().add(si);
                }
                for (int i = 0; i < columnInfos.size(); ++i) {
                    if (treatedIndices.contains(i)) continue;
                    IFIXGRIDColumnInfo ci = columnInfos.get(i);
                    GridColumnSequenceInfo si = new GridColumnSequenceInfo();
                    si.setIndex(-1);
                    si.setPersistId(ci.getPersistId());
                    si.setSortReference(ci.getSortreference());
                    gi.getColumnSequenceExcludedInfos().add(si);
                }
            }
            if (columnWidths != null) {
                String[] widths = ValueManager.decodeCSV(columnWidths);
                for (int i = 0; i < widths.length; ++i) {
                    IFIXGRIDColumnInfo ci = columnInfos.get(i);
                    GridColumnWidthInfo wi = new GridColumnWidthInfo();
                    wi.setPersistId(ci.getPersistId());
                    wi.setSortReference(ci.getSortreference());
                    wi.setWidth(widths[i]);
                    gi.getColumnWidthInfos().add(wi);
                }
            }
            if (s_storeSortInfo && (sis = gridBinding.getSortInfo()) != null) {
                for (IFIXGRIDBinding.FIXGRIDSortInfo si : sis.values()) {
                    if (si.getSortStatusInt() == 0) continue;
                    GridColumnSortInfo gcsi = new GridColumnSortInfo();
                    gcsi.setSortStatus(si.getSortStatusInt());
                    gcsi.setSortSequence(si.getSortSequence());
                    gcsi.setSortReference(si.getSortReference());
                    gi.getColumnSortInfos().add(gcsi);
                }
            }
            return gi;
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problems when updating persistence of FIXGRID: ", t);
            return null;
        }
    }

    protected String readSerializedPersistentInfo(FacesContext context, FIXGRIDBinding gridBinding, String pageName, String persistId) {
        String xml = StreamStore.getInstance().readUTF8(DefaultFIXGRIDPersistence.buildPath(persistId, pageName), false);
        return xml;
    }

    protected GridInfo readGridInfo(FacesContext context, FIXGRIDBinding gridBinding, String pageName, String persistId) {
        try {
            String xml = this.readSerializedPersistentInfo(context, gridBinding, pageName, persistId);
            if (xml == null || xml.length() == 0) {
                return null;
            }
            Source r = ValueManager.convertStringIntoXMLSource(xml);
            JAXBContext jbContext = JAXBContext.newInstance((Class[])new Class[]{GridInfo.class});
            Unmarshaller um = jbContext.createUnmarshaller();
            GridInfo gi = (GridInfo)um.unmarshal(r);
            this.removeWrongValuesFromGridInfo(gi);
            return gi;
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Problem when reading grid info info for grid occurred", t);
            return null;
        }
    }

    private void removeWrongValuesFromGridInfo(GridInfo gi) {
        for (GridColumnWidthInfo cwi : gi.getColumnWidthInfos()) {
            String w = cwi.getWidth();
            if (w == null || !(w = w.trim()).endsWith("%")) continue;
            if (!(w = w.substring(0, w.length() - 1)).startsWith("-")) {
                w = "-" + w;
            }
            cwi.setWidth(w);
        }
    }

    public void junit_removeWrongValuesFromGridInfo(GridInfo gi) {
        this.removeWrongValuesFromGridInfo(gi);
    }

    public static void resetGrid(FIXGRIDBinding<?> grid) {
        grid.setColumnsequence(null);
        grid.setModcolumnwidths(null);
        grid.clearSortInfo();
    }

    private static void applyPersistentSortInfoFromGridInfoExecute(FIXGRIDBinding gridBinding, GridInfo gi) {
        if (s_storeSortInfo) {
            gridBinding.getSortInfo().clear();
            for (GridColumnSortInfo gcsi : gi.getColumnSortInfos()) {
                IFIXGRIDBinding.FIXGRIDSortInfo si = gridBinding.getSortInfoForReference(gcsi.getSortReference());
                si.setSortSequence(gcsi.getSortSequence());
                si.setSortStatus(gcsi.getSortStatus());
            }
            gridBinding.resort();
        }
    }

    private static IFIXGRIDPersistence.PersistentInfo applyPersistentInfoFromGridInfoExecute(FIXGRIDBinding gridBinding, GridInfo gi) {
        gridBinding.setNumberOfFixColumns(gi.getNumberOfFixColumns());
        List<IFIXGRIDColumnInfo> columnInfos = gridBinding.getColumnInfos();
        IFIXGRIDPersistence.PersistentInfo result = new IFIXGRIDPersistence.PersistentInfo();
        if (gi.getColumnSequenceInfos().size() > 0) {
            int index;
            HashSet<Integer> treatedIndices = new HashSet<Integer>();
            ArrayList<String> cols = new ArrayList<String>();
            for (GridColumnSequenceInfo si : gi.getColumnSequenceInfos()) {
                index = DefaultFIXGRIDPersistence.findColumnIndex(si, columnInfos, treatedIndices);
                if (index < 0) continue;
                cols.add(index + "");
                treatedIndices.add(index);
            }
            for (GridColumnSequenceInfo si : gi.getColumnSequenceExcludedInfos()) {
                index = DefaultFIXGRIDPersistence.findColumnIndex(si, columnInfos, null);
                if (index < 0) continue;
                treatedIndices.add(index);
            }
            if (s_appendNewColumnsToTheEnd) {
                for (int i = 0; i < columnInfos.size(); ++i) {
                    if (treatedIndices.contains(i)) continue;
                    cols.add(i + "");
                }
            }
            result.setColumnSequence(ValueManager.encodeCSV(cols));
        }
        if (gi.getColumnWidthInfos().size() > 0) {
            String[] widths = new String[columnInfos.size()];
            for (int i = 0; i < widths.length; ++i) {
                widths[i] = "100";
            }
            for (GridColumnWidthInfo wi : gi.getColumnWidthInfos()) {
                int index = DefaultFIXGRIDPersistence.findColumnIndex(wi, columnInfos);
                if (index < 0 || index >= widths.length) continue;
                widths[index] = wi.getWidth();
            }
            result.setColumnWidths(ValueManager.encodeCSV(widths));
        }
        if (s_storeSortInfo) {
            gridBinding.getSortInfo().clear();
            for (GridColumnSortInfo gcsi : gi.getColumnSortInfos()) {
                IFIXGRIDBinding.FIXGRIDSortInfo si = gridBinding.getSortInfoForReference(gcsi.getSortReference());
                si.setSortSequence(gcsi.getSortSequence());
                si.setSortStatus(gcsi.getSortStatus());
            }
            gridBinding.resort();
        }
        gridBinding.applyPersistentData(result);
        return result;
    }

    private static int findColumnIndex(GridColumnSequenceInfo si, List<IFIXGRIDColumnInfo> columnInfos, Set<Integer> treatedIndices) {
        IFIXGRIDColumnInfo ci;
        int i;
        if (si.getPersistId() != null) {
            for (i = 0; i < columnInfos.size(); ++i) {
                if (treatedIndices != null && treatedIndices.contains(i)) continue;
                ci = columnInfos.get(i);
                if (!si.getPersistId().equals(ci.getPersistId())) continue;
                return i;
            }
        }
        if (si.getSortReference() != null) {
            for (i = 0; i < columnInfos.size(); ++i) {
                if (treatedIndices != null && treatedIndices.contains(i)) continue;
                ci = columnInfos.get(i);
                if (!si.getSortReference().equals(ci.getSortreference())) continue;
                return i;
            }
        }
        return -1;
    }

    private static int findColumnIndex(GridColumnWidthInfo wi, List<IFIXGRIDColumnInfo> columnInfos) {
        IFIXGRIDColumnInfo ci;
        int i;
        if (wi.getPersistId() != null) {
            for (i = 0; i < columnInfos.size(); ++i) {
                ci = columnInfos.get(i);
                if (!wi.getPersistId().equals(ci.getPersistId())) continue;
                return i;
            }
        }
        if (wi.getSortReference() != null) {
            for (i = 0; i < columnInfos.size(); ++i) {
                ci = columnInfos.get(i);
                if (!wi.getSortReference().equals(ci.getSortreference())) continue;
                return i;
            }
        }
        return -1;
    }

    protected void saveSerializedPersistentInfo(FacesContext context, FIXGRIDBinding gridBinding, String pageName, String persistId, IFIXGRIDPersistence.PersistentInfo persistentInfo, String xml) {
        StreamStore.getInstance().writeUTF8(DefaultFIXGRIDPersistence.buildPath(persistId, pageName), xml, true);
    }

    protected void updateGridInfo(FacesContext context, FIXGRIDBinding gridBinding, String pageName, String persistId, IFIXGRIDPersistence.PersistentInfo persistentInfo, GridInfo gridInfo) {
        try {
            JAXBContext jbContext = JAXBContext.newInstance((Class[])new Class[]{GridInfo.class});
            Marshaller m = jbContext.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.setProperty("jaxb.encoding", (Object)"UTF-8");
            StringWriter writer = new StringWriter();
            m.marshal((Object)gridInfo, (Writer)writer);
            String xml = ((Object)writer).toString();
            this.saveSerializedPersistentInfo(context, gridBinding, pageName, persistId, persistentInfo, xml);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problems when updating grid info of FIXGRID: ", t);
        }
    }

    private static String buildPath(String persistId, String pageName) {
        String result = "/ccfixgrid/" + UserAccessMgr.getCurrentUser() + pageName + "/" + persistId + ".xml";
        result = ValueManager.convertStringIntoFilePath(result, false);
        return result;
    }
}

