/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util.pagebeancomponents;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.event.ActionEvent;
import org.eclnt.jsfserver.elements.componentnodes.FIELDNode;
import org.eclnt.jsfserver.elements.componentnodes.LABELNode;
import org.eclnt.jsfserver.elements.componentnodes.PANENode;
import org.eclnt.jsfserver.elements.componentnodes.ROWNode;
import org.eclnt.jsfserver.elements.impl.ROWDYNAMICCONTENTBinding;
import org.eclnt.jsfserver.pagebean.component.PageBeanComponent;
import org.eclnt.util.valuemgmt.ValueManager;

public class ComplexValueEditor
extends PageBeanComponent {
    IListener m_listener;
    ROWDYNAMICCONTENTBinding m_dynContent = new ROWDYNAMICCONTENTBinding();
    Map<String, String> m_attributes = new HashMap<String, String>();
    List<String> m_attributeNames = new ArrayList<String>();
    List<LineInfo> m_lines = new ArrayList<LineInfo>();
    String m_width = null;
    String m_height = null;
    String m_labelwidth = "100";
    String m_fieldwidth = "150";
    String m_padding = "10";
    String m_border = "#00000030";
    boolean m_withButtons = false;

    @Override
    public String getRootExpressionUsedInPage() {
        return "#{pb}";
    }

    public void prepare(List<String> attributeNames, String complexValue, IListener listener) {
        this.m_attributeNames = attributeNames;
        this.m_attributes = ValueManager.decodeComplexValue(complexValue);
        this.m_listener = listener;
        this.render();
    }

    @Override
    public void initializePageBean(Map<String, String> initData) {
        super.initializePageBean(initData);
        String s = initData.get("width");
        if (s != null) {
            this.m_width = s;
        }
        if ((s = initData.get("height")) != null) {
            this.m_height = s;
        }
        if ((s = initData.get("labelwidth")) != null) {
            this.m_labelwidth = s;
        }
        if ((s = initData.get("fieldwidth")) != null) {
            this.m_fieldwidth = s;
        }
        if ((s = initData.get("padding")) != null) {
            this.m_padding = s;
        }
        if ((s = initData.get("border")) != null) {
            this.m_border = s;
        }
        if ("true".equals(s = initData.get("withbuttons"))) {
            this.m_withButtons = true;
        }
        this.render();
    }

    public ROWDYNAMICCONTENTBinding getDynContent() {
        return this.m_dynContent;
    }

    public List<LineInfo> getLines() {
        return this.m_lines;
    }

    public String getWidth() {
        return this.m_width;
    }

    public void setWidth(String width) {
        this.m_width = width;
    }

    public String getHeight() {
        return this.m_height;
    }

    public void setHeight(String height) {
        this.m_height = height;
    }

    public String getLabelwidth() {
        return this.m_labelwidth;
    }

    public void setLabelwidth(String labelwidth) {
        this.m_labelwidth = labelwidth;
    }

    public String getFieldwidth() {
        return this.m_fieldwidth;
    }

    public void setFieldwidth(String fieldwidth) {
        this.m_fieldwidth = fieldwidth;
    }

    public String getPadding() {
        return this.m_padding;
    }

    public void setPadding(String padding) {
        this.m_padding = padding;
    }

    public String getBorder() {
        return this.m_border;
    }

    public void setBorder(String border) {
        this.m_border = border;
    }

    public boolean getWithButtons() {
        return this.m_withButtons;
    }

    public void setWithButtons(boolean withButtons) {
        this.m_withButtons = withButtons;
    }

    public String getComplexValue() {
        return ValueManager.encodeComplexValue(this.m_attributes, true);
    }

    public void onOKAction(ActionEvent event) {
        if (this.m_listener != null) {
            this.m_listener.reactOnOK();
        }
    }

    public void onCancelAction(ActionEvent event) {
        if (this.m_listener != null) {
            this.m_listener.reactOnCancel();
        }
    }

    private void render() {
        PANENode p = new PANENode().setWidth("100%").setHeight("100%").setRowdistance(5);
        int counter = -1;
        this.m_lines.clear();
        for (String attributeName : this.m_attributeNames) {
            ++counter;
            LineInfo li = new LineInfo(attributeName);
            this.m_lines.add(li);
            ROWNode r = new ROWNode();
            p.addSubNode(r);
            LABELNode l = new LABELNode().setWidth(this.m_labelwidth).setText(attributeName);
            r.addSubNode(l);
            FIELDNode f = new FIELDNode().setWidth(this.m_fieldwidth).setText(this.pbx("lines[" + counter + "].value"));
            r.addSubNode(f);
        }
        this.m_dynContent.setContentNode(p);
    }

    public class LineInfo {
        String i_name;

        public LineInfo(String name) {
            this.i_name = name;
        }

        public String getValue() {
            return ComplexValueEditor.this.m_attributes.get(this.i_name);
        }

        public void setValue(String value) {
            if (value != null && value.trim().length() == 0) {
                value = null;
            }
            ComplexValueEditor.this.m_attributes.put(this.i_name, value);
        }

        public String getName() {
            return this.i_name;
        }
    }

    public static interface IListener {
        public void reactOnOK();

        public void reactOnCancel();
    }
}

