/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.tool;

import java.io.File;
import java.util.List;
import org.eclnt.util.file.FileManager;
import org.eclnt.util.valuemgmt.ImageShrinker;

public class TransferPNGSizeForDirectory {
    public static void main(String[] args) {
        try {
            String dirName = "C:/bmu_documents/drawings/logos/";
            String toDirName = "C:/bmu_documents/drawings/logos/150x100/";
            String postfix = "_150x100";
            FileManager.ensureDirectoryExists(toDirName);
            List<String> fileNames = FileManager.getFilesOfDirectoryByPattern(dirName, ".png");
            for (String fileName : fileNames) {
                byte[] imageBytes = FileManager.readFile(fileName, true);
                byte[] shrinkedBytes = ImageShrinker.shrinkImage(imageBytes, 150, 100, "png");
                String endName = new File(fileName).getName();
                endName = endName.substring(0, endName.length() - 4) + postfix + ".png";
                String toFullName = toDirName + endName;
                FileManager.writeFile(toFullName, shrinkedBytes, true);
            }
            System.out.println("Finished!");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

