/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.util.log;

import java.util.Calendar;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import org.eclnt.util.valuemgmt.HtmlStringDecoder;
import org.eclnt.util.valuemgmt.ValueManager;

public class CLogFormatter
extends Formatter {
    private static boolean s_outputclassmethod = false;
    public static String s_crlfAppendix = "                                              ";
    Calendar m_cal = Calendar.getInstance();

    public static void init(boolean outputclassmethod) {
        s_outputclassmethod = outputclassmethod;
    }

    @Override
    public String format(LogRecord record) {
        StringBuffer result = new StringBuffer();
        this.m_cal.setTimeInMillis(record.getMillis());
        result.append(this.m_cal.get(1));
        result.append(":");
        result.append(this.fv(this.m_cal.get(2) + 1 + "", 2));
        result.append(":");
        result.append(this.fv(this.m_cal.get(5) + "", 2));
        result.append(" ");
        result.append(this.fv(this.m_cal.get(11) + "", 2));
        result.append(":");
        result.append(this.fv(this.m_cal.get(12) + "", 2));
        result.append(":");
        result.append(this.fv(this.m_cal.get(13) + "", 2));
        result.append(":");
        result.append(this.fv(this.m_cal.get(14) + "", 3));
        result.append(" | ");
        result.append(this.fs(record.getThreadID() + "", 6));
        result.append(" | ");
        result.append(this.fs(record.getLevel() + "", 8));
        result.append(" | ");
        String message = this.replaceCRLF(record.getMessage());
        result.append(message);
        if (s_outputclassmethod) {
            result.append(" .......... ");
            result.append(record.getSourceClassName());
            result.append(">");
            result.append(record.getSourceMethodName());
        }
        result.append("\n");
        if (record.getThrown() != null) {
            result.append(s_crlfAppendix);
            result.append(".......... Stacktrace Info ..........\n");
            String st = ValueManager.getStackstraceString(record.getThrown());
            result.append(s_crlfAppendix);
            result.append(this.replaceCRLF(st));
            result.append("\n");
        }
        return result.toString();
    }

    private String replaceCRLF(String message) {
        message = message.replace("\r\n", "\n");
        while (message.endsWith("\n")) {
            message = message.substring(0, message.length() - 1);
        }
        message = message.replace("\n", "\n" + s_crlfAppendix);
        message = HtmlStringDecoder.decode(message);
        return message;
    }

    private String fv(String value, int length) {
        if (value.length() < length) {
            value = "000" + value;
        }
        return value.substring(value.length() - length);
    }

    private String fs(String value, int length) {
        if (value.length() < length) {
            value = value + "          ";
        }
        return value.substring(0, length);
    }
}

