/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.util.log;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.ISessionAbstraction;
import org.eclnt.jsfserver.util.security.StringHider;
import org.eclnt.jsfserver.util.useraccess.TenantAccessMgr;
import org.eclnt.jsfserver.util.useraccess.UserAccessMgr;
import org.eclnt.util.log.CLog;
import org.eclnt.util.log.CLogConstants;
import org.eclnt.util.log.CLogLogger;
import org.eclnt.util.valuemgmt.ValueManager;
import org.owasp.esapi.ESAPI;

public class PLog
implements CLogConstants {
    public static final String TYPE_REQUEST = "REQUEST";
    public static final String TYPE_DOWNLOAD = "DOWNLOAD";
    public static final String TYPE_UPLOAD = "UPLOAD";
    public static final String TYPE_MEMORY = "MEMORY";
    public static final String TYPE_LEGEND = "LEGEND";
    private static Map<String, RequestPerformanceInfo> s_lastRequestInfos = new Hashtable<String, RequestPerformanceInfo>();
    private static int s_lastRequestInfoReorganizeCounter = 0;
    private static int MAXMILLISECONDS_TO_KEEP_REQUESTINFO = 900000;
    private static final String CLIENT_UNDEFINED = "undefined";
    private static Calendar s_calendar;
    public static Logger L;
    private static long s_stamp;
    private static int s_logCounter;
    private static long s_lastMemoryOutput;
    private static boolean s_legendLogged;

    public static void setCurrentRequestApplicationInfo(String applicationInfo) {
        try {
            if (!HttpSessionAccess.checkIfRunningInUIThread()) {
                return;
            }
            String key = PLog.class.getName() + "/ApplicationInfo";
            StringHider sh = new StringHider(applicationInfo);
            HttpSessionAccess.getCurrentDialogSession().setAttribute(key, sh);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problem setting current application info in performance log", t);
        }
    }

    public static void accumulateNumberInCurrentRequest(String type, long number) {
        try {
            if (!HttpSessionAccess.checkIfRunningInUIThread()) {
                return;
            }
            String key = PLog.class.getName() + "/" + AccumulatedInfo.class.getName();
            ISessionAbstraction dialogSession = HttpSessionAccess.getCurrentDialogSession();
            AccumulatedInfo aci = (AccumulatedInfo)dialogSession.getAttribute(key);
            if (aci == null) {
                aci = new AccumulatedInfo();
                dialogSession.setAttribute(key, aci);
            }
            aci.accumulate(type, number);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problem when accumulating number in current request", t);
        }
    }

    public static void clearCurrentRequestApplicationInfo() {
        try {
            HttpSessionAccess.getCurrentDialogSession().removeAttribute(PLog.class.getName() + "/ApplicationInfo");
            HttpSessionAccess.getCurrentDialogSession().removeAttribute(PLog.class.getName() + "/" + AccumulatedInfo.class.getName());
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problem setting current application info in performance log", t);
        }
    }

    public static String getCurrentRequestApplicationInfo() {
        try {
            String key = PLog.class.getName() + "/ApplicationInfo";
            StringHider sh = (StringHider)HttpSessionAccess.getCurrentDialogSession().getAttribute(key);
            if (sh == null) {
                return null;
            }
            return sh.getValue();
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problem getting current application info in performance log", t);
            return null;
        }
    }

    public static String getCurrentRequestAccumulatedNumbersInfo() {
        try {
            String key = PLog.class.getName() + "/" + AccumulatedInfo.class.getName();
            AccumulatedInfo aci = (AccumulatedInfo)HttpSessionAccess.getCurrentDialogSession().getAttribute(key);
            if (aci == null) {
                return null;
            }
            String result = ValueManager.encodeComplexValue(aci.i_info);
            return result;
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problem getting current application info in performance log", t);
            return null;
        }
    }

    public static void updateLogLevel(Level newLevel) {
        try {
            L.setLevel(newLevel);
            for (Handler handler : L.getHandlers()) {
                handler.setLevel(newLevel);
            }
        }
        catch (Throwable t) {
            L.log(LL_ERR, "problem when updating log level", t);
        }
    }

    public static void logClientProcessingInfo(String sessionId, String clientPerformanceData) {
        try {
            PLog.logLegend();
            if (clientPerformanceData == null) {
                return;
            }
            Map<String, String> m = ValueManager.decodeComplexValue(clientPerformanceData);
            int clientCommunicationDuration = ValueManager.decodeInt(m.get("roundtrip"), -1);
            int clientUpdateDuration = ValueManager.decodeInt(m.get("update"), -1);
            long clientRespStamp = ValueManager.decodeLong(m.get("respStamp"), -1L);
            String requestId = m.get("requestId");
            if (clientCommunicationDuration >= 0) {
                PLog.logClientProcessingInfo(sessionId, clientCommunicationDuration, clientUpdateDuration, clientRespStamp, requestId);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void logRequestInfo(String sessionId, long total, long invoke, String expression, long consumedNanosGet, long stampStartOfClientProcessing, long stampStartOfServerProcessing, String requestId, long stampStartOfWritingResponse, String applicationInfo, String accumulatedNumbers) {
        PLog.logLegend();
        RequestPerformanceInfo rpi = new RequestPerformanceInfo(sessionId, total, invoke, expression, consumedNanosGet, stampStartOfClientProcessing, stampStartOfServerProcessing, requestId, stampStartOfWritingResponse, applicationInfo);
        if (requestId != null) {
            s_lastRequestInfos.put(requestId, rpi);
        }
        if (++s_lastRequestInfoReorganizeCounter > 1000) {
            PLog.reorganizeLastRequestInfos();
            s_lastRequestInfoReorganizeCounter = 0;
        }
        String stampClient = "-";
        SimpleDateFormat stampFormat = PLog.createStampFormat();
        if (stampStartOfClientProcessing > 0L) {
            stampClient = stampFormat.format(new Date(stampStartOfClientProcessing));
        }
        String stampServer = stampFormat.format(new Date(stampStartOfServerProcessing));
        if (expression == null) {
            expression = CLIENT_UNDEFINED;
        }
        if (requestId == null) {
            requestId = CLIENT_UNDEFINED;
        }
        long stampEndResponse = System.currentTimeMillis();
        String stampServerEndResponse = stampFormat.format(new Date(stampEndResponse));
        total = stampEndResponse - stampStartOfServerProcessing;
        if (applicationInfo == null) {
            applicationInfo = "(not set)";
        }
        String s = PLog.extendStringToLength10(TYPE_REQUEST) + ": RequestId: " + requestId + ", ClientId: " + PLog.esapi(PLog.findClientInfo()) + ", Session: " + sessionId + ", Total: " + total + "ms, Invoke: " + invoke + "ms, Expression: " + expression + ", ClientStart: " + stampClient + ", ServerStart: " + stampServer + ", ServerEndResponse:" + stampServerEndResponse + ", ApplicationInfo: " + PLog.esapi(applicationInfo);
        if (accumulatedNumbers != null) {
            s = s + ";" + accumulatedNumbers;
        }
        L.log(LL_INF, s);
        long now = System.currentTimeMillis();
        if (now - 10000L > s_lastMemoryOutput) {
            s_lastMemoryOutput = now;
            PLog.logMemoryInfo();
        }
    }

    public static void logFileDownloadInfo(String sessionId, long total, long numberOfBytes) {
        PLog.logLegend();
        String s = PLog.extendStringToLength10(TYPE_DOWNLOAD) + ": ClientId: " + PLog.esapi(PLog.findClientInfo()) + ", Session: " + sessionId + ", JavaProcessing: " + total + "ms, NumberOfContentBytes: " + numberOfBytes;
        L.log(LL_INF, s);
    }

    public static void logFileUploadInfo(String sessionId, long total, long numberOfBytes) {
        PLog.logLegend();
        String s = PLog.extendStringToLength10(TYPE_UPLOAD) + ": ClientId: " + PLog.esapi(PLog.findClientInfo()) + ", Session: " + sessionId + ", JavaProcessing: " + total + "ms, NumberOfContentBytes: " + numberOfBytes;
        L.log(LL_INF, s);
    }

    public static void logMemoryInfo() {
        PLog.logLegend();
        Runtime r = Runtime.getRuntime();
        String s = PLog.extendStringToLength10(TYPE_MEMORY) + ": Occupied: " + (r.totalMemory() - r.freeMemory()) / 1000000L + "M, Total: " + r.totalMemory() / 1000000L + "M, Max: " + r.maxMemory() / 1000000L + "M";
        L.log(LL_INF, s);
    }

    public static void logApplicationInfo(String keyword, String info) {
        PLog.logLegend();
        String s = PLog.esapi(keyword) + ":" + PLog.esapi(info);
        L.log(LL_INF, s);
    }

    public static void logLegendLine(String text) {
        String s = PLog.extendStringToLength10(TYPE_LEGEND) + ": " + text;
        L.log(LL_INF, s);
    }

    private static void logLegend() {
        if (s_legendLogged) {
            return;
        }
        s_legendLogged = true;
        PLog.logLegendLine("\n\n\n***********************************************************************************************************************\nInfo of REQUEST line -----------------------------------\nFor each request to the server processing the performance data of the server side request processing is logged.\nRequestId - Unique id for each request\nClientId - Unique id of client, each browser tab has its own id\nSessionId - http session id\nTotal - Total processing time on server side, starting with entering the CC-layers and ending when leaving the CC-layers\nInvoke - If there is an action event processed: duration of this action event\nExpression - If there is an action event processed: expression of the actionListener that is called\nClientStart - Timestamp on client side when the request processing was triggered\nServerStart - Timestamp on server side when the request enters the CC-layer\nServerEndResponse - Timestamp on server side when the response is written; same as ServerStart + Total\nApplicationInfo - Information that can be set by the application\nInfo of CLIENT line ------------------------------------\nFor each request to the server data is written that is generated within the client processing\nRequestId - Unique id for each request\nClientId - Unique id of client, each browser tab has its own id\nSessionId - http session id\nResponseReceived - Timestamp when the response from server side is received + started to be processed\nRoundtripDuration - Duration between starting to send the respsone until fully processing response\nClientUpdate - Duration that client JavaScript prorcessing takes for processing response data\nRequestInfoAvailable - Info if data from the server-side processing is availabl in the CLIENT line\nIf data from the server-side processing is available, then the server side performance data is also part of this line:\nTotal\nInvoke\nExpression\nClientStart\nServerStart\nServerEndResponse\n***********************************************************************************************************************\n\n\n");
    }

    private static String esapi(String s) {
        if (s == null) {
            return null;
        }
        return ESAPI.encoder().encodeForHTML(s);
    }

    private static String findClientInfo() {
        try {
            String result = HttpSessionAccess.getCurrentClientId(false);
            if (result != null && result.length() > 0) {
                return result;
            }
            return CLIENT_UNDEFINED;
        }
        catch (Throwable t) {
            return CLIENT_UNDEFINED;
        }
    }

    private static void logClientProcessingInfo(String sessionId, long clientCommunicationDuration, long clientUpdateDuration, long clientRespStamp, String requestId) {
        RequestPerformanceInfo rpi = s_lastRequestInfos.get(requestId);
        if (rpi != null) {
            s_lastRequestInfos.remove(requestId);
        }
        String respStamp = "-";
        SimpleDateFormat stampFormat = PLog.createStampFormat();
        if (clientRespStamp > 0L) {
            respStamp = stampFormat.format(new Date(clientRespStamp));
        }
        String user = CLIENT_UNDEFINED;
        String tenant = CLIENT_UNDEFINED;
        try {
            user = UserAccessMgr.getCurrentUser();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            tenant = TenantAccessMgr.getCurrentTenant();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String message = new String();
        message = PLog.extendStringToLength10("CLIENT") + ": RequestId: " + requestId + ", ClientId: " + PLog.findClientInfo() + ", Session: " + sessionId + ", ResponseReceived: " + respStamp + ", RoundtripDuration: " + clientCommunicationDuration + "ms, ClientUpdate: " + clientUpdateDuration + " ms,User: " + user + ", Tenant: " + tenant;
        if (rpi != null) {
            String stampClient = "-";
            if (rpi.stampStartOfClientProcessing > 0L) {
                stampClient = stampFormat.format(new Date(rpi.stampStartOfClientProcessing));
            }
            String stampServer = stampFormat.format(new Date(rpi.stampStartOfServerProcessing));
            String stampServerEndResponse = stampFormat.format(new Date(rpi.logStamp));
            message = message + ", RequestInfoAvailable: true, Total: " + rpi.total + "ms, Invoke: " + rpi.invoke + "ms, Expression: " + rpi.expression + ", ClientStart: " + stampClient + ", ServerStart: " + stampServer + ", ServerEndResponse:" + stampServerEndResponse;
        } else {
            message = message + ", RequestInfoAvailable: false";
        }
        L.log(LL_INF, message);
    }

    private static String extendStringToLength10(String s) {
        s = (s + "               ").substring(0, 10);
        return s;
    }

    private static void reorganizeLastRequestInfos() {
        HashSet<String> removeRequestIds = new HashSet<String>();
        long now = System.currentTimeMillis();
        for (RequestPerformanceInfo rpi : s_lastRequestInfos.values()) {
            long diff = now - rpi.logStamp;
            if (diff <= (long)MAXMILLISECONDS_TO_KEEP_REQUESTINFO) continue;
            removeRequestIds.add(rpi.requestId);
        }
        for (String requestId : removeRequestIds) {
            s_lastRequestInfos.remove(requestId);
        }
    }

    private static SimpleDateFormat createStampFormat() {
        return new SimpleDateFormat("HH:mm:ss:SSS");
    }

    static {
        s_stamp = -1L;
        s_logCounter = 0;
        s_lastMemoryOutput = 0L;
        s_legendLogged = false;
        try {
            ++s_logCounter;
            try {
                L = new CLogLogger("org.eclnt.serverperformancelog.I" + s_logCounter, null);
                LogManager.getLogManager().addLogger(L);
            }
            catch (Throwable t) {
                System.err.println("CC ERROR: Problems when starting logger");
                t.printStackTrace();
            }
            try {
                LogManager.getLogManager().addLogger(L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                L.setUseParentHandlers(false);
            }
            catch (Throwable throwable) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class AccumulatedInfo {
        Map<String, Long> i_info;

        public void accumulate(String type, long number) {
            if (this.i_info == null) {
                this.i_info = new HashMap<String, Long>();
                this.i_info.put(type, number);
            } else {
                Long lObj = this.i_info.get(type);
                if (lObj == null) {
                    this.i_info.put(type, number);
                } else {
                    this.i_info.put(type, lObj + number);
                }
            }
        }
    }

    public static class RequestPerformanceInfo {
        String sessionId;
        long total;
        long invoke;
        String expression;
        long consumedNanosGet;
        long stampStartOfClientProcessing;
        long stampStartOfServerProcessing;
        String requestId;
        long stampStartOfWritingResponse;
        long logStamp = System.currentTimeMillis();
        String applicationInfo;

        public RequestPerformanceInfo(String sessionId, long total, long invoke, String expression, long consumedNanosGet, long stampStartOfClientProcessing, long stampStartOfServerProcessing, String requestId, long stampStartOfWritingResponse, String applicationInfo) {
            this.sessionId = sessionId;
            this.total = total;
            this.invoke = invoke;
            this.expression = expression;
            this.consumedNanosGet = consumedNanosGet;
            this.stampStartOfClientProcessing = stampStartOfClientProcessing;
            this.stampStartOfServerProcessing = stampStartOfServerProcessing;
            this.requestId = requestId;
            this.stampStartOfWritingResponse = stampStartOfWritingResponse;
            this.applicationInfo = applicationInfo;
        }
    }
}

