/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.util.token;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import org.eclnt.util.token.ITokenMgr;
import org.eclnt.util.token.Token;

public class TokenMgrImplInProcessMap
implements ITokenMgr {
    public static final long MAX_TOKEN_VALIDITYDURATION = 60000L;
    private static final long CLENAUP_INTERVAL_DURATION = 60000L;
    Map<String, Token> m_tokenMap = new Hashtable<String, Token>();
    long m_lastCleanUpStamp = System.currentTimeMillis();

    @Override
    public Token createToken(String content) {
        Token result = new Token(content);
        this.saveToken(result);
        return result;
    }

    @Override
    public Token pullToken(String uuid) {
        Token result = this.getToken(uuid);
        if (result != null) {
            this.deleteToken(uuid);
        }
        this.cleanUpUnusedTokens();
        if (result != null && result.getCreationStamp() + 60000L > System.currentTimeMillis()) {
            return result;
        }
        return null;
    }

    @Override
    public Token getToken(String uuid) {
        Token result = this.readToken(uuid);
        this.cleanUpUnusedTokens();
        return result;
    }

    protected Token readToken(String uuid) {
        return this.m_tokenMap.get(uuid);
    }

    protected void saveToken(Token result) {
        this.m_tokenMap.put(result.getUuid(), result);
    }

    protected void deleteToken(String uuid) {
        this.m_tokenMap.remove(uuid);
    }

    protected void cleanUpUnusedTokens() {
        long now = System.currentTimeMillis();
        long compareStamp = now - 60000L;
        if (this.m_lastCleanUpStamp > compareStamp) {
            return;
        }
        this.m_lastCleanUpStamp = now;
        this.cleanUpUnusedTokensExecute();
    }

    protected void cleanUpUnusedTokensExecute() {
        HashSet<Token> tokens = new HashSet<Token>(this.m_tokenMap.values());
        for (Token token : tokens) {
            if (!this.checkIfTokenIsTimedOut(token)) continue;
            this.m_tokenMap.remove(token.getUuid());
        }
    }

    protected boolean checkIfTokenIsTimedOut(Token token) {
        long now = System.currentTimeMillis();
        return token.getCreationStamp() + 60000L < now;
    }
}

