/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.workplace;

import java.util.List;
import org.eclnt.jsfserver.elements.impl.FIXGRIDTreeItem;
import org.eclnt.jsfserver.managedbean.IDispatcher;
import org.eclnt.workplace.WorkpageStartInfo;
import org.eclnt.workplace.WorkplaceFunctionTree;
import org.eclnt.workplace.WorkplaceFunctionTreeInfoManager;
import org.eclnt.workplace.WorkplaceFunctionTreeInfoNode;

public class WorkplaceFunctionTreeFromInfoNode
extends WorkplaceFunctionTree {
    WorkplaceFunctionTreeInfoNode m_rootNode;

    public WorkplaceFunctionTreeFromInfoNode(IDispatcher owner, WorkplaceFunctionTreeInfoNode rootNode) {
        super(owner);
        this.m_rootNode = rootNode;
        this.loadFunctionTreeLater(this.m_rootNode, this.getFtree().getRootNode());
    }

    public WorkplaceFunctionTreeInfoNode getRootNode() {
        return this.m_rootNode;
    }

    @Override
    protected void loadFunctionTree() {
    }

    private void loadFunctionTreeLater(WorkplaceFunctionTreeInfoNode parentNode, FIXGRIDTreeItem treeItem) {
        if (parentNode.getEmbeddedTreeName() != null) {
            parentNode = WorkplaceFunctionTreeInfoManager.loadFunctionTreeInfo(parentNode.getEmbeddedTreeName());
        }
        List<WorkplaceFunctionTreeInfoNode> subNodes = parentNode.getSubNodes();
        for (WorkplaceFunctionTreeInfoNode subNode : subNodes) {
            boolean accept = this.checkIfToRenderNode(subNode);
            if (!accept) continue;
            WorkpageStartInfo wpsi = subNode.getWorkpageStartInfo();
            WorkplaceFunctionTree.FunctionNode fn = null;
            if (wpsi != null) {
                fn = (WorkplaceFunctionTree)this.new WorkplaceFunctionTree.FunctionNode(treeItem, wpsi);
                fn.setStatus(2);
                fn.setText(subNode.getText());
                if (subNode.getNodeClientname() != null) {
                    fn.setClientName(subNode.getNodeClientname());
                }
                if (subNode.getNodeImage() != null) {
                    fn.setImage(subNode.getNodeImage());
                }
                fn.setNodeTooltip(subNode.getNodeComment());
            }
            if (wpsi != null && subNode.getSubNodes().size() <= 0) continue;
            if (fn == null) {
                fn = new WorkplaceFunctionTree.FunctionNode(treeItem);
                fn.setText(subNode.getText());
                if (subNode.getNodeClientname() != null) {
                    fn.setClientName(subNode.getNodeClientname());
                }
                if (subNode.getNodeImage() != null) {
                    fn.setImage(subNode.getNodeImage());
                }
                fn.setNodeTooltip(subNode.getNodeComment());
            }
            if (subNode.getFolderOpened()) {
                fn.setStatus(0);
            } else {
                fn.setStatus(1);
            }
            if (subNode.getEmbeddedTreeName() == null) {
                this.loadFunctionTreeLater(subNode, fn);
                continue;
            }
            WorkplaceFunctionTreeInfoNode embeddedNode = WorkplaceFunctionTreeInfoManager.loadFunctionTreeInfo(subNode.getEmbeddedTreeName());
            this.loadFunctionTreeLater(embeddedNode, fn);
        }
    }

    protected boolean checkIfToRenderNode(WorkplaceFunctionTreeInfoNode node) {
        return true;
    }
}

