/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.defaultscreens;

import java.io.Serializable;
import javax.faces.event.ActionEvent;
import org.eclnt.jsfserver.defaultscreens.DefaultScreens;
import org.eclnt.jsfserver.defaultscreens.ISetId;
import org.eclnt.jsfserver.defaultscreens.ISetIdAttributes;
import org.eclnt.jsfserver.defaultscreens.ModalPopup;
import org.eclnt.jsfserver.defaultscreens.ModelessPopup;
import org.eclnt.jsfserver.elements.BaseComponent;
import org.eclnt.jsfserver.elements.ICCComponentProperties;
import org.eclnt.jsfserver.elements.impl.FIXGRIDComponent;
import org.eclnt.jsfserver.elements.impl.FIXGRIDComponentTag;
import org.eclnt.jsfserver.elements.impl.FIXGRIDItem;
import org.eclnt.jsfserver.elements.impl.FIXGRIDListBinding;
import org.eclnt.jsfserver.elements.impl.GRIDCOLComponentTag;
import org.eclnt.jsfserver.elements.impl.LABELComponentTag;
import org.eclnt.jsfserver.elements.impl.ROWComponent;
import org.eclnt.jsfserver.util.StyleManager;
import org.eclnt.jsfserver.util.SystemXml;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;

public class IdAttributesSelection
implements Serializable,
ModalPopup.IModalPopupListener {
    public static String PAGENAME_DEFAULT = "/eclntjsfserver/popups/idattributesselection.jsp";
    IdAttributesLineGrid m_lines = new IdAttributesLineGrid();
    public String m_explanation;
    ISetId m_setIdCallBack;
    ISetIdAttributes m_setIdAttributesCallBack;
    ModelessPopup m_popup;
    boolean m_withHeader = true;
    boolean m_suppressHeadline = false;
    String[] m_titles;
    String[] m_widths;
    boolean m_allDataToClient = false;
    boolean m_allDataToClientChanged = false;
    String m_requestFocus = "creation";
    ROWComponent m_row;
    int m_rowHeight = 16;

    IdAttributesSelection() {
        String s = StyleManager.getTagAttributeValue("IDVALUESELECTION", "t:fixgrid", ICCComponentProperties.ATT_rowheight);
        this.m_rowHeight = ValueManager.decodeInt(s, this.m_rowHeight);
    }

    public static void initialize() {
        if (SystemXml.getDefaultPopups().getIdattributeselection() != null) {
            PAGENAME_DEFAULT = SystemXml.getDefaultPopups().getIdattributeselection();
        }
    }

    public static IdAttributesSelection createInstance(String[] titles, String[] widths) {
        return IdAttributesSelection.createInstance(titles, widths, false);
    }

    public String getRequestFocus() {
        return this.m_requestFocus;
    }

    public ModelessPopup getPopup() {
        return this.m_popup;
    }

    public static IdAttributesSelection createInstance(String[] titles, String[] widths, boolean allDataToClient) {
        if (titles.length != widths.length) {
            throw new Error("Titles and widths array length are not the same: " + titles.length + "/" + widths.length);
        }
        IdAttributesSelection result = IdAttributesSelection.closeAndCreateExistingInstance();
        result.m_allDataToClientChanged = result.m_allDataToClient != allDataToClient;
        result.m_allDataToClient = allDataToClient;
        result.m_titles = titles;
        result.m_widths = widths;
        result.m_lines.setColumnsequence(null);
        result.m_lines.setModcolumnwidths(null);
        result.updateRow();
        result.m_popup = ModelessPopup.createInstance();
        result.m_popup.setClientname(IdAttributesSelection.class.getSimpleName());
        result.m_popup.setCloseonclickoutside(true);
        result.m_popup.open(PAGENAME_DEFAULT, "Value Selection", 300, 350, result);
        result.m_popup.setUndecorated(true);
        result.m_popup.setStartfromrootwindow(false);
        result.m_popup.setContentReplace("$i$:" + result.m_popup.getIndex());
        result.m_popup.setUpdateIsolation(true);
        return result;
    }

    private static IdAttributesSelection closeAndCreateExistingInstance() {
        DefaultScreens.SessionAccess sessionAccess = DefaultScreens.getSessionAccess();
        IdAttributesSelection existingSelection = sessionAccess.getPopupIdAttributesSelection();
        if (existingSelection != null) {
            try {
                if (existingSelection.m_popup != null) {
                    existingSelection.reactOnPopupClosedByUser();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        IdAttributesSelection result = new IdAttributesSelection();
        sessionAccess.setPopupIdAttributesSelection(result);
        result.init();
        return result;
    }

    public void setRowHeight(int rowHeight) {
        this.m_rowHeight = rowHeight;
    }

    public int getRowHeight() {
        return this.m_rowHeight;
    }

    public void setRow(ROWComponent row) {
        if (this.m_row == row) {
            return;
        }
        this.m_row = row;
        this.updateRow();
    }

    public void clear() {
        this.m_lines.getItems().clear();
        this.updateRowSbvisibleAmount();
    }

    public IdAttributesLine addLine(String id, String[] attributes) {
        if (attributes.length != this.m_titles.length) {
            throw new Error("Attributes array length is not the same as titles array length: " + attributes.length + "/" + this.m_titles.length);
        }
        IdAttributesSelection idts = DefaultScreens.getSessionAccess().getPopupIdAttributesSelection();
        IdAttributesLine itl = new IdAttributesLine(idts, id, attributes);
        idts.m_lines.getItems().add(itl);
        this.updateRowSbvisibleAmount();
        return itl;
    }

    public void setCallBack(ISetId callBack) {
        this.m_setIdCallBack = callBack;
    }

    public void setCallBack(ISetIdAttributes callBack) {
        this.m_setIdAttributesCallBack = callBack;
    }

    public void onPopupClosedByUser(ActionEvent ae) {
        this.reactOnPopupClosedByUser();
    }

    public FIXGRIDListBinding<IdAttributesLine> getLines() {
        return this.m_lines;
    }

    public void processSelectLine(IdAttributesLine line) {
        if (this.m_setIdCallBack != null) {
            this.m_setIdCallBack.setId(line.getId());
        }
        if (this.m_setIdAttributesCallBack != null) {
            this.m_setIdAttributesCallBack.setId(line.getId(), line.getAttributes());
        }
        this.m_popup.close();
    }

    @Override
    public void reactOnPopupClosedByUser() {
        this.m_popup.close();
        this.m_setIdCallBack = null;
        this.m_setIdAttributesCallBack = null;
    }

    public boolean getWithHeader() {
        return this.m_withHeader;
    }

    public void setWithHeader(boolean value) {
        this.m_withHeader = value;
    }

    public void onOK(ActionEvent event) {
        IdAttributesLine selLine = (IdAttributesLine)this.m_lines.getSelectedItem();
        if (selLine != null) {
            this.processSelectLine(selLine);
        }
    }

    public void onCancel(ActionEvent event) {
        this.m_popup.close();
        this.m_setIdCallBack = null;
        this.m_setIdAttributesCallBack = null;
    }

    public void setPopupWidth(int width) {
        this.m_popup.setWidth(width);
    }

    public void setPopupHeight(int height) {
        this.m_popup.setHeight(height);
    }

    public void setSuppressHeadline(boolean value) {
        this.m_suppressHeadline = value;
    }

    public boolean getSuppressHeadline() {
        return this.m_suppressHeadline;
    }

    public void preselect(String id) {
        int index = 0;
        for (IdAttributesLine itl : this.m_lines.getItems()) {
            boolean isSelected = false;
            if (id == null && itl.getId() == null) {
                isSelected = true;
            }
            if (id != null && id.equals(itl.getId())) {
                isSelected = true;
            }
            if (isSelected) {
                this.m_lines.deselectCurrentSelection();
                if (!this.m_allDataToClient) {
                    if (this.m_allDataToClientChanged) {
                        CLog.L.log(CLog.LL_INF, "++++++++++ Reset sbvisiblamount to 15");
                        this.m_lines.setSbvisibleamount(15);
                        this.m_lines.setClientvisibleamount(15);
                    }
                    this.m_lines.selectAndFocusItem(itl);
                } else {
                    this.m_lines.setSbvisibleamount(this.m_lines.getItems().size());
                    this.m_lines.selectAndFocusItem(itl);
                }
                this.m_requestFocus = null;
                break;
            }
            ++index;
        }
    }

    private void init() {
        this.clear();
        this.m_setIdCallBack = null;
        this.m_setIdAttributesCallBack = null;
        this.m_explanation = null;
    }

    private void updateRow() {
        if (this.m_row == null) {
            return;
        }
        this.m_row.getChildren().clear();
        FIXGRIDComponentTag fct = new FIXGRIDComponentTag();
        fct.setBorder("top:0");
        fct.setAvoidroundtrips("true");
        fct.setStylevariant("IDVALUESELECTION");
        if (this.m_allDataToClient) {
            fct.setHeight(null);
        } else {
            fct.setHeight("100%");
        }
        fct.setObjectbinding("#{eclntdefscr.popupIdAttributesSelection.lines}");
        fct.setRequestfocus(this.m_requestFocus);
        fct.setRowheight("" + this.m_rowHeight);
        if (this.m_allDataToClient) {
            fct.setSbvisibleamount("" + this.m_lines.getItems().size());
        } else {
            fct.setSbvisibleamount("20");
        }
        fct.setSingleclickexecute("true");
        if (this.m_allDataToClient) {
            fct.setWidth(null);
        } else {
            fct.setWidth("100%");
        }
        fct.setSuppressheadline("#{eclntdefscr.popupIdAttributesSelection.suppressHeadline}");
        if (this.m_allDataToClient) {
            fct.setNoscrollmode("true");
        } else {
            fct.setNoscrollmode("false");
        }
        BaseComponent fc = fct.createBaseComponent();
        this.m_row.getChildren().add(fc);
        for (int i = 0; i < this.m_titles.length; ++i) {
            GRIDCOLComponentTag gct = new GRIDCOLComponentTag();
            gct.setText(this.m_titles[i]);
            gct.setWidth(this.m_widths[i]);
            BaseComponent gc = gct.createBaseComponent();
            fc.getChildren().add(gc);
            LABELComponentTag lct = new LABELComponentTag();
            lct.setBgpaint(".{bgpaint}");
            lct.setText(".{attributes[" + i + "]}");
            lct.setStylevariant("IDVALUESELECTION");
            BaseComponent lc = lct.createBaseComponent();
            gc.getChildren().add(lc);
        }
    }

    private void updateRowSbvisibleAmount() {
        if (!this.m_allDataToClient) {
            return;
        }
        if (this.m_row == null) {
            return;
        }
        FIXGRIDComponent fc = (FIXGRIDComponent)this.m_row.getChild(0);
        fc.setAttributeValueFromOutside("sbvisibleamount", "" + this.m_lines.getItems().size());
    }

    public class IdAttributesLineGrid
    extends FIXGRIDListBinding<IdAttributesLine> {
        @Override
        public void initialize() {
            super.initialize();
            try {
                if (this.getSelectedItem() == null && this.getItems().size() > 0) {
                    this.selectAndFocusItem((FIXGRIDItem)this.getItems().get(0));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static class IdAttributesLine
    extends FIXGRIDItem
    implements Serializable {
        IdAttributesSelection m_idAttributesSelection;
        String m_id;
        String[] m_attributes;
        String m_bgpaint;

        public IdAttributesLine(IdAttributesSelection idas, String id, String[] attributes) {
            this.m_idAttributesSelection = idas;
            this.m_id = id;
            this.m_attributes = attributes;
        }

        public String getId() {
            return this.m_id;
        }

        public String[] getAttributes() {
            return this.m_attributes;
        }

        @Override
        public void onRowExecute() {
            this.m_idAttributesSelection.processSelectLine(this);
        }

        public String getBgpaint() {
            return this.m_bgpaint;
        }

        public void setBgpaint(String bgpaint) {
            this.m_bgpaint = bgpaint;
        }
    }
}

