/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.elements;

import java.io.IOException;
import java.io.Writer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.eclnt.jsfserver.elements.BaseComponent;
import org.eclnt.jsfserver.elements.ComponentDump;
import org.eclnt.jsfserver.session.RequestFocusManager;
import org.eclnt.jsfserver.session.SessionInfo;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;
import org.eclnt.util.valuemgmt.XMLWriter;

public class BaseHTMLComponent
extends BaseComponent {
    boolean m_creationFocusApplied = false;

    @Override
    public Object saveState(FacesContext context) {
        return new Object[]{super.saveState(context), this.m_creationFocusApplied};
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.m_creationFocusApplied = (Boolean)values[1];
    }

    public String writeTdAroundControl(ResponseWriter writer, ComponentDump cd, boolean withStyle) throws IOException {
        String width = this.getAttributeValueAsString("width");
        String height = this.getAttributeValueAsString("height");
        String valign = this.getAttributeValueAsString("valign");
        if (valign == null) {
            valign = "center";
        }
        XMLWriter.writer_startElement((Writer)writer, cd, "td");
        String tdStyleClass = this.getCurrentTdStyleClass();
        if (tdStyleClass != null) {
            XMLWriter.writer_writeAttribute((Writer)writer, cd, "class", tdStyleClass);
        }
        StringBuffer tdstyle = new StringBuffer();
        if (withStyle) {
            BaseHTMLComponent.appendToStyle(tdstyle, this.getAttributeValueAsString("style"));
        }
        if (width != null && width.endsWith("%")) {
            BaseHTMLComponent.appendToStyle(tdstyle, "width:" + width);
            width = "100%";
        }
        if (height != null && height.endsWith("%")) {
            BaseHTMLComponent.appendToStyle(tdstyle, "height:" + height);
            height = "100%";
        }
        if (tdstyle.length() > 0) {
            XMLWriter.writer_writeAttribute((Writer)writer, cd, "style", tdstyle.toString());
        }
        XMLWriter.writer_writeAttribute((Writer)writer, cd, "valign", valign);
        XMLWriter.writer_writeAttribute((Writer)writer, cd, "align", this.getAttributeValueAsString("left"));
        XMLWriter.writer_closeStartElement((Writer)writer, cd);
        return width;
    }

    public boolean getCurrentEnabled() {
        String enabled = this.getAttributeValueAsString("enabled");
        String ccenabled = this.getAttributeValueAsString("ccenabled");
        if (ccenabled == null) {
            return ValueManager.decodeBoolean(enabled, true);
        }
        if ("false".equals(ccenabled)) {
            return false;
        }
        return ValueManager.decodeBoolean(enabled, true);
    }

    public String getCurrentStyleClass(String defaultStyle) {
        String ccselected;
        String style = this.getAttributeValueAsString("styleClass");
        if (style == null) {
            style = defaultStyle;
        }
        if ("true".equals(ccselected = this.getAttributeValueAsString("ccselected"))) {
            return style + "_selected";
        }
        if (!this.getCurrentEnabled()) {
            return style + "_disabled";
        }
        return style;
    }

    public String getCurrentTdStyleClass() {
        String ccselected = this.getAttributeValueAsString("ccselected");
        if ("true".equals(ccselected)) {
            return "classtd_selected";
        }
        return null;
    }

    protected UIForm getParentForm() {
        UIComponent parent = this.getParent();
        while (!(parent instanceof UIForm)) {
            parent = parent.getParent();
        }
        return (UIForm)parent;
    }

    protected void manageFocus(FacesContext context, String id) {
        this.manageFocus(context, id, "document.getElementById('", "').focus();");
    }

    protected void manageFocus(FacesContext context, String id, String preStatement, String postStatement) {
        try {
            ResponseWriter writer = context.getResponseWriter();
            String requestfocus = this.getAttributeValueAsString("requestfocus");
            if (requestfocus != null) {
                if (id == null) {
                    id = this.getClientId(context);
                }
                long rfCounter = 0L;
                rfCounter = "creation".equals(requestfocus) ? RequestFocusManager.getCreationRequestFocusCounter() : ValueManager.decodeLong(requestfocus, 0L);
                if (rfCounter == 0L) {
                    return;
                }
                if (!this.m_creationFocusApplied && rfCounter == RequestFocusManager.getCreationRequestFocusCounter()) {
                    this.m_creationFocusApplied = true;
                    XMLWriter.writer_writeFormattedText((Writer)writer, null, "\n<script>" + preStatement + id + postStatement + "</script>\n");
                    return;
                }
                SessionInfo sessionInfo = SessionInfo.getSessionInstance();
                if (sessionInfo.getHtHighestFocusCounter() < rfCounter) {
                    sessionInfo.setHtHighestFocusCounter(rfCounter);
                    XMLWriter.writer_writeFormattedText((Writer)writer, null, "\n<script>" + preStatement + id + postStatement + "</script>\n");
                }
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Problem when setting focus", t);
        }
    }

    protected boolean checkIfFocusIsRequested() {
        try {
            String requestfocus = this.getAttributeValueAsString("requestfocus");
            if (requestfocus != null) {
                long rfCounter = 0L;
                rfCounter = "creation".equals(requestfocus) ? RequestFocusManager.getCreationRequestFocusCounter() : ValueManager.decodeLong(requestfocus, 0L);
                if (rfCounter == 0L) {
                    return false;
                }
                if (!this.m_creationFocusApplied && rfCounter == RequestFocusManager.getCreationRequestFocusCounter()) {
                    return true;
                }
                SessionInfo sessionInfo = SessionInfo.getSessionInstance();
                if (sessionInfo.getHtHighestFocusCounter() < rfCounter) {
                    sessionInfo.setHtHighestFocusCounter(rfCounter);
                    return true;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    protected void addHiddenField(FacesContext context, ResponseWriter writer, String postfix) {
        try {
            String clientId = this.getClientId(context);
            XMLWriter.writer_startElement((Writer)writer, null, "input");
            XMLWriter.writer_writeAttribute((Writer)writer, null, "type", "hidden");
            XMLWriter.writer_writeAttribute((Writer)writer, null, "name", clientId + postfix);
            XMLWriter.writer_closeStartAndEndElement((Writer)writer, null);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Problem when creating hidden field", t);
        }
    }

    protected static void appendToStyle(StringBuffer style, String styleFragment) {
        if (style == null) {
            return;
        }
        if (styleFragment == null) {
            return;
        }
        if (styleFragment.length() == 0) {
            return;
        }
        if (style.length() > 0) {
            style.append(";");
        }
        style.append(styleFragment);
    }
}

