/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.elements.adapter;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.faces.event.ActionEvent;
import org.eclnt.jsfserver.elements.IBaseComponent;
import org.eclnt.jsfserver.elements.adapter.ComponentAdapterUtil;
import org.eclnt.jsfserver.elements.adapter.IActionListener;
import org.eclnt.jsfserver.elements.adapter.IComponentAdapterBinding2;
import org.eclnt.jsfserver.elements.adapter.IFIXGRIDComponentAdapterBinding;
import org.eclnt.jsfserver.elements.impl.FIXGRIDBinding;

public abstract class ComponentAdapterBindingBase
implements Serializable,
IComponentAdapterBinding2,
IFIXGRIDComponentAdapterBinding {
    Set<IActionListener> m_listeners;
    Set<String> m_fixAttributeNames = new HashSet<String>();
    Set<String> m_dynamicAttributeNames = new HashSet<String>();
    Map<String, Class> m_dynamicAttributeTypes = new HashMap<String, Class>();

    public ComponentAdapterBindingBase(String[] fixAttributeNames, String[] dynamicAttributeNames) {
        for (String attribute : fixAttributeNames) {
            this.m_fixAttributeNames.add(attribute);
        }
        for (String attribute : dynamicAttributeNames) {
            this.m_dynamicAttributeNames.add(attribute);
        }
    }

    public ComponentAdapterBindingBase(String[] fixAttributeNames, String[] dynamicAttributeNames, Class[] dynamicAttributeTypes) {
        this(fixAttributeNames, dynamicAttributeNames);
        if (dynamicAttributeNames.length != dynamicAttributeTypes.length) {
            throw new Error("dynamicAttributeNames and dynamicAttributeTypes: number of array elements must be the same!");
        }
        int i = 0;
        for (Class attributeType : dynamicAttributeTypes) {
            this.m_dynamicAttributeTypes.put(dynamicAttributeNames[i], attributeType);
            ++i;
        }
    }

    @Override
    public Set<String> getDynamicAttributeNames() {
        return this.m_dynamicAttributeNames;
    }

    @Override
    public Set<String> getFixAttributeNames() {
        return this.m_fixAttributeNames;
    }

    @Override
    public Class getAttibuteType(String attributeName) {
        return this.m_dynamicAttributeTypes.get(attributeName);
    }

    @Override
    public void onAction(ActionEvent event) {
        if (this.m_listeners == null) {
            return;
        }
        for (IActionListener listener : this.m_listeners) {
            listener.reactOnActionListenerInvoked(this, event);
        }
    }

    public void addActionListener(IActionListener listener) {
        if (this.m_listeners == null) {
            this.m_listeners = new HashSet<IActionListener>();
        }
        this.m_listeners.add(listener);
    }

    public void removeActionListener(IActionListener listener) {
        if (this.m_listeners == null) {
            return;
        }
        this.m_listeners.remove(listener);
    }

    @Override
    public FIXGRIDBinding<?> getGrid() {
        Object o = this.getAttributeValue("objectbinding");
        if (o == null) {
            return null;
        }
        if (!(o instanceof FIXGRIDBinding)) {
            throw new Error("Error occurred when accessing grid value in adapter component binding. The value behind \"objectbinding\" must return an instance of FIXGRIDListBinding.");
        }
        return (FIXGRIDBinding)o;
    }

    @Override
    public void initComponent(IBaseComponent component) {
    }

    public Object getSortValue() {
        return ComponentAdapterUtil.getSortValue(this, this.m_dynamicAttributeNames, this.m_fixAttributeNames);
    }

    public Object getExportValue() {
        return this.getSortValue();
    }

    public String getExportValueFormat() {
        return ComponentAdapterUtil.getExportValueFormat(this, this.m_dynamicAttributeNames, this.m_fixAttributeNames);
    }

    public String getExportValueFormatmask() {
        return ComponentAdapterUtil.getExportValueFormatmask(this, this.m_dynamicAttributeNames, this.m_fixAttributeNames);
    }

    public String getExportValueTimezone() {
        return ComponentAdapterUtil.getExportValueTimezone(this, this.m_dynamicAttributeNames, this.m_fixAttributeNames);
    }
}

