/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.elements.macros;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import org.eclnt.jsfserver.configuration.CCConfigurationObjectLoader;
import org.eclnt.jsfserver.elements.macros.IDefaultMacro;
import org.eclnt.jsfserver.elements.macros.IMacro;
import org.eclnt.jsfserver.elements.macros.XMLMacro;
import org.eclnt.jsfserver.managedbean.DefaultHotDeployListener;
import org.eclnt.jsfserver.managedbean.HotDeployClassLoader;
import org.eclnt.jsfserver.managedbean.HotDeployNotifier;
import org.eclnt.jsfserver.util.WebResourceClassloaderReader;
import org.eclnt.jsfserver.util.parse.SAXParserUtil;
import org.eclnt.util.classresolver.CCClassResolver;
import org.eclnt.util.classresolver.ENUMCallerType;
import org.eclnt.util.file.FileManager;
import org.eclnt.util.log.CLog;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MacroFactory
implements Serializable {
    static final Object SYNCHER = new Object();
    static ServletContext s_servletContext;
    static MacroFactory s_instance;
    static Map<String, MacroFactory> s_dirInstances;
    Map<String, IMacro> m_macros = new HashMap<String, IMacro>();
    Set<IDefaultMacro> m_defaultMacros = new HashSet<IDefaultMacro>();
    Map<String, List<IMacro>> m_macrosPerTag = new HashMap<String, List<IMacro>>();
    boolean m_isInitialized = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initializeWebappInstance(ServletContext servletContext) {
        if (s_instance != null) {
            return;
        }
        Object object = SYNCHER;
        synchronized (object) {
            if (s_instance != null) {
                return;
            }
            CLog.L.log(CLog.LL_INF, "MacroFactory: Initialization");
            MacroFactory newMFInstance = new MacroFactory();
            String javamacrosXML = null;
            try {
                javamacrosXML = WebResourceClassloaderReader.readUTF8FileIntoString("/eclntjsfserver/config/macros/javamacros.xml", false);
                if (javamacrosXML != null) {
                    JavaMacrosParser jmp = new JavaMacrosParser();
                    SAXParserUtil.parse(javamacrosXML, (DefaultHandler)jmp);
                    for (String classname : jmp.i_macroClassnames) {
                        CLog.L.log(CLog.LL_INF, "MacroFactory: java macro: " + classname);
                        IMacro m = (IMacro)CCConfigurationObjectLoader.instance().loadInstance(classname, true);
                        if (!(m instanceof IDefaultMacro)) {
                            CLog.L.log(CLog.LL_INF, "Registering Java macro: " + m.getName() + "/" + m.getClass().getName());
                            newMFInstance.m_macros.put(m.getName(), m);
                            continue;
                        }
                        newMFInstance.m_defaultMacros.add((IDefaultMacro)m);
                    }
                }
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_ERR, "Problem when reading and parsing javamacros.xml:\n" + javamacrosXML, t);
            }
            Set<String> macrosFilenames = WebResourceClassloaderReader.getFilesInPathDirectory("/eclntjsfserver/config/macros/", ".xml");
            Iterator<String> iter = macrosFilenames.iterator();
            while (iter.hasNext()) {
                try {
                    String fileName = iter.next();
                    CLog.L.log(CLog.LL_INF, "MacroFactory: XML macro: " + fileName);
                    String macroName = fileName.substring(0, fileName.length() - 4);
                    if (macroName.equalsIgnoreCase("javamacros")) continue;
                    CLog.L.log(CLog.LL_INF, "Registering macro: " + macroName);
                    fileName = "/eclntjsfserver/config/macros/" + fileName;
                    String xml = WebResourceClassloaderReader.readUTF8FileIntoString(fileName, true);
                    XMLMacro macro = new XMLMacro(macroName, xml);
                    newMFInstance.m_macros.put(macroName, macro);
                }
                catch (Throwable t) {
                    CLog.L.log(CLog.LL_ERR, "Error whene reading and building macro.", t);
                }
            }
            newMFInstance.m_isInitialized = true;
            s_instance = newMFInstance;
        }
    }

    public static MacroFactory getWebappInstance() {
        MacroFactory.initializeWebappInstance(s_servletContext);
        return s_instance;
    }

    public static MacroFactory getDirInstance(String directory, ClassLoader macroClassLoader) {
        MacroFactory result = s_dirInstances.get(directory = directory + "eclntjsfserver/config/macros/");
        if (result == null) {
            result = MacroFactory.initializeDirInstance(null, directory, macroClassLoader);
            s_dirInstances.put(directory, result);
        } else if (!result.m_isInitialized) {
            MacroFactory.initializeDirInstance(result, directory, macroClassLoader);
        }
        return result;
    }

    public static void refreshDirInstances() {
        for (String directory : s_dirInstances.keySet()) {
            MacroFactory mf = s_dirInstances.get(directory);
            mf.m_isInitialized = false;
        }
    }

    public IMacro getMacro(String macroName) {
        return this.m_macros.get(macroName);
    }

    public List<IMacro> getMacros(String tagName) {
        List<IMacro> result = this.m_macrosPerTag.get(tagName);
        if (result != null) {
            return result;
        }
        result = new ArrayList<IMacro>();
        for (IMacro macro : this.m_macros.values()) {
            if (!macro.checkIfApplicable(tagName)) continue;
            result.add(macro);
        }
        this.m_macrosPerTag.put(tagName, result);
        return result;
    }

    public Set<IDefaultMacro> getDefaultMacros() {
        return this.m_defaultMacros;
    }

    private static MacroFactory initializeDirInstance(MacroFactory result, String dirName, ClassLoader macroClassLoader) {
        if (result == null) {
            result = new MacroFactory();
        } else {
            result.m_macros.clear();
            result.m_macrosPerTag.clear();
        }
        try {
            String javamacrosXML = FileManager.readUTF8File(dirName + "/javamacros.xml", false);
            if (javamacrosXML != null && javamacrosXML.length() > 0) {
                JavaMacrosParser jmp = new JavaMacrosParser();
                SAXParserUtil.parse(javamacrosXML, (DefaultHandler)jmp);
                for (String classname : jmp.i_macroClassnames) {
                    try {
                        Class clazz = CCClassResolver.resolveClass(classname, false, macroClassLoader, ENUMCallerType.UTIL);
                        IMacro m = (IMacro)clazz.newInstance();
                        CLog.L.log(CLog.LL_INF, "Registering Java macro: " + m.getName() + "/" + m.getClass().getName());
                        result.m_macros.put(m.getName(), m);
                    }
                    catch (Throwable tt) {
                        CLog.L.log(CLog.LL_ERR, "Problem when creating design time instance of macro: " + classname, tt);
                    }
                }
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Problem when reading and parsing javamacros.xml", t);
        }
        List<File> macroFiles = FileManager.getFilesOfDirectory(dirName);
        Iterator<File> iter = macroFiles.iterator();
        while (iter.hasNext()) {
            try {
                String macroName;
                File macroFile = iter.next();
                String fileName = macroFile.getName();
                if (!fileName.endsWith(".xml") || (macroName = fileName.substring(0, fileName.length() - 4)).equalsIgnoreCase("javamacros")) continue;
                CLog.L.log(CLog.LL_INF, "Registering macro: " + macroName);
                fileName = macroFile.getAbsolutePath();
                String xml = FileManager.readUTF8File(fileName, true);
                XMLMacro macro = new XMLMacro(macroName, xml);
                result.m_macros.put(macroName, macro);
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_ERR, "Error whene reading and building macro.", t);
            }
        }
        result.m_isInitialized = true;
        return result;
    }

    static {
        s_dirInstances = new HashMap<String, MacroFactory>();
        HotDeployNotifier.addListener(new DefaultHotDeployListener(){

            @Override
            public void onClassLoaderUpdate(ClassLoader newClassLoader) {
                if (s_instance != null) {
                    boolean oneIsHotDeployed = false;
                    for (IMacro macro : MacroFactory.s_instance.m_macros.values()) {
                        if (!(macro.getClass().getClassLoader() instanceof HotDeployClassLoader)) continue;
                        oneIsHotDeployed = true;
                        break;
                    }
                    if (oneIsHotDeployed) {
                        s_instance = null;
                    }
                }
            }
        });
    }

    static class JavaMacrosParser
    extends DefaultHandler
    implements Serializable {
        List<String> i_macroClassnames = new ArrayList<String>();

        JavaMacrosParser() {
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            String className;
            if (name.equals("javamacro") && (className = attributes.getValue("classname")) != null) {
                this.i_macroClassnames.add(className);
            }
        }
    }
}

