/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.elements.util;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.FontSelector;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.eclnt.jsfserver.elements.impl.FIXGRIDBinding;
import org.eclnt.jsfserver.elements.impl.FIXGRIDComponent;
import org.eclnt.jsfserver.elements.impl.FIXGRIDExportSanitizer;
import org.eclnt.jsfserver.elements.impl.IFIXGRIDPdfExporter;
import org.eclnt.jsfserver.elements.util.DefaultFIXGRIDExportInfoProvider;
import org.eclnt.jsfserver.elements.util.ENUMExportType;
import org.eclnt.jsfserver.elements.util.IFIXGRIDExportInfoProvider;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;

public class FIXGRIDPDFExporter
implements IFIXGRIDPdfExporter,
Serializable {
    public static Font FONT_TITLE = new Font(1, 14.0f, 1);
    public static Font FONT_HEADLINE = new Font(1, 12.0f, 1);
    public static Font FONT_FOOTERLINE = new Font(1, 12.0f, 1);
    public static Font FONT_DATALINE = null;
    public static Color COLOR_HEADLINE = Color.LIGHT_GRAY;
    public static Color COLOR_FOOTERLINE = Color.LIGHT_GRAY;
    public static Color COLOR_LIGHTROW = null;
    public static Color COLOR_DARKROW = ValueManager.decodeColor("#f0f0f0");
    Font m_FONT_TITLE = FONT_TITLE;
    Font m_FONT_HEADLINE = FONT_HEADLINE;
    Font m_FONT_FOOTERLINE = FONT_FOOTERLINE;
    Font m_FONT_DATALINE = FONT_DATALINE;
    FontSelector m_fontselector_TITLE;
    FontSelector m_fontselector_HEADLINE;
    FontSelector m_fontselector_FOOTERLINE;
    FontSelector m_fontselector_DATALINE;
    Color m_COLOR_HEADLINE = COLOR_HEADLINE;
    Color m_COLOR_FOOTERLINE = COLOR_FOOTERLINE;
    Color m_COLOR_LIGHTROW = COLOR_LIGHTROW;
    Color m_COLOR_DARKROW = COLOR_DARKROW;
    String m_gridTitle = null;
    float m_pageSizeWidth = PageSize.A4.getWidth();
    float m_pageSizeHeight = PageSize.A4.getHeight();
    IFIXGRIDExportInfoProvider m_exportInfoProvider = new DefaultFIXGRIDExportInfoProvider();
    float m_columnSizeFactor = 1.0f;

    @Override
    public void initPageSize(float width, float height) {
        this.m_pageSizeWidth = width;
        this.m_pageSizeHeight = height;
    }

    @Override
    public void setFontTitle(Font value) {
        this.m_FONT_TITLE = value;
    }

    @Override
    public void setFontHeadline(Font value) {
        this.m_FONT_HEADLINE = value;
    }

    @Override
    public void setFontFooterline(Font value) {
        this.m_FONT_FOOTERLINE = value;
    }

    @Override
    public void setFontDataline(Font value) {
        this.m_FONT_DATALINE = value;
    }

    public void setColorHeadline(Color value) {
        this.m_COLOR_HEADLINE = value;
    }

    public void setColorFooterline(Color value) {
        this.m_COLOR_FOOTERLINE = value;
    }

    public void setColorLightRow(Color value) {
        this.m_COLOR_LIGHTROW = value;
    }

    public void setColorDarkRow(Color value) {
        this.m_COLOR_DARKROW = value;
    }

    @Override
    public void setFontselectorTitle(FontSelector value) {
        this.m_fontselector_TITLE = value;
    }

    @Override
    public void setFontselectorHeadline(FontSelector value) {
        this.m_fontselector_HEADLINE = value;
    }

    @Override
    public void setFontselectorFooterline(FontSelector value) {
        this.m_fontselector_FOOTERLINE = value;
    }

    @Override
    public void setFontselectorDataline(FontSelector value) {
        this.m_fontselector_DATALINE = value;
    }

    @Override
    public void setGridTitle(String title) {
        this.m_gridTitle = title;
    }

    public String getGridTitle() {
        return this.m_gridTitle;
    }

    @Override
    public void setColumnSizeFactor(float columnSizeFactor) {
        this.m_columnSizeFactor = columnSizeFactor;
    }

    @Override
    public float getColumnSizeFactor() {
        return this.m_columnSizeFactor;
    }

    @Override
    public void setExportInfoProvider(IFIXGRIDExportInfoProvider exportInfoProvider) {
        this.m_exportInfoProvider = exportInfoProvider;
    }

    @Override
    public byte[] exportGridToPdf(FIXGRIDBinding fixgrid, List<FIXGRIDComponent.ColumnInfo> columns, List<List<String>> data, boolean selctedItemsOnly) {
        try {
            FIXGRIDExportSanitizer.instance().sanitizeStringDataBeforeExport(ENUMExportType.PDF, data);
            Document document = this.createDocument(fixgrid, columns);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)bos);
            document.open();
            if (this.m_gridTitle != null) {
                this.beforeTitle(document, fixgrid, columns, data);
                this.printTitle(document, fixgrid, columns, data);
                this.afterTitle(document, fixgrid, columns, data);
            }
            this.beforeGrid(document, fixgrid, columns, data);
            PdfPTable table = this.createPdfTable(columns);
            this.buildHeaderAndFooterRows(fixgrid, columns, data, table);
            this.buildDataRows(fixgrid, columns, data, table);
            document.add((Element)table);
            this.afterGrid(document, fixgrid, columns, data);
            document.close();
            return bos.toByteArray();
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "", t);
            return null;
        }
    }

    protected void buildDataRows(FIXGRIDBinding fixgrid, List<FIXGRIDComponent.ColumnInfo> columns, List<List<String>> data, PdfPTable table) {
        boolean darkRow = true;
        int rowIndex = 0;
        for (List<String> dataRow : data) {
            darkRow = !darkRow;
            Color c = null;
            c = darkRow ? this.m_COLOR_DARKROW : this.m_COLOR_LIGHTROW;
            this.buildRow(columns, table, rowIndex, dataRow, c);
            ++rowIndex;
        }
    }

    protected PdfPTable createPdfTable(List<FIXGRIDComponent.ColumnInfo> columns) throws DocumentException {
        PdfPTable table = new PdfPTable(columns.size());
        table.setWidthPercentage(100.0f);
        table.setHorizontalAlignment(0);
        int[] widths = new int[columns.size()];
        for (int i = 0; i < columns.size(); ++i) {
            widths[i] = this.calculateColumnWidth(columns.get(i));
        }
        table.setWidths(widths);
        return table;
    }

    protected void applyBackgroundColorStrToCell(String colorString, PdfPCell cell, Color nullColor) {
        Color color = ValueManager.decodeColor(colorString);
        if (color == null) {
            color = nullColor;
        }
        if (color != null) {
            cell.setBackgroundColor(color);
        }
    }

    protected void applyRowHeightToCell(Float rowHeight, PdfPCell cell) {
        if (rowHeight != null) {
            cell.setFixedHeight(rowHeight.floatValue());
        }
    }

    private void applyAlignStrToCell(PdfPCell cell, String align) {
        if ("right".equals(align) || "right!".equals(align)) {
            cell.setHorizontalAlignment(2);
        } else if ("center".equals(align)) {
            cell.setHorizontalAlignment(1);
        }
    }

    protected void applyFontStrToParagraph(Paragraph p, String fontStr) {
        if (fontStr != null && p.getFont() != null) {
            String sizeStr;
            int size;
            Map<String, String> fontValues = ValueManager.decodeComplexValue(fontStr);
            String weight = fontValues.get("weight");
            if ("bold".equals(weight)) {
                p.getFont().setStyle(1);
            }
            if ((size = ValueManager.decodeIntWithRounding(sizeStr = fontValues.get("size"), -1)) > 0) {
                p.getFont().setSize((float)size);
            }
        }
    }

    protected void buildHeaderAndFooterRows(FIXGRIDBinding fixgrid, List<FIXGRIDComponent.ColumnInfo> columns, List<List<String>> data, PdfPTable table) {
        String colorString;
        Float rowHeight;
        PdfPCell cell;
        Paragraph p;
        FIXGRIDComponent.ColumnInfo ci;
        int i;
        List<List<FIXGRIDBinding.FormattedValue>> headerRows = fixgrid.getExporter().exportToValueListHeader();
        FIXGRIDExportSanitizer.instance().sanitizeValueDataBeforeExport(ENUMExportType.PDF, headerRows);
        if (this.m_exportInfoProvider != null) {
            headerRows = this.m_exportInfoProvider.updateHeaderRowValues(headerRows);
        }
        List<List<FIXGRIDBinding.FormattedValue>> footerRows = fixgrid.getExporter().exportToValueListFooter();
        FIXGRIDExportSanitizer.instance().sanitizeValueDataBeforeExport(ENUMExportType.PDF, footerRows);
        if (this.m_exportInfoProvider != null) {
            footerRows = this.m_exportInfoProvider.updateFooterRowValues(footerRows);
        }
        if (data.size() > 0) {
            table.setHeaderRows(headerRows.size() + footerRows.size());
            table.setFooterRows(footerRows.size());
        }
        int rowCounter = -1;
        for (List<FIXGRIDBinding.FormattedValue> row : headerRows) {
            ++rowCounter;
            for (i = 0; i < row.size(); ++i) {
                ci = columns.get(i);
                p = this.createParagraph(row.get(i).toDisplayString(), this.m_FONT_HEADLINE, this.m_fontselector_HEADLINE);
                cell = new PdfPCell((Phrase)p);
                rowHeight = this.findExplicitHeaderRowHeight(rowCounter);
                this.applyRowHeightToCell(rowHeight, cell);
                colorString = this.findBackgroundColorForHeaderCell(rowCounter, row.get(i).toDisplayString(), columns.get(i));
                this.applyBackgroundColorStrToCell(colorString, cell, this.m_COLOR_FOOTERLINE);
                Object textColor = null;
                String textColorString = this.findTextColorForHeaderCell(rowCounter, row.get(i).toDisplayString(), columns.get(i));
                this.applyTextColorStrToParagraph(textColorString, p);
                String align = this.findAlignmentForHeaderCell(rowCounter, row.get(i), columns.get(i));
                this.applyAlignStrToCell(cell, align);
                String fontStr = this.findFontForHeaderCell(rowCounter, row.get(i).toDisplayString(), columns.get(i));
                this.applyFontStrToParagraph(p, fontStr);
                int colspan = this.findColspan(row, i);
                if (colspan > 1) {
                    cell.setColspan(colspan);
                    i += colspan - 1;
                }
                table.addCell(cell);
            }
        }
        rowCounter = -1;
        for (List<FIXGRIDBinding.FormattedValue> row : footerRows) {
            for (i = 0; i < row.size(); ++i) {
                ci = columns.get(i);
                p = this.createParagraph(row.get(i).toDisplayString(), this.m_FONT_FOOTERLINE, this.m_fontselector_FOOTERLINE);
                cell = new PdfPCell((Phrase)p);
                rowHeight = this.findExplicitFooterRowHeight(rowCounter);
                this.applyRowHeightToCell(rowHeight, cell);
                colorString = this.findBackgroundColorForFooterCell(rowCounter, row.get(i).toDisplayString(), columns.get(i));
                this.applyBackgroundColorStrToCell(colorString, cell, this.m_COLOR_FOOTERLINE);
                String textColorString = this.findTextColorForFooterCell(rowCounter, row.get(i).toDisplayString(), columns.get(i));
                this.applyTextColorStrToParagraph(textColorString, p);
                String align = this.findAlignmentForFooterCell(rowCounter, row.get(i), columns.get(i));
                this.applyAlignStrToCell(cell, align);
                String fontStr = this.findFontForFooterCell(rowCounter, row.get(i).toDisplayString(), columns.get(i));
                this.applyFontStrToParagraph(p, fontStr);
                table.addCell(cell);
            }
        }
    }

    protected void buildRow(List<FIXGRIDComponent.ColumnInfo> columns, PdfPTable table, int dataRowIndex, List<String> dataRow, Color rowToggleColor) {
        int colCounter = 0;
        Float rowHeight = this.findExplicitRowHeight(dataRowIndex);
        for (String dataCell : dataRow) {
            Paragraph p = null;
            p = this.createParagraph(this.objectToString(dataCell), this.m_FONT_DATALINE, this.m_fontselector_DATALINE);
            PdfPCell cell = new PdfPCell((Phrase)p);
            this.applyRowHeightToCell(rowHeight, cell);
            String rowColorString = this.findBackgroundColorForDataCell(dataRowIndex, dataCell, columns.get(colCounter));
            this.applyBackgroundColorStrToCell(rowColorString, cell, rowToggleColor);
            String align = this.findAlignmentForDataCell(dataRowIndex, dataCell, columns.get(colCounter));
            this.applyAlignStrToCell(cell, align);
            Object textColor = null;
            String textColorString = this.findTextColorForDataCell(dataRowIndex, dataCell, columns.get(colCounter));
            this.applyTextColorStrToParagraph(textColorString, p);
            String fontStr = this.findFontForDataCell(dataRowIndex, dataCell, columns.get(colCounter));
            this.applyFontStrToParagraph(p, fontStr);
            table.addCell(cell);
            ++colCounter;
        }
    }

    protected void applyTextColorStrToParagraph(String textColorString, Paragraph p) {
        Color textColor = ValueManager.decodeColor(textColorString);
        if (textColor != null && p.getFont() != null) {
            p.getFont().setColor(textColor);
        }
    }

    protected Float findExplicitRowHeight(int dataRowIndex) {
        if (this.m_exportInfoProvider != null) {
            try {
                return this.m_exportInfoProvider.findPDFHeightForDataRow(dataRowIndex);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    protected Float findExplicitHeaderRowHeight(int rowIndex) {
        if (this.m_exportInfoProvider != null) {
            try {
                return this.m_exportInfoProvider.findPDFHeightForHeaderRow(rowIndex);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    protected Float findExplicitFooterRowHeight(int rowIndex) {
        if (this.m_exportInfoProvider != null) {
            try {
                return this.m_exportInfoProvider.findPDFHeightForFooterRow(rowIndex);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    protected String findBackgroundColorForDataCell(int rowIndex, String dataCellValue, FIXGRIDComponent.ColumnInfo column) {
        if (this.m_exportInfoProvider != null) {
            try {
                return this.m_exportInfoProvider.findBackgroundColorForDataCell(rowIndex, dataCellValue, column);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    protected String findBackgroundColorForHeaderCell(int rowIndex, String dataCellValue, FIXGRIDComponent.ColumnInfo column) {
        if (this.m_exportInfoProvider != null) {
            try {
                return this.m_exportInfoProvider.findBackgroundColorForHeaderCell(rowIndex, dataCellValue, column);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    protected String findBackgroundColorForFooterCell(int rowIndex, String dataCellValue, FIXGRIDComponent.ColumnInfo column) {
        if (this.m_exportInfoProvider != null) {
            try {
                return this.m_exportInfoProvider.findBackgroundColorForFooterCell(rowIndex, dataCellValue, column);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    protected String findAlignmentForDataCell(int rowIndex, String dataCellValue, FIXGRIDComponent.ColumnInfo column) {
        if (this.m_exportInfoProvider != null) {
            try {
                return this.m_exportInfoProvider.findAlignmentForDataCell(rowIndex, dataCellValue, column);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return column.getAlignment();
    }

    protected String findAlignmentForHeaderCell(int headerRowIndex, FIXGRIDBinding.FormattedValue dataCellValue, FIXGRIDComponent.ColumnInfo column) {
        if (this.m_exportInfoProvider != null) {
            try {
                return this.m_exportInfoProvider.findAlignmentForHeaderCell(headerRowIndex, dataCellValue, column);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return dataCellValue.getAlign();
    }

    protected String findAlignmentForFooterCell(int footerRowIndex, FIXGRIDBinding.FormattedValue dataCellValue, FIXGRIDComponent.ColumnInfo column) {
        if (this.m_exportInfoProvider != null) {
            try {
                return this.m_exportInfoProvider.findAlignmentForFooterCell(footerRowIndex, dataCellValue, column);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return dataCellValue.getAlign();
    }

    protected String findTextColorForDataCell(int rowIndex, String dataCellValue, FIXGRIDComponent.ColumnInfo column) {
        if (this.m_exportInfoProvider != null) {
            try {
                return this.m_exportInfoProvider.findTextColorForDataCell(rowIndex, dataCellValue, column);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    protected String findTextColorForHeaderCell(int rowIndex, String dataCellValue, FIXGRIDComponent.ColumnInfo column) {
        if (this.m_exportInfoProvider != null) {
            try {
                return this.m_exportInfoProvider.findTextColorForHeaderCell(rowIndex, dataCellValue, column);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    protected String findTextColorForFooterCell(int rowIndex, String dataCellValue, FIXGRIDComponent.ColumnInfo column) {
        if (this.m_exportInfoProvider != null) {
            try {
                return this.m_exportInfoProvider.findTextColorForFooterCell(rowIndex, dataCellValue, column);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    protected String findFontForDataCell(int rowIndex, String dataCellValue, FIXGRIDComponent.ColumnInfo column) {
        if (this.m_exportInfoProvider != null) {
            try {
                return this.m_exportInfoProvider.findFontForDataCell(rowIndex, dataCellValue, column);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    protected String findFontForHeaderCell(int rowIndex, String dataCellValue, FIXGRIDComponent.ColumnInfo column) {
        if (this.m_exportInfoProvider != null) {
            try {
                return this.m_exportInfoProvider.findFontForHeaderCell(rowIndex, dataCellValue, column);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    protected String findFontForFooterCell(int rowIndex, String dataCellValue, FIXGRIDComponent.ColumnInfo column) {
        if (this.m_exportInfoProvider != null) {
            try {
                return this.m_exportInfoProvider.findFontForFooterCell(rowIndex, dataCellValue, column);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    protected Document createDocument(FIXGRIDBinding fixgrid, List<FIXGRIDComponent.ColumnInfo> columns) {
        int accumulatedWidth = 0;
        for (FIXGRIDComponent.ColumnInfo ci : columns) {
            accumulatedWidth += this.calculateColumnWidth(ci);
        }
        if ((float)accumulatedWidth < this.m_pageSizeWidth) {
            accumulatedWidth = (int)this.m_pageSizeWidth;
        }
        Document document = new Document();
        document.setPageSize(new Rectangle((float)accumulatedWidth, this.m_pageSizeHeight));
        return document;
    }

    protected void beforeTitle(Document document, FIXGRIDBinding fixgrid, List<FIXGRIDComponent.ColumnInfo> columns, List<List<String>> data) {
    }

    protected void printTitle(Document document, FIXGRIDBinding fixgrid, List<FIXGRIDComponent.ColumnInfo> columns, List<List<String>> data) {
        if (this.m_gridTitle == null) {
            return;
        }
        try {
            Paragraph titleParagraph = this.createParagraph(this.m_gridTitle, this.m_FONT_TITLE, this.m_fontselector_TITLE);
            titleParagraph.setSpacingAfter(10.0f);
            document.add((Element)titleParagraph);
        }
        catch (DocumentException exc) {
            CLog.L.log(CLog.LL_ERR, "Problems when adding the title to the PDF document: " + this.m_gridTitle, exc);
        }
    }

    protected void afterTitle(Document document, FIXGRIDBinding fixgrid, List<FIXGRIDComponent.ColumnInfo> columns, List<List<String>> data) {
    }

    protected void beforeGrid(Document document, FIXGRIDBinding fixgrid, List<FIXGRIDComponent.ColumnInfo> columns, List<List<String>> data) {
    }

    protected void afterGrid(Document document, FIXGRIDBinding fixgrid, List<FIXGRIDComponent.ColumnInfo> columns, List<List<String>> data) {
    }

    protected int calculateColumnWidth(FIXGRIDComponent.ColumnInfo ci) {
        int w = ci.getExportWidth();
        if (w < 0) {
            w = ci.getWidth();
        }
        if (w < 0) {
            w = Math.round(-300.0f * (float)w / 100.0f);
            if (ci.getMinWidth() > 0 && w < ci.getMinWidth()) {
                w = ci.getMinWidth();
            }
        }
        if (this.m_columnSizeFactor != 1.0f) {
            w = Math.round((float)w * this.m_columnSizeFactor);
        }
        if (this.m_exportInfoProvider != null) {
            w = this.m_exportInfoProvider.findColumnWidthForPDFColumn(ci, w);
        }
        return w;
    }

    protected String objectToString(String s) {
        if (s == null) {
            s = " ";
        }
        if (s.length() == 0) {
            s = " ";
        }
        return s;
    }

    protected Paragraph createParagraph(String text, Font font, FontSelector fontSelector) {
        Paragraph result = null;
        if (fontSelector != null) {
            try {
                Phrase ph = fontSelector.process(text);
                result = new Paragraph(ph);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (result == null && font != null) {
            try {
                font = new Font(font);
                result = new Paragraph(text, font);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (result == null) {
            result = new Paragraph(text);
        }
        return result;
    }

    private int findColspan(List<FIXGRIDBinding.FormattedValue> row, int currentIndex) {
        String value;
        int colspan = 1;
        for (int i = currentIndex + 1; i < row.size() && ValueManager.checkIfStringsAreEqual(value = row.get(i).toString(), ".%."); ++i) {
            ++colspan;
        }
        return colspan;
    }
}

