/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.managedbean;

import java.util.ArrayList;
import java.util.List;
import org.eclnt.jsfserver.managedbean.HotDeployManager;
import org.eclnt.jsfserver.managedbean.IHotDeployListener;
import org.eclnt.util.buffermgmt.IResetBuffer;
import org.eclnt.util.buffermgmt.ResetBuffers;

public class HotDeployNotifier {
    static List<IHotDeployListener> s_listeners = new ArrayList<IHotDeployListener>();

    public static synchronized void addListener(IHotDeployListener listener) {
        if (s_listeners.contains(listener)) {
            return;
        }
        s_listeners.add(listener);
    }

    public static synchronized void removeListener(IHotDeployListener listener) {
        s_listeners.remove(listener);
    }

    public static void notifyNewClassLoader(ClassLoader hotDeployClassLoader) {
        for (IHotDeployListener listener : s_listeners) {
            listener.onClassLoaderUpdate(hotDeployClassLoader);
        }
        for (IHotDeployListener listener : s_listeners) {
            listener.onClassLoaderUpdateFinished(hotDeployClassLoader);
        }
    }

    static {
        ResetBuffers.addListenerClassSwap(new IResetBuffer(){

            @Override
            public void reset() {
                HotDeployNotifier.notifyNewClassLoader(HotDeployManager.currentClassLoader());
            }
        });
    }
}

