/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.polling.websocket;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.websocket.EndpointConfig;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerContainer;
import javax.websocket.server.ServerEndpoint;
import javax.websocket.server.ServerEndpointConfig;
import org.eclnt.jsfserver.polling.websocket.DefaultLongPollingWebSocket;
import org.eclnt.jsfserver.polling.websocket.WebSocketSessionConfigurator;
import org.eclnt.jsfserver.util.SystemXml;
import org.eclnt.util.log.CLog;

@ServerEndpoint(value="/ccwebsocketpolling/{pollerId}", configurator=WebSocketSessionConfigurator.class)
public class WebSocketPollingEndPoint {
    static boolean s_initialized = false;
    String m_pollerId;
    DefaultLongPollingWebSocket m_longPolling;
    Session m_webSocketSession;

    public static boolean checkIfInitialized() {
        return s_initialized;
    }

    public static void init(ServletContext context) {
        try {
            if (SystemXml.getWebsocketAvoidApiRegistration()) {
                CLog.L.log(CLog.LL_INF, "Initializing web socket end point - is switched off by system.xml configuration");
                return;
            }
            CLog.L.log(CLog.LL_INF, "Initializing web socket end point. Begin...");
            ServerContainer container = (ServerContainer)context.getAttribute(ServerContainer.class.getName());
            if (container == null) {
                CLog.L.log(CLog.LL_INF, "Web socket endpoint intialization not done: ServerContainer is null");
                CLog.L.log(CLog.LL_INF, "...may be fine in some environments, in which ServerConainer is created at late point of time");
                return;
            }
            ServerEndpointConfig config = ServerEndpointConfig.Builder.create(WebSocketPollingEndPoint.class, (String)"/ccwebsocketpolling/{pollerId}").configurator((ServerEndpointConfig.Configurator)new WebSocketSessionConfigurator()).build();
            container.addEndpoint(config);
            CLog.L.log(CLog.LL_INF, "Initializing web socket end point. ...End.");
            s_initialized = true;
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problem registering web socket end point", t);
            CLog.L.log(CLog.LL_INF, "Startup will be continued: but web socket polling is NOT available in this instance");
        }
    }

    @OnOpen
    public void onOpen(@PathParam(value="pollerId") String pollerId, Session webSocketSession, EndpointConfig config) {
        CLog.L.log(CLog.LL_INF, "ccwebsocketpolling - onOpen: pollerId = " + pollerId);
        this.m_pollerId = pollerId;
        this.m_webSocketSession = webSocketSession;
        HttpSession httpSession = (HttpSession)config.getUserProperties().get(HttpSession.class.getName());
        if (httpSession != null) {
            Object o = httpSession.getAttribute("cclongpolling_" + pollerId);
            if (o == null) {
                CLog.L.log(CLog.LL_ERR, "Could not find long polling object for id: " + this.m_pollerId);
                return;
            }
            if (o instanceof DefaultLongPollingWebSocket) {
                this.m_longPolling = (DefaultLongPollingWebSocket)o;
                this.m_longPolling.registerEndPoint(this);
            } else {
                CLog.L.log(CLog.LL_ERR, "Long polling object is of class: " + o.getClass().getName());
                CLog.L.log(CLog.LL_ERR, "Long polling object but must be: " + DefaultLongPollingWebSocket.class.getName());
            }
        } else {
            try {
                CLog.L.log(CLog.LL_INF, "Websocket: Could not find httpSession assigned to the web socket connection");
                CLog.L.log(CLog.LL_INF, "Websocket: Now sending signal to abort to client");
                this.sendMessage("false");
                CLog.L.log(CLog.LL_INF, "Websocket: Now closing connection");
                this.close();
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_INF, "Problem sending websocket to abort connection");
            }
        }
    }

    @OnClose
    public void onClose() {
        CLog.L.log(CLog.LL_INF, "ccwebsocketpolling - onClose");
        if (this.m_longPolling != null) {
            CLog.L.log(CLog.LL_INF, "ccwebsocketpolling - onClose: unregistering from long polling");
            try {
                this.m_longPolling.unregisterEndPoint(this);
            }
            catch (Throwable throwable) {}
        } else {
            CLog.L.log(CLog.LL_INF, "ccwebsocketpolling - onClose: no unregistering required, longpolling is null");
        }
    }

    @OnError
    public void onError(Throwable t) {
        CLog.L.log(CLog.LL_INF, "ccwebsocketpolling - on Error: " + t.getMessage());
    }

    @OnMessage
    public String onMessage(String message) {
        CLog.L.log(CLog.LL_INF, "ccwebsocketpolling - onMessage: " + message);
        return "";
    }

    public void sendMessage(String message) throws IOException {
        CLog.L.log(CLog.LL_INF, "ccwebsocketpolling - sendMessage: " + message);
        this.m_webSocketSession.getBasicRemote().sendText(message);
        CLog.L.log(CLog.LL_INF, "ccwebsocketpolling - sendMessage: finished");
    }

    public void close() {
        try {
            CLog.L.log(CLog.LL_INF, "ccwebsocketpolling - close");
            if (this.m_webSocketSession != null) {
                this.m_webSocketSession.close();
            }
            this.m_webSocketSession = null;
            this.m_longPolling = null;
            CLog.L.log(CLog.LL_INF, "ccwebsocketpolling - close finished");
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problem closing end point", t);
        }
    }
}

