/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.streamstore.personalization;

import org.eclnt.jsfserver.streamstore.IStreamStore;
import org.eclnt.jsfserver.streamstore.StreamStore;
import org.eclnt.jsfserver.util.useraccess.UserAccessMgr;
import org.eclnt.util.valuemgmt.ValueManager;

public class PersonalizedValue {
    private static final String NULLVALUE = "@valueIsSetToNull@";
    String m_id;
    String m_defaultValue;
    String m_value;
    boolean m_valueRead = false;

    public PersonalizedValue(String id, String defaultValue) {
        this.m_id = id;
        this.m_defaultValue = defaultValue;
    }

    public String getValue() {
        this.readValueIfRequired();
        return this.m_value;
    }

    public void setValue(String value) {
        if (ValueManager.checkIfStringsAreEqual(value, this.m_value)) {
            return;
        }
        this.m_value = value;
        this.persistValue();
    }

    public void resetToLastStoredValue() {
        this.m_valueRead = false;
    }

    protected void persistValue() {
        try {
            String path = this.buildStreamStoreKey();
            IStreamStore store = StreamStore.getInstance();
            String value = this.m_value;
            if (value == null) {
                value = NULLVALUE;
            }
            store.writeUTF8(path, this.m_value, false);
        }
        catch (Throwable t) {
            this.m_valueRead = true;
        }
    }

    protected void readValueIfRequired() {
        if (this.m_valueRead) {
            return;
        }
        try {
            String path = this.buildStreamStoreKey();
            IStreamStore store = StreamStore.getInstance();
            if (store.checkIfStreamExists(path, false)) {
                this.m_value = store.readUTF8(path, false);
                if (NULLVALUE.equals(this.m_value)) {
                    this.m_value = null;
                }
            } else {
                this.m_value = this.m_defaultValue;
            }
        }
        catch (Throwable t) {
            this.m_value = this.m_defaultValue;
        }
        this.m_valueRead = true;
    }

    protected String buildStreamStoreKey() {
        String s = "/ccpersonalizedvalue/" + UserAccessMgr.getCurrentUser() + "/" + this.m_id;
        s = ValueManager.encodeIntoValidFileName(s, false);
        return s;
    }
}

