/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Properties;
import org.eclnt.jsfserver.util.SystemXml;
import org.eclnt.util.classresolver.CCClassResolver;
import org.eclnt.util.file.ClassloaderReader;
import org.eclnt.util.log.CLog;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.SecurityConfiguration;
import org.owasp.esapi.reference.DefaultSecurityConfiguration;

public class CCESAPI {
    static boolean s_initialized = false;

    public static boolean isInitialized() {
        return s_initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initESAPI() {
        if (s_initialized) {
            return;
        }
        PrintStream originalOut = System.out;
        PrintStream originalErr = System.err;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            PrintStream temp = new PrintStream(bos);
            System.setOut(temp);
            System.setErr(temp);
            CCESAPI.initResourceDirectory();
            String dummy = ESAPI.encoder().encodeForHTML("");
            CLog.L.log(CLog.LL_INF, "CCESAPI: ESAPI encoder was touched");
            s_initialized = true;
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Problem occurred during ESAPI initilization", t);
        }
        finally {
            System.setOut(originalOut);
            System.setErr(originalErr);
        }
    }

    private static void initResourceDirectory() {
        String rd = SystemXml.getEsapiResourceDirectory();
        if (rd == null) {
            rd = "esapi/v21/";
            try {
                boolean isAvailable = CCClassResolver.checkIfClassIsAvailable("org.owasp.esapi.logging.java.JavaLogFactory");
                if (isAvailable) {
                    rd = "esapi/v22/";
                }
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_INF, "CCESAPI: new version of ESAP including org.owasp.esapi.logging.java.JavaLogFactory was not found");
            }
        }
        try {
            CLog.L.log(CLog.LL_INF, "CCESAPI: properties are read from path: " + rd);
            Properties properties = new Properties();
            String propertiesContentString = new ClassloaderReader(true).readUTF8File(rd + "/ESAPI.properties", true);
            ByteArrayInputStream bis = new ByteArrayInputStream(propertiesContentString.getBytes("UTF-8"));
            properties.load(bis);
            bis.close();
            ESAPI.override((SecurityConfiguration)new DefaultSecurityConfiguration(properties));
            CLog.L.log(CLog.LL_INF, "CCESAPI: configuration was passed successfully");
        }
        catch (Throwable t) {
            throw new Error("Problem setting ESAPI resource directory: " + rd);
        }
    }

    public static String getXMLAttributeAssignment(String attributeName, String value) {
        StringBuffer sb = new StringBuffer();
        if (value != null) {
            sb.append(attributeName);
            sb.append("='");
            sb.append(ESAPI.encoder().encodeForXMLAttribute(value));
            sb.append("' ");
        }
        return sb.toString();
    }

    public static String getXMLAttributeValue(String value) {
        return ESAPI.encoder().encodeForXMLAttribute(value);
    }
}

