/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.eclnt.jsfserver.util.BeanIntrospector;
import org.eclnt.jsfserver.util.ListSorterOneAttribute;
import org.eclnt.util.log.CLog;

public class ListSorterOnePropertyByReflection<CLASS>
extends ListSorterOneAttribute<CLASS> {
    private boolean m_initialized = false;

    public ListSorterOnePropertyByReflection(List<CLASS> list) {
        super(list);
    }

    @Override
    public void sortBy(String attribute) throws ListSorterOneAttribute.SortException {
        if (!this.m_initialized && this.getList().size() != 0) {
            Object o0 = this.m_list.get(0);
            Map<String, BeanIntrospector.PropertyIntrospectionInfo> piis = BeanIntrospector.readProperties(o0.getClass());
            for (String propertyName : piis.keySet()) {
                BeanIntrospector.PropertyIntrospectionInfo pii = piis.get(propertyName);
                GetValueByProperty getter = new GetValueByProperty(pii);
                this.addGetter(propertyName, getter);
            }
            this.m_initialized = true;
        }
        super.sortBy(attribute);
    }

    static class GetValueByProperty<CLASS>
    implements ListSorterOneAttribute.IGetValue<CLASS> {
        BeanIntrospector.PropertyIntrospectionInfo i_pii;

        public GetValueByProperty(BeanIntrospector.PropertyIntrospectionInfo pii) {
            this.i_pii = pii;
        }

        @Override
        public Comparable getValue(CLASS item) {
            try {
                Method getMethod = this.i_pii.getGetter();
                Object result = getMethod.invoke(item, (Object[])new Class[0]);
                return (Comparable)result;
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_INF, "Problem accessing item: " + t);
                return null;
            }
        }
    }
}

