/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclnt.jsfserver.util.CCFilterBase;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.ICCServerConstants;
import org.eclnt.jsfserver.util.security.StringHider;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;

public class SecurityFilterRemoteAddress
extends CCFilterBase
implements Filter,
ICCServerConstants {
    static final String SESSIONATT_REMOTEADDRESS = "ccremoteaddress";
    static Object SYNCHER = new Object();

    @Override
    public void init(FilterConfig arg0) throws ServletException {
    }

    @Override
    public void doFilterExecute(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            HttpSession session = httpRequest.getSession(false);
            this.performCheckRemoteAddress(session, httpRequest);
            chain.doFilter(request, response);
        }
        catch (Throwable t) {
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof ServletException) {
                throw (ServletException)t;
            }
            throw new Error(t);
        }
    }

    private void performCheckRemoteAddress(HttpSession session, HttpServletRequest httpRequest) {
        if (session == null) {
            return;
        }
        if (!HttpSessionAccess.checkIfCurrentClientTypeIsRisc(httpRequest)) {
            return;
        }
        String remoteAddressRequest = this.readRemoteAddressFromRequest(httpRequest);
        String remoteAddressSession = this.readRemoteAddressFromSession(session);
        if (remoteAddressSession == null) {
            this.writeRemoteAddressIntoSession(session, remoteAddressRequest);
        } else if (!this.checkIfRemoteAdressesAreEqual(remoteAddressSession, remoteAddressRequest)) {
            CLog.L.log(CLog.LL_ERR, "Client that sends the request is not the one that created the session. Aborting security check with error. " + httpRequest.getRequestURI());
            CLog.L.log(CLog.LL_ERR, "Session information: " + remoteAddressSession);
            CLog.L.log(CLog.LL_ERR, "Request information: " + remoteAddressRequest);
            try {
                session.invalidate();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new Error("Client that sends the request is not the one that created the session. Request is cancelled: " + httpRequest.getRequestURI());
        }
    }

    protected String readRemoteAddressFromRequest(HttpServletRequest httpRequest) {
        String result1 = httpRequest.getRemoteAddr();
        String result2 = this.readRemoteAddressXFF(httpRequest);
        String result3 = this.readUserAgent(httpRequest);
        return result1 + "/" + result2 + "/" + result3;
    }

    private String readUserAgent(HttpServletRequest httpRequest) {
        return httpRequest.getHeader("user-agent");
    }

    private String readRemoteAddressXFF(HttpServletRequest httpRequest) {
        String param = httpRequest.getHeader("x-forwarded-for");
        if (param != null) {
            int index = param.indexOf(",");
            if (index >= 0) {
                param = param.substring(0, index);
            }
            if ((index = (param = param.trim()).indexOf(":")) >= 0) {
                param = param.substring(0, index);
            }
            param = param.trim();
        }
        return param;
    }

    private String readRemoteAddressFromSession(HttpSession session) {
        if (session == null) {
            return null;
        }
        StringHider hider = (StringHider)session.getAttribute(SESSIONATT_REMOTEADDRESS);
        if (hider == null) {
            return null;
        }
        return hider.getValue();
    }

    private void writeRemoteAddressIntoSession(HttpSession session, String remoteAddress) {
        if (session == null) {
            return;
        }
        StringHider sh = new StringHider(remoteAddress);
        session.setAttribute(SESSIONATT_REMOTEADDRESS, (Object)sh);
    }

    public void destroy() {
    }

    protected boolean checkIfRemoteAdressesAreEqual(String remoteAddressSession, String remoteAddressRequest) {
        boolean result = ValueManager.checkIfStringsAreEqual(remoteAddressSession, remoteAddressRequest);
        if (result) {
            return true;
        }
        return remoteAddressSession.startsWith("127.0.0.1") && remoteAddressRequest.startsWith("0:0:0:0:0:0:0:1");
    }
}

