/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util.pageparsing;

import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.eclnt.jsfserver.util.pageparsing.PageParser;
import org.eclnt.jsfserver.util.pageparsing.ParsedNodeBase;
import org.eclnt.util.log.CLog;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PageSAXParserHandler<PN extends ParsedNodeBase>
extends DefaultHandler {
    private String m_currentPageInfo;
    private boolean m_excludeOutestRow;
    Stack<PN> m_nodeStack = new Stack();
    int m_initialSize = 0;
    int m_rowExcludedCounter = 0;
    Set<String> m_containedIdsDuringParsing = new HashSet<String>();

    public PageSAXParserHandler(PN rootNode, boolean excludeOutestRow, String currentPageInfo) {
        this.m_currentPageInfo = currentPageInfo;
        this.m_nodeStack.push(rootNode);
        this.m_initialSize = this.m_nodeStack.size();
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (name.equals("dummynode")) {
            return;
        }
        if (name.startsWith("f:")) {
            return;
        }
        if (name.startsWith("h:")) {
            return;
        }
        if (name.equals("t:page")) {
            return;
        }
        if (name.equals("t:pageaddons")) {
            return;
        }
        if (name.equals("t:htpageaddons1")) {
            return;
        }
        if (name.equals("t:htpageaddons2")) {
            return;
        }
        if (name.equals("t:pagebeandefinition")) {
            return;
        }
        if (name.equals("t:layoutdefinition")) {
            return;
        }
        if (this.m_excludeOutestRow && name.equals("t:row") && this.m_nodeStack.size() == this.m_initialSize) {
            ++this.m_rowExcludedCounter;
            if (this.m_rowExcludedCounter == 1) {
                return;
            }
            throw new Error("Within a t:pagebeaninclude only exactly one t:row element is allowed as top element.\nIn your case there is more than one t:row element within the page definition.\nThe current page info is: " + this.m_currentPageInfo);
        }
        if (this.m_excludeOutestRow && name.startsWith("t:row") && this.m_nodeStack.size() == this.m_initialSize) {
            throw new Error("Within a t:pagebeaninclude only exactly one t:row element is allowed as top element.\nIn your case the following element was found: " + name + "\nThe current page info is: " + this.m_currentPageInfo);
        }
        String id = attributes.getValue(PageParser.ATT_ID);
        if (id != null) {
            if (this.m_containedIdsDuringParsing.contains(id)) {
                CLog.L.log(CLog.LL_ERR, "Error in layout definition: duplicate definition of id: " + id + ", layout: " + this.m_currentPageInfo);
            }
            this.m_containedIdsDuringParsing.add(id);
        }
        try {
            ParsedNodeBase currentNode = (ParsedNodeBase)this.m_nodeStack.lastElement();
            ParsedNodeBase pn = currentNode.createSubNode();
            pn.setName(name);
            pn.passAttributesFromSAXParser(attributes);
            this.updateNodeAfterCreation(pn);
            this.m_nodeStack.push(pn);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "", t);
        }
    }

    protected void updateNodeAfterCreation(PN pn) {
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (name.equals("dummynode")) {
            return;
        }
        if (name.startsWith("f:")) {
            return;
        }
        if (name.startsWith("h:")) {
            return;
        }
        if (name.equals("t:page")) {
            return;
        }
        if (name.equals("t:pageaddons")) {
            return;
        }
        if (name.equals("t:htpageaddons1")) {
            return;
        }
        if (name.equals("t:htpageaddons2")) {
            return;
        }
        if (name.equals("t:pagebeandefinition")) {
            return;
        }
        if (name.equals("t:layoutdefinition")) {
            return;
        }
        if (this.m_excludeOutestRow && name.equals("t:row") && this.m_nodeStack.size() == this.m_initialSize) {
            return;
        }
        this.m_nodeStack.pop();
    }

    public void clearInterimParsingInfo() {
        this.m_containedIdsDuringParsing = null;
    }
}

