/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.util.chart.util;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.eclnt.util.log.CLog;
import org.jfree.chart.JFreeChart;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class ChartSVGExporter {
    public static String generateSVG(JFreeChart chart, int width, int height) {
        try {
            DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
            Document document = domImpl.createDocument(null, "svg", null);
            SVGGraphics2D svgGenerator = new SVGGraphics2D(document);
            chart.draw((Graphics2D)svgGenerator, (Rectangle2D)new Rectangle2D.Double(0.0, 0.0, width, height));
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            OutputStreamWriter outsvg = new OutputStreamWriter((OutputStream)bos, "UTF-8");
            svgGenerator.stream((Writer)outsvg, true);
            String result = new String(bos.toByteArray(), "UTF-8");
            return result;
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Could not transfer chart info SVG", t);
            return null;
        }
    }
}

