/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.util.image;

import java.util.List;
import org.eclnt.ccee.simplexml.SimpleXMLElement;
import org.eclnt.util.image.ISVGImageUpdate;

public class SVGImageUpdateLibStreamline
implements ISVGImageUpdate {
    @Override
    public ISVGImageUpdate.SVGImageUpdateResult updateSVG(SimpleXMLElement top, String backgroundColor, String color, int width, int height) {
        if (top != null) {
            String fill = top.getValue("fill");
            if (top.getSubElements().size() > 0 && ("none".equals(fill) || null == fill)) {
                Object gElement;
                boolean updateWasDone = false;
                List<SimpleXMLElement> pathElements = top.getSubElements("path");
                if (pathElements.size() == 0 && (gElement = top.getSubElement("g")) != null) {
                    pathElements = ((SimpleXMLElement)gElement).getSubElements("path");
                }
                if (pathElements.size() > 0) {
                    for (SimpleXMLElement pathElement : pathElements) {
                        String pathFill;
                        String pathStroke = pathElement.getValue("stroke");
                        if ("#000000".equals(pathStroke)) {
                            this.updateSVGExecuteLINE(top, pathElement, backgroundColor, color, width, height);
                            updateWasDone = true;
                        }
                        if (!"#000000".equals(pathFill = pathElement.getValue("fill"))) continue;
                        this.updateSVGExecuteSOLID(top, pathElement, backgroundColor, color, width, height);
                        updateWasDone = true;
                    }
                    if (updateWasDone) {
                        String svg = top.toXML();
                        return new ISVGImageUpdate.SVGImageUpdateResult(true, svg);
                    }
                }
            }
        }
        return new ISVGImageUpdate.SVGImageUpdateResult(false, null);
    }

    private void updateSVGExecuteLINE(SimpleXMLElement top, SimpleXMLElement pathElement, String backgroundColor, String color, int width, int height) {
        if (color != null) {
            pathElement.setValue("stroke", color);
        }
        if (width > 0) {
            top.setValue("width", "" + width);
        }
        if (height > 0) {
            top.setValue("height", "" + width);
        }
    }

    private void updateSVGExecuteSOLID(SimpleXMLElement top, SimpleXMLElement pathElement, String backgroundColor, String color, int width, int height) {
        if (color != null) {
            pathElement.setValue("fill", color);
        }
        if (width > 0) {
            top.setValue("width", "" + width);
        }
        if (height > 0) {
            top.setValue("height", "" + width);
        }
    }
}

