/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.util.image;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import javax.imageio.ImageIO;
import org.eclnt.util.file.FileManager;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;

public class SignatureImageCreator {
    public static void main(String[] args) {
        byte[] ib = SignatureImageCreator.createPNGFromSignature("20;5;20;6;19;6;19;7;18;8;18;9;17;10;17;11;16;12;16;13;15;15;15;16;14;17;14;19;13;20;13;21;13;22;13;23;13;22;14;22;15;20;16;19;16;17;17;14;17;12;18;10;19;8;20;7;20;6;21;5;22;4;23;4;24;4;25;4;26;4;27;5;28;6;28;7;27;7;25;8;24;9;22;9;21;10;20;10;19;11;18;12;18;13;19;14;19;15;21;15;22;16;23;17;24;18;25;18;25;19;25;20;24;20;24;21;22;21;21;21;19;21;17;21;15;21;14;22;13;22;12;22;11;21;11;19;11;18;11;17;-20;-20;27;21;28;21;29;21;30;21;32;21;33;20;35;19;37;18;38;17;39;15;41;13;41;11;42;9;42;7;42;5;42;4;41;2;41;1;40;1;39;0;38;0;36;0;35;1;34;2;33;4;33;5;33;7;33;8;33;10;34;11;35;12;37;14;40;14;42;15;44;16;46;16;48;16;49;16;49;15;50;15;49;15;48;15;47;16;46;16;46;17;46;18;45;19;45;20;45;21;45;22;46;22;46;23;47;23;48;23;48;22;49;22;50;22;51;21;52;21;53;20;54;19;55;18;56;19;56;20;56;21;-20;-20;59;13;59;14;-20;-20;64;21;64;20;65;18;69;15;71;14;73;12;75;10;76;8;77;6;77;5;77;4;77;3;76;2;75;2;75;1;73;1;72;2;71;3;70;5;69;7;68;9;68;10;68;13;68;15;69;17;69;18;71;20;72;21;74;21;76;22;79;22;81;22;83;21;85;20;87;19;88;17;89;16;89;14;89;13;88;11;87;10;86;10;86;9;85;9;84;10;83;10;83;11;82;13;82;14;82;15;82;16;83;17;84;18;85;18;87;18;88;18;89;17;90;17;91;16;91;15;90;16;90;17;90;18;90;19;90;20;91;20;92;21;94;22;96;22;97;22;99;22;100;21;101;21;101;20;101;19;102;19;102;18;103;18;104;18;106;18;107;18;109;18;111;18;113;18;115;18;116;18;117;18;118;18;119;18;-20;-20;-100;-100");
        FileManager.writeFile("c:/temp/signature.png", ib, true);
        System.out.println("OK");
    }

    public static byte[] createPNGFromSignature(String coordinatesCSV) {
        try {
            if (coordinatesCSV == null || coordinatesCSV.length() == 0) {
                return null;
            }
            int[] coordinates = ValueManager.decodeStraightIntCSV(coordinatesCSV);
            if (coordinates.length == 0) {
                return null;
            }
            int maxX = 0;
            int maxY = 0;
            for (int i = 0; i < coordinates.length; i += 2) {
                int x = coordinates[i];
                int y = coordinates[i + 1];
                if (maxX < x) {
                    maxX = x;
                }
                if (maxY >= y) continue;
                maxY = y;
            }
            BufferedImage bim = new BufferedImage(maxX, maxY, 1);
            Graphics2D g = (Graphics2D)bim.getGraphics();
            g.setColor(Color.white);
            g.fillRect(0, 0, maxX, maxY);
            g.setColor(Color.black);
            g.setStroke(new BasicStroke(1.0f));
            int lastX = -1;
            int lastY = -1;
            for (int i = 0; i < coordinates.length; i += 2) {
                int x = coordinates[i];
                int y = coordinates[i + 1];
                if (x < 0 || y < 0) {
                    lastX = -1;
                    lastY = -1;
                    continue;
                }
                if (lastX < 0) {
                    lastX = x;
                }
                if (lastY < 0) {
                    lastY = y;
                }
                g.drawLine(lastX, lastY, x, y);
                lastX = x;
                lastY = y;
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bim, "png", bos);
            return bos.toByteArray();
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_WAR, "Problem when creating image from signature", t);
            return null;
        }
    }
}

