/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.util.log;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclnt.jsfserver.util.CCESAPI;
import org.owasp.esapi.ESAPI;

public class CLogLogger
extends Logger {
    Logger m_redirectLogger = null;
    boolean m_redirectLoggerWithPlainText = false;
    boolean m_plainText = false;

    public CLogLogger(String name, String resourceBundleName) {
        super(name, resourceBundleName);
    }

    public CLogLogger(Logger redirectLogger, boolean plainText) {
        super(redirectLogger.getName() + "_secure", redirectLogger.getResourceBundleName());
        this.m_redirectLogger = redirectLogger;
        this.m_redirectLoggerWithPlainText = plainText;
    }

    @Override
    public void log(Level level, String msg) {
        String clean;
        if (!this.isLoggable(level)) {
            return;
        }
        if (msg == null) {
            return;
        }
        boolean cleanIsPlainText = true;
        if (!this.m_plainText && CCESAPI.isInitialized()) {
            clean = ESAPI.encoder().encodeForHTML(msg);
            cleanIsPlainText = false;
        } else {
            clean = msg;
        }
        if (this.m_redirectLogger == null) {
            super.log(level, clean);
        } else {
            if (!cleanIsPlainText && this.m_redirectLoggerWithPlainText) {
                clean = msg;
            }
            this.m_redirectLogger.log(level, clean);
        }
    }

    @Override
    public void log(Level level, String msg, Throwable thrown) {
        if (!this.isLoggable(level)) {
            return;
        }
        if (msg == null) {
            return;
        }
        String clean = CCESAPI.isInitialized() ? ESAPI.encoder().encodeForHTML(msg) : msg;
        if (this.m_redirectLogger == null) {
            super.log(level, clean, thrown);
        } else {
            this.m_redirectLogger.log(level, clean, thrown);
        }
    }

    public void setPlainText(boolean plainText) {
        this.m_plainText = plainText;
    }

    public boolean getPlainText() {
        return this.m_plainText;
    }
}

