/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.util.valuemgmt;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.eclnt.jsfserver.elements.ComponentDump;
import org.eclnt.util.log.CLog;
import org.eclnt.util.log.SysOutMgr;
import org.eclnt.util.valuemgmt.ValueManager;

public class XMLWriter {
    private static final boolean USE_COMPONENTDUMP = true;
    private static List<char[]> ESC_TO31 = new ArrayList<char[]>();
    private static final char[] ESC_GREATER_THAN = new char[]{'&', 'g', 't', ';'};
    private static final char[] ESC_LESS_THAN = new char[]{'&', 'l', 't', ';'};
    private static final char[] ESC_AMPERSAND = new char[]{'&', 'a', 'm', 'p', ';'};
    private static final char[] ESC_APOSTROPHE = new char[]{'&', '#', '3', '9', ';'};
    private static final char[] ESC_QUOTE = new char[]{'&', '#', '3', '4', ';'};
    private static final char[] ESC_FORMFEED = new char[]{'&', '#', '1', '2', ';'};
    private static final char[] ESC_LINEFEED = new char[]{'&', '#', '1', '0', ';'};
    private static final char[] ESC_CARRIAGERETURN = new char[]{'&', '#', '1', '3', ';'};
    private static final char[] ESC_TAB = new char[]{'&', '#', '0', '9', ';'};
    private static final char[] ESC_BACKSLASH = new char[]{'&', '#', '9', '2', ';'};
    private static final String SESC_GREATER_THAN = "&gt;";
    private static final String SESC_LESS_THAN = "&lt;";
    private static final String SESC_AMPERSAND = "&amp;";
    private static final String SESC_APOSTROPHE = "&#39;";
    private static final String SESC_QUOTE = "&#34;";
    private static final String SESC_APOSTROPHE2 = "&apos;";
    private static final String SESC_QUOTE2 = "&quot;";
    private static final String SESC_BACKSLASH = "&#92;";
    private static final char[] ESC_NBSP = new char[]{'&', 'n', 'b', 's', 'p', ';'};

    public static void writer_startElement(Writer writer, ComponentDump cd, String name) throws IOException {
        if (cd != null) {
            cd.addNewXMLNode(name);
            return;
        }
        if (SysOutMgr.ON) {
            SysOutMgr.print("<" + name + " ");
        }
        writer.write("<");
        XMLWriter.writeStringToWriter(writer, name);
        writer.write(" ");
    }

    public static void writer_startElement(Writer writer, ComponentDump cd, String name, boolean isNewNode) throws IOException {
        if (cd != null) {
            cd.addNewXMLNode(name, isNewNode);
            return;
        }
        writer.write("<" + name + " ");
        if (SysOutMgr.ON) {
            SysOutMgr.print("<" + name + " ");
        }
    }

    public static void writer_closeStartElement(Writer writer, ComponentDump cd) throws IOException {
        if (cd != null) {
            return;
        }
        writer.write(">\n");
        if (SysOutMgr.ON) {
            SysOutMgr.print(">\n");
        }
    }

    public static void writer_closeStartElementWithoutLineFeed(Writer writer, ComponentDump cd) throws IOException {
        if (cd != null) {
            return;
        }
        writer.write(">");
        if (SysOutMgr.ON) {
            SysOutMgr.print(">");
        }
    }

    public static void writer_closeStartAndEndElement(Writer writer, ComponentDump cd) throws IOException {
        if (cd != null) {
            cd.closeXMLNode();
            return;
        }
        writer.write("/>\n");
        if (SysOutMgr.ON) {
            SysOutMgr.print("/>\n");
        }
    }

    private static boolean checkIfContainsSpecialXMLCharacter(String sValue) {
        for (int i = 0; i < sValue.length(); ++i) {
            char c;
            char ic = c = sValue.charAt(i);
            if (c == '&' || c == '<' || c == '>' || c == '\'' || c == '\"' || c == '\\' || ic >= '\u0000' && ic < ' ') {
                return true;
            }
            if (!(ic >= '\u0000' && ic <= '\b' || ic >= '\u000b' && ic <= '\f' || ic >= '\u000e' && ic <= '\u001f' || ic >= '\u007f' && ic <= '\u0084') && (ic < '\u0086' || ic > '\u009f')) continue;
            return true;
        }
        return false;
    }

    public static void writer_writeAttribute(Writer writer, ComponentDump cd, String name, Object value) throws IOException {
        if (value == null) {
            return;
        }
        if (cd != null) {
            cd.addNewXMLNodeAttribute(name, (String)value);
            return;
        }
        XMLWriter.writeStringToWriter(writer, name);
        writer.write(61);
        writer.write(34);
        XMLWriter.writeStringToWriter(writer, (String)value);
        writer.write(34);
        writer.write(32);
    }

    private static void writeStringToWriter(Writer writer, String value) throws IOException {
        char[] chars = value.toCharArray();
        block8: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            char ic = c;
            if (ic >= '\u0000' && ic <= '\b' || ic >= '\u000b' && ic <= '\f' || ic >= '\u000e' && ic <= '\u001f' || ic >= '\u007f' && ic <= '\u0084' || ic >= '\u0086' && ic <= '\u009f') {
                CLog.L.log(CLog.LL_INF, ValueManager.truncateString("Character was wiped out from XML stream: " + ic + ", value: " + value, 1000));
                continue;
            }
            switch (c) {
                case '&': {
                    writer.write(ESC_AMPERSAND);
                    continue block8;
                }
                case '<': {
                    writer.write(ESC_LESS_THAN);
                    continue block8;
                }
                case '>': {
                    writer.write(ESC_GREATER_THAN);
                    continue block8;
                }
                case '\'': {
                    writer.write(ESC_APOSTROPHE);
                    continue block8;
                }
                case '\"': {
                    writer.write(ESC_QUOTE);
                    continue block8;
                }
                case '\\': {
                    writer.write(ESC_BACKSLASH);
                    continue block8;
                }
                default: {
                    if (c >= ' ') {
                        writer.write(c);
                        continue block8;
                    }
                    writer.write(ESC_TO31.get(c));
                }
            }
        }
    }

    public static void writer_writeAttributeWithFormattedValue(Writer writer, ComponentDump cd, String name, Object value) throws IOException {
        if (value == null) {
            return;
        }
        if (cd != null) {
            throw new Error("SHOULD NEVER HAPPEN!");
        }
        writer.write(name);
        writer.write(61);
        writer.write(34);
        writer.write((String)value);
        writer.write(34);
        writer.write(32);
    }

    public static void writer_writeText(Writer writer, ComponentDump cd, String value) throws IOException {
        if (value == null) {
            return;
        }
        if (cd != null) {
            throw new Error("SHOULD NEVER HAPPEN");
        }
        XMLWriter.writeStringToWriter(writer, value);
    }

    public static void writer_writeFormattedText(Writer writer, ComponentDump cd, String value) throws IOException {
        if (value == null) {
            return;
        }
        if (cd != null) {
            throw new Error("SHOULD NEVER HAPPEN");
        }
        char[] chars = value.toCharArray();
        writer.write(chars);
        if (SysOutMgr.ON) {
            SysOutMgr.print(chars);
        }
    }

    public static void writer_writeChangedMarker(Writer writer, ComponentDump cd) {
        if (cd != null) {
            cd.writeXMLNodeChangedMarker();
        }
    }

    public static void writer_writeChangedMarkerForChildren(Writer writer, ComponentDump cd) {
        if (cd != null) {
            cd.writeSubXMLNodesChangedMarker();
        }
    }

    public static void writer_endElement(Writer writer, ComponentDump cd, String name) throws IOException {
        if (cd != null) {
            cd.closeXMLNode();
            return;
        }
        writer.write("</");
        XMLWriter.writeStringToWriter(writer, name);
        writer.write(">\n");
        if (SysOutMgr.ON) {
            SysOutMgr.print("</" + name + ">\n");
        }
    }

    public static void writer_writePreparedXML(Writer writer, ComponentDump cd, String xml) throws IOException {
        if (cd != null) {
            cd.addPreparedXML(xml);
            return;
        }
        writer.write(xml);
        if (SysOutMgr.ON) {
            SysOutMgr.print(xml);
        }
    }

    private static int writeAmpersand(Writer writer, String value, int ampersandPosition) throws IOException {
        try {
            int nextSemicolon = value.indexOf(59, ampersandPosition + 2);
            if (nextSemicolon > 0) {
                char cp1 = value.charAt(ampersandPosition + 1);
                if (cp1 == '#') {
                    String between = value.substring(ampersandPosition + 2, nextSemicolon);
                    int betweenInt = new Integer(between);
                    if (betweenInt < 32) {
                        return 0;
                    }
                    char c = (char)betweenInt;
                    if (c == '>') {
                        writer.write(SESC_GREATER_THAN);
                    } else if (c == '<') {
                        writer.write(SESC_LESS_THAN);
                    } else if (c == '&') {
                        writer.write(SESC_AMPERSAND);
                    } else if (c == '\"') {
                        writer.write(SESC_QUOTE);
                    } else if (c == '\'') {
                        writer.write(SESC_APOSTROPHE);
                    } else if (c == '\\') {
                        writer.write(SESC_BACKSLASH);
                    } else {
                        writer.write(c);
                    }
                    return nextSemicolon - ampersandPosition;
                }
                if (value.indexOf(SESC_LESS_THAN, ampersandPosition) == ampersandPosition) {
                    writer.write(38);
                    return 0;
                }
                if (value.indexOf(SESC_GREATER_THAN, ampersandPosition) == ampersandPosition) {
                    writer.write(38);
                    return 0;
                }
                if (value.indexOf(SESC_AMPERSAND, ampersandPosition) == ampersandPosition) {
                    writer.write(38);
                    return 0;
                }
                if (value.indexOf(SESC_APOSTROPHE, ampersandPosition) == ampersandPosition) {
                    writer.write(38);
                    return 0;
                }
                if (value.indexOf(SESC_QUOTE, ampersandPosition) == ampersandPosition) {
                    writer.write(38);
                    return 0;
                }
                if (value.indexOf(SESC_APOSTROPHE2, ampersandPosition) == ampersandPosition) {
                    writer.write(38);
                    return 0;
                }
                if (value.indexOf(SESC_QUOTE2, ampersandPosition) == ampersandPosition) {
                    writer.write(38);
                    return 0;
                }
                if (value.indexOf(SESC_BACKSLASH, ampersandPosition) == ampersandPosition) {
                    writer.write(38);
                    return 0;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        writer.write(ESC_AMPERSAND);
        return 0;
    }

    static {
        for (int i = 0; i < 32; ++i) {
            char[] cs = new char[]{'&', '#', (i / 10 + "").charAt(0), (i % 10 + "").charAt(0), ';'};
            ESC_TO31.add(cs);
        }
    }
}

