/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.workplace;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlRootElement;
import org.eclnt.jsfserver.messages.CrossDialogMessage;
import org.eclnt.jsfserver.messages.DialogMessageBus;
import org.eclnt.jsfserver.util.SystemXml;
import org.eclnt.util.log.CLog;
import org.eclnt.util.token.Token;
import org.eclnt.util.token.TokenMgr;
import org.eclnt.util.valuemgmt.JAXBManager;
import org.eclnt.workplace.IWorkpageDispatcher;
import org.eclnt.workplace.IWorkpageStarter;
import org.eclnt.workplace.MultiWorkplaceTokenContent;
import org.eclnt.workplace.WorkpageContainerMultiWorkplaceManager;
import org.eclnt.workplace.WorkpageStartInfo;
import org.eclnt.workplace.WorkpageStarterFactory;
import org.eclnt.workplace.eximport.WorkpageStartInfoExtensionAdapter;

public class MultiWorkplaceConnector {
    static final String MESSAGETYPE_STARTWORKPAGEINWORKPLACE = "CCSTARTWORKPAGE";
    public static final String QUERYPARAM_TOKEN = "ccmwpc_token";
    public static final String CCSTARTER = "ccstarter";
    static MultiWorkplaceConnector s_instance = new MultiWorkplaceConnector();
    Map<String, IWorkpageDispatcher> m_allDispatchers = new Hashtable<String, IWorkpageDispatcher>();
    String m_defaultWorkplaceURL = SystemXml.getWorkplaceMultiScreenDefaultWorkplaceUrl();
    String m_defaultWindowFeatures = SystemXml.getWorkplaceMultiScreenDefaultWindowFeatures();

    private MultiWorkplaceConnector() {
    }

    public static MultiWorkplaceConnector instance() {
        return s_instance;
    }

    public String getDefaultWorkplaceURL() {
        return this.m_defaultWorkplaceURL;
    }

    public String getDefaultWindowFeatures() {
        return this.m_defaultWindowFeatures;
    }

    public void startWorkplace(IWorkpageDispatcher currentDispatcher, String newWorkplaceName, WorkplaceConfiguration workplaceConfiguration, WorkpageStartInfo wpsi) throws WorkplaceWithNameAlreadyExistsException {
        if (workplaceConfiguration == null) {
            workplaceConfiguration = new WorkplaceConfiguration();
        }
        wpsi = WorkpageStartInfoExtensionAdapter.instance().transferExtensionIntoDefault(wpsi);
        IWorkpageDispatcher secondWorkplace = this.getDependentWorkplace(currentDispatcher, newWorkplaceName);
        if (secondWorkplace == null) {
            String url2Start = this.createStartWorkplaceURL(currentDispatcher, newWorkplaceName, workplaceConfiguration.getWorkplaceURL(), wpsi);
            WorkpageContainerMultiWorkplaceManager mwm = currentDispatcher.getWorkpageContainer().getMultiWorkplaceManager();
            String features = workplaceConfiguration.getWindowFeatures();
            if (features == null) {
                features = this.m_defaultWindowFeatures;
            }
            mwm.startURL(url2Start, features);
            mwm.activate();
        } else {
            this.startWorkpage(currentDispatcher, newWorkplaceName, workplaceConfiguration, wpsi, false);
        }
    }

    public String createStartWorkplaceURL(IWorkpageDispatcher currentDispatcher, String newWorkplaceName, String startWorkplaceBaseURL, WorkpageStartInfo wpsi) throws WorkplaceWithNameAlreadyExistsException {
        wpsi = WorkpageStartInfoExtensionAdapter.instance().transferExtensionIntoDefault(wpsi);
        if (startWorkplaceBaseURL == null) {
            startWorkplaceBaseURL = this.m_defaultWorkplaceURL;
        }
        currentDispatcher = (IWorkpageDispatcher)currentDispatcher.getTopOwner();
        if (CCSTARTER.equals(newWorkplaceName)) {
            throw new Error("Name \"ccstarter\" is reserved for internal processing");
        }
        if (this.checkIfAlreadyStarted(currentDispatcher, newWorkplaceName)) {
            throw new WorkplaceWithNameAlreadyExistsException();
        }
        MultiWorkplaceTokenContent tc = new MultiWorkplaceTokenContent();
        tc.setFromId(currentDispatcher.getWorkpageContainer().getUniqueId());
        tc.setToName(newWorkplaceName);
        tc.setWpsi(wpsi);
        String valuesXML = JAXBManager.marshal(tc);
        Token token = TokenMgr.instance().createToken(valuesXML);
        startWorkplaceBaseURL = startWorkplaceBaseURL.contains("?") ? startWorkplaceBaseURL + "&" : startWorkplaceBaseURL + "?";
        startWorkplaceBaseURL = startWorkplaceBaseURL + "ccmwpc_token=" + token.getUuid();
        return startWorkplaceBaseURL;
    }

    public IWorkpageDispatcher getDependentWorkplace(IWorkpageDispatcher startingDispatcher, String workplaceName) {
        startingDispatcher = (IWorkpageDispatcher)startingDispatcher.getTopOwner();
        return startingDispatcher.getWorkpageContainer().getMultiWorkplaceManager().getConnectedWorkplace(workplaceName);
    }

    public void startWorkpage(IWorkpageDispatcher fromWorkplace, String targetWorkplaceName, WorkplaceConfiguration workplaceConfiguration, WorkpageStartInfo wpsi, boolean openWorkplaceInstanceIfNotExists) {
        if (workplaceConfiguration == null) {
            workplaceConfiguration = new WorkplaceConfiguration();
        }
        boolean targetExists = true;
        fromWorkplace = (IWorkpageDispatcher)fromWorkplace.getTopOwner();
        IWorkpageDispatcher secondWorkplace = MultiWorkplaceConnector.instance().getDependentWorkplace(fromWorkplace, targetWorkplaceName);
        if (secondWorkplace == null) {
            targetExists = false;
            secondWorkplace = fromWorkplace;
        }
        if (targetExists) {
            wpsi = WorkpageStartInfoExtensionAdapter.instance().transferExtensionIntoDefault(wpsi);
            MessageContentStartWorkpageInWorkplace message = new MessageContentStartWorkpageInWorkplace("sender", targetWorkplaceName, wpsi);
            DialogMessageBus.instance().publishMessageToAllClientDialogs(new CrossDialogMessage(MESSAGETYPE_STARTWORKPAGEINWORKPLACE, message.toXML()));
        } else if (!targetExists && !openWorkplaceInstanceIfNotExists) {
            IWorkpageStarter wps = WorkpageStarterFactory.getWorkpageStarter();
            wps.startWorkpage(secondWorkplace, secondWorkplace.getWorkpageContainer(), wpsi);
        } else {
            try {
                if (this.m_defaultWorkplaceURL == null) {
                    throw new Error("Default workplace URL is not defined.");
                }
                wpsi = WorkpageStartInfoExtensionAdapter.instance().transferExtensionIntoDefault(wpsi);
                this.startWorkplace(fromWorkplace, targetWorkplaceName, workplaceConfiguration, wpsi);
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_INF, "Problem starting workplace instance: " + t, t);
            }
        }
    }

    public boolean checkIfAlreadyStarted(IWorkpageDispatcher currentDispatcher, String newWorkplaceName) {
        IWorkpageDispatcher startedWorkplace = this.mwm(currentDispatcher).getConnectedWorkplace(newWorkplaceName);
        return startedWorkplace != null;
    }

    void registerWorkplace(IWorkpageDispatcher dispatcher) {
        dispatcher = (IWorkpageDispatcher)dispatcher.getTopOwner();
        this.m_allDispatchers.put(dispatcher.getWorkpageContainer().getUniqueId(), dispatcher);
    }

    void unregisterWorkplace(IWorkpageDispatcher dispatcher) {
        if (dispatcher == null) {
            return;
        }
        if ((dispatcher = (IWorkpageDispatcher)dispatcher.getTopOwner()).getWorkpageContainer() != null) {
            this.m_allDispatchers.remove(dispatcher.getWorkpageContainer().getUniqueId());
        } else {
            CLog.L.log(CLog.LL_ERR, "Problem removing dispatcher from all-dispatchers collection!");
        }
    }

    void registerDependentWorkplace(IWorkpageDispatcher dependentDispatcher, String fromId, String newWorkplaceName) {
        try {
            dependentDispatcher = (IWorkpageDispatcher)dependentDispatcher.getTopOwner();
            IWorkpageDispatcher startingDispatcher = this.m_allDispatchers.get(fromId);
            this.mwm(startingDispatcher).addConnectedWorkplace(dependentDispatcher, newWorkplaceName);
            this.mwm(dependentDispatcher).addConnectedWorkplace(startingDispatcher, CCSTARTER);
            this.mwm(dependentDispatcher).activate();
            this.mwm(startingDispatcher).activate();
        }
        catch (Throwable t) {
            throw new Error("Problem when registereing dependent workplace: " + fromId + ", " + newWorkplaceName, t);
        }
    }

    void unregisterDependentWorkplace(IWorkpageDispatcher dependentDispatcher) {
        if (!this.mwm(dependentDispatcher = (IWorkpageDispatcher)dependentDispatcher.getTopOwner()).getActive()) {
            return;
        }
        IWorkpageDispatcher startingDispatcher = this.mwm(dependentDispatcher).getConnectedWorkplace(CCSTARTER);
        if (startingDispatcher != null) {
            this.mwm(startingDispatcher).removeConnectedWorkplace(dependentDispatcher);
            if (this.mwm(startingDispatcher).getConnectedWorkplaces().size() == 0) {
                this.mwm(startingDispatcher).deactivate();
            }
        }
        this.mwm(dependentDispatcher).removeConnectedWorkplace(CCSTARTER);
        if (this.mwm(dependentDispatcher).getConnectedWorkplaces().size() == 0) {
            this.mwm(dependentDispatcher).deactivate();
        }
    }

    public Set<IWorkpageDispatcher> getConnectedWorkplaces(IWorkpageDispatcher owningDispatcher) {
        owningDispatcher = (IWorkpageDispatcher)owningDispatcher.getTopOwner();
        HashSet<IWorkpageDispatcher> result = new HashSet<IWorkpageDispatcher>(this.mwm(owningDispatcher).getConnectedWorkplaces().values());
        return result;
    }

    private WorkpageContainerMultiWorkplaceManager mwm(IWorkpageDispatcher d) {
        return d.getWorkpageContainer().getMultiWorkplaceManager();
    }

    @XmlRootElement
    public static class MessageContentStartWorkpageInWorkplace {
        String i_senderWorkplaceName;
        String i_targetWorkplaceName;
        WorkpageStartInfo i_wpsi;

        public MessageContentStartWorkpageInWorkplace() {
        }

        public MessageContentStartWorkpageInWorkplace(String senderWorkplaceName, String targetWorkplaceName, WorkpageStartInfo wpsi) {
            this.i_senderWorkplaceName = senderWorkplaceName;
            this.i_targetWorkplaceName = targetWorkplaceName;
            this.i_wpsi = wpsi;
        }

        public String getSenderWorkplaceName() {
            return this.i_senderWorkplaceName;
        }

        public void setSenderWorkplaceName(String senderWorkplaceName) {
            this.i_senderWorkplaceName = senderWorkplaceName;
        }

        public String getTargetWorkplaceName() {
            return this.i_targetWorkplaceName;
        }

        public void setTargetWorkplaceName(String targetWorkplaceName) {
            this.i_targetWorkplaceName = targetWorkplaceName;
        }

        public WorkpageStartInfo getWpsi() {
            return this.i_wpsi;
        }

        public void setWpsi(WorkpageStartInfo wpsi) {
            this.i_wpsi = wpsi;
        }

        public String toXML() {
            return JAXBManager.marshal(this);
        }

        public static MessageContentStartWorkpageInWorkplace fromXML(String xml) {
            return (MessageContentStartWorkpageInWorkplace)JAXBManager.unmarshal(xml, MessageContentStartWorkpageInWorkplace.class);
        }
    }

    public static class WorkplaceConfiguration {
        String i_workplaceURL;
        String i_windowFeatures;

        public String getWorkplaceURL() {
            return this.i_workplaceURL;
        }

        public void setWorkplaceURL(String workplaceURL) {
            this.i_workplaceURL = workplaceURL;
        }

        public String getWindowFeatures() {
            return this.i_windowFeatures;
        }

        public void setWindowFeatures(String windowFeatures) {
            this.i_windowFeatures = windowFeatures;
        }
    }

    public class WorkplaceWithNameAlreadyExistsException
    extends Exception {
    }
}

