/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.workplace;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.faces.event.ActionEvent;
import org.eclnt.jsfserver.configuration.CCConfigurationObjectLoader;
import org.eclnt.jsfserver.defaultscreens.ModelessPopup;
import org.eclnt.jsfserver.defaultscreens.OKPopup;
import org.eclnt.jsfserver.defaultscreens.Statusbar;
import org.eclnt.jsfserver.elements.BaseActionEvent;
import org.eclnt.jsfserver.elements.componentnodes.ICONNode;
import org.eclnt.jsfserver.elements.componentnodes.MENUITEMNode;
import org.eclnt.jsfserver.elements.componentnodes.MENUSEPARATORNode;
import org.eclnt.jsfserver.elements.componentnodes.PANENode;
import org.eclnt.jsfserver.elements.componentnodes.ROWINCLUDENode;
import org.eclnt.jsfserver.elements.componentnodes.ROWNode;
import org.eclnt.jsfserver.elements.componentnodes.ROWTITLEBARNode;
import org.eclnt.jsfserver.elements.events.BaseActionEventDrop;
import org.eclnt.jsfserver.elements.events.BaseActionEventInvoke;
import org.eclnt.jsfserver.elements.events.BaseActionEventPopupMenuItem;
import org.eclnt.jsfserver.elements.events.BaseActionEventPopupMenuLoad;
import org.eclnt.jsfserver.elements.events.BaseActionEventTabClose;
import org.eclnt.jsfserver.elements.impl.DYNAMICCONTENTBinding;
import org.eclnt.jsfserver.elements.impl.ROWDYNAMICCONTENTBinding;
import org.eclnt.jsfserver.elements.impl.TABBEDLINEComponent;
import org.eclnt.jsfserver.elements.impl.TABBEDLINETABComponentTag;
import org.eclnt.jsfserver.elements.util.Trigger;
import org.eclnt.jsfserver.i18n.I18N;
import org.eclnt.jsfserver.managedbean.IDispatcher;
import org.eclnt.jsfserver.pagebean.PageBeanUtil;
import org.eclnt.jsfserver.resources.ResourceManager;
import org.eclnt.jsfserver.util.ClientTestLog;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.StyleManager;
import org.eclnt.jsfserver.util.SystemXml;
import org.eclnt.jsfserver.util.useraccess.UserAccessMgr;
import org.eclnt.util.classresolver.CCClassResolver;
import org.eclnt.util.classresolver.ENUMCallerType;
import org.eclnt.util.extractapply.IExtractApply;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.UniqueIdCreator;
import org.eclnt.util.valuemgmt.ValueManager;
import org.eclnt.workplace.IWorkpage;
import org.eclnt.workplace.IWorkpageContainer;
import org.eclnt.workplace.IWorkpageContainerListener;
import org.eclnt.workplace.IWorkpageContainerRenderer;
import org.eclnt.workplace.IWorkpageDispatcher;
import org.eclnt.workplace.IWorkpageSelector;
import org.eclnt.workplace.IWorkpageStartInfo;
import org.eclnt.workplace.Workpage;
import org.eclnt.workplace.WorkpageByPageBean;
import org.eclnt.workplace.WorkpageContainerMultiWorkplaceManager;
import org.eclnt.workplace.WorkpageContainerRendererViaHideablePane;
import org.eclnt.workplace.WorkpageProcessingEvent;
import org.eclnt.workplace.WorkpageStartInfo;
import org.eclnt.workplace.WorkplaceFunctionSearchUI;
import org.eclnt.workplace.WorkplaceFunctionsManager;
import org.eclnt.workplace.WorkplaceHistory;
import org.eclnt.workplace.WorkplacePerspectiveManager;
import org.eclnt.workplace.WorkplaceTileInfo;
import org.eclnt.workplace.WorkplaceTileManager;
import org.eclnt.workplace.WorkplaceUserInfo;
import org.eclnt.workplace.WorkplaceUserInfoManager;
import org.eclnt.workplace.WorkplaceViewManager;
import org.eclnt.workplace.eximport.WorkplaceExtractApply;
import org.eclnt.workplace.eximport.WorkplacePageBeanStateExtractor;

public class WorkpageContainer
implements IWorkpageContainer,
Serializable {
    protected static boolean s_implicitLoadingOfWorkplaceForCurrentUser = true;
    protected WorkpageContainer m_this = this;
    protected WorkpageContainer m_owner = null;
    protected WorkplaceTileManager m_tileManager;
    protected WorkplaceFunctionsManager m_functionsManager;
    protected WorkplacePerspectiveManager m_perspectiveManager;
    protected WorkplaceFunctionSearchUI m_functionSearchUI;
    protected WorkplaceHistory m_history;
    protected SubWorkpageContainers m_subWorkpageContainers = new SubWorkpageContainers();
    protected String m_ownSubContainerId = null;
    protected List<IWorkpage> m_workpageList = new ArrayList<IWorkpage>();
    protected Map<IWorkpage, WorkpageInfo> m_workpageInfos = new HashMap<IWorkpage, WorkpageInfo>();
    protected WorkpageInfoMap m_workpageInfoMap = new WorkpageInfoMap();
    protected IWorkpage m_currentWorkpage;
    protected TABBEDLINEComponent m_tabbedLine;
    protected int m_tabbedLineIndex = 0;
    protected int m_previousTabbedLineIndex = 0;
    protected boolean m_tabbedLineEnabled = true;
    protected Stack<IWorkpage> m_navigationStack = new Stack();
    protected String m_emptyPage = null;
    protected IWorkpageDispatcher m_workpageDispatcher;
    protected int m_focusCounter = 1;
    protected int m_maxNumberOfWorkpages = Integer.MAX_VALUE;
    protected String m_maxNumberOfWorkpagesExceededMessage = null;
    protected int m_defaultPopupWidth = 800;
    protected int m_defaultPopupHeight = 600;
    protected boolean m_updateOnInnerEventOnly = false;
    protected boolean m_openWorkpagePopupsAsFrame = false;
    protected boolean m_showPopupWorkpagesInSelector = true;
    protected String m_cubeAnimationDirection = "down";
    protected Trigger m_animationTrigger = new Trigger();
    protected Set<IWorkpageContainerListener> m_workpageContainerListeners = new HashSet<IWorkpageContainerListener>();
    protected boolean m_workplacePrepareWasCalled = false;
    protected boolean m_withPreparingWorkplaceForCurrentUser = true;
    protected boolean m_withTabSelectorCloseIcons = true;
    protected String m_workpagePopupDefaultBgpaint = null;
    protected boolean m_hotkeyisolation = true;
    protected boolean m_withWorkpageDragDrop = true;
    protected String m_rendererClassName = null;
    protected IWorkpageContainerRenderer m_renderer = null;
    protected String m_uniqueId = "WPC" + UniqueIdCreator.createCounter();
    protected DYNAMICCONTENTBinding m_dynMenuContent = new DYNAMICCONTENTBinding();
    protected WorkpageContainerMultiWorkplaceManager m_multiWorkplaceManager;
    protected IWorkpageSelector m_workpageSelector;
    protected boolean m_withCubeRotation = false;

    public WorkpageContainer(IWorkpageDispatcher dispatcher) {
        this(dispatcher, s_implicitLoadingOfWorkplaceForCurrentUser);
    }

    public WorkpageContainer(IWorkpageDispatcher dispatcher, boolean withPreparingWorkplaceForCurrentUser) {
        this.m_workpageDispatcher = dispatcher;
        if (HttpSessionAccess.checkIfCurrentClientTypeIsRisc()) {
            this.m_openWorkpagePopupsAsFrame = true;
        }
        try {
            this.m_tileManager = new WorkplaceTileManager(this);
            this.m_functionsManager = new WorkplaceFunctionsManager(dispatcher);
            this.m_perspectiveManager = new WorkplacePerspectiveManager(dispatcher);
            this.m_withPreparingWorkplaceForCurrentUser = withPreparingWorkplaceForCurrentUser;
            this.initWorkpageSelector();
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problem occurred during workpage container intialization: " + t.toString());
        }
    }

    protected WorkpageContainer(IWorkpageDispatcher dispatcher, WorkpageContainer owner, String subContainerId) {
        this.m_workpageDispatcher = dispatcher;
        if (HttpSessionAccess.checkIfCurrentClientTypeIsRisc()) {
            this.m_openWorkpagePopupsAsFrame = true;
        }
        this.m_owner = owner;
        this.m_ownSubContainerId = subContainerId;
        this.m_tileManager = owner.m_tileManager;
        this.m_withCubeRotation = owner.m_withCubeRotation;
        if (this.m_owner.getRenderer() != null && this.m_owner.getRenderer().checkIfAlsoUsedForSubContainers()) {
            this.m_rendererClassName = owner.getRendererClassName();
        }
        this.m_functionsManager = owner.getFunctionsManager();
        this.m_perspectiveManager = owner.getPerspectiveManager();
        this.m_history = new WorkplaceHistory((IDispatcher)dispatcher, SystemXml.getWorkplaceWithHistory());
        this.initWorkpageSelector();
    }

    public static void initialize() {
        WorkpageContainer.initImplicitLoadingForCurrentUser(SystemXml.getWorkplaceImplicitLoadingForCurrentUser());
    }

    public static void initImplicitLoadingForCurrentUser(boolean withPreparingWorkplaceForCurrentUser) {
        s_implicitLoadingOfWorkplaceForCurrentUser = withPreparingWorkplaceForCurrentUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepareWorkplaceForCurrentUser() {
        if (this.m_history != null) {
            this.m_history.block();
        }
        this.m_workplacePrepareWasCalled = true;
        try {
            String user = UserAccessMgr.getCurrentUser();
            WorkplaceUserInfo wui = WorkplaceUserInfoManager.loadUserInfo(user);
            if (wui != null) {
                this.setEmptyPage(wui.getBackgroundPage());
                Object preselectedTopNodeId = null;
                if (wui.getFunctionTree() != null) {
                    this.m_functionsManager.importWorkplaceFunctionTreeInfoNode(wui.getFunctionTree());
                }
                if (wui.getDefaultPerspective() != null) {
                    WorkplaceTileInfo wti = WorkplaceViewManager.loadTileInfo(wui.getDefaultPerspective());
                    this.m_tileManager.importWorkplaceTileInfo(wti);
                }
                this.m_perspectiveManager.prepare(user, wui);
                this.m_history = new WorkplaceHistory((IDispatcher)this.m_workpageDispatcher, SystemXml.getWorkplaceWithHistory());
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            if (this.m_history != null) {
                this.m_history.unblock();
            }
        }
    }

    @Override
    public WorkpageContainerMultiWorkplaceManager getMultiWorkplaceManager() {
        if (this.m_owner == null) {
            if (this.m_multiWorkplaceManager == null) {
                this.m_multiWorkplaceManager = new WorkpageContainerMultiWorkplaceManager(this.m_workpageDispatcher);
            }
            return this.m_multiWorkplaceManager;
        }
        return this.m_owner.getMultiWorkplaceManager();
    }

    @Override
    public void setRendererClassName(String value) {
        if (!HttpSessionAccess.checkIfCurrentClientTypeIsRisc() && WorkpageContainerRendererViaHideablePane.class.getName().equals(value)) {
            throw new Error("The workpage-container-renderer is only allowed with RISC client: " + value);
        }
        this.m_rendererClassName = value;
        this.createRenderer();
    }

    @Override
    public String getRendererClassName() {
        return this.m_rendererClassName;
    }

    public DYNAMICCONTENTBinding getDynMenuContent() {
        return this.m_dynMenuContent;
    }

    @Override
    public IWorkpageContainerRenderer getRenderer() {
        if (this.m_renderer == null) {
            this.createRenderer();
        }
        return this.m_renderer;
    }

    protected void createRenderer() {
        String rendererClassName = this.getRendererClassName();
        if (rendererClassName != null) {
            try {
                this.m_renderer = (IWorkpageContainerRenderer)CCConfigurationObjectLoader.instance().loadInstance(rendererClassName, true);
                this.m_renderer.initWorkpageContainer(this);
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_ERR, "Problem when creating renderer", t);
            }
        }
    }

    public Stack<IWorkpage> getNavigationStack() {
        return this.m_navigationStack;
    }

    @Override
    public WorkplaceHistory getHistory() {
        this.initiallyPrepareWorkplaceForCurrentUser();
        if (this.m_history == null) {
            this.m_history = new WorkplaceHistory((IDispatcher)this.m_workpageDispatcher, false);
        }
        return this.m_history;
    }

    public void setHistory(WorkplaceHistory history) {
        this.m_history = history;
    }

    public String getWorkpagePopupDefaultBgpaint() {
        return this.m_workpagePopupDefaultBgpaint;
    }

    @Override
    public void setWorkpagePopupDefaultBgpaint(String workpagePopupDefaultBgpaint) {
        this.m_workpagePopupDefaultBgpaint = workpagePopupDefaultBgpaint;
    }

    @Override
    public boolean getHotKeyIsolation() {
        return this.m_hotkeyisolation;
    }

    @Override
    public void setHotKeyIsolation(boolean hotkeyisolation) {
        this.m_hotkeyisolation = hotkeyisolation;
    }

    public boolean getShowPopupWorkpagesInSelector() {
        return this.m_showPopupWorkpagesInSelector;
    }

    @Override
    public void setShowPopupWorkpagesInSelector(boolean showPopupWorkpagesInSelector) {
        this.m_showPopupWorkpagesInSelector = showPopupWorkpagesInSelector;
    }

    public boolean getWithTabSelectorCloseIcons() {
        return this.m_withTabSelectorCloseIcons;
    }

    @Override
    public void setWithTabSelectorCloseIcons(boolean withTabSelectorCloseIcons) {
        this.m_withTabSelectorCloseIcons = withTabSelectorCloseIcons;
    }

    @Override
    public IWorkpageDispatcher getWorkpageDispatcher() {
        return this.m_workpageDispatcher;
    }

    @Override
    public String getUniqueId() {
        return this.m_uniqueId;
    }

    public void updateUniqueId() {
        this.m_uniqueId = "WPC" + UniqueIdCreator.createCounter();
    }

    @Override
    public void addWorkpageContainerListener(IWorkpageContainerListener workpageContainerListener) {
        this.getWorkpageContainerListeners().add(workpageContainerListener);
    }

    @Override
    public void removeWorkpageContainerListener(IWorkpageContainerListener workpageContainerListner) {
        this.getWorkpageContainerListeners().remove(workpageContainerListner);
    }

    public Set<IWorkpageContainerListener> getWorkpageContainerListeners() {
        if (this.m_owner == null) {
            return this.m_workpageContainerListeners;
        }
        return this.m_owner.getWorkpageContainerListeners();
    }

    public WorkplaceTileManager getTileManagerWithoutInitialization() {
        return this.m_tileManager;
    }

    @Override
    public WorkplaceTileManager getTileManager() {
        this.initiallyPrepareWorkplaceForCurrentUser();
        return this.m_tileManager;
    }

    @Override
    public WorkplaceFunctionsManager getFunctionsManagerWithoutInitialization() {
        return this.m_functionsManager;
    }

    @Override
    public WorkplaceFunctionsManager getFunctionsManager() {
        this.initiallyPrepareWorkplaceForCurrentUser();
        return this.m_functionsManager;
    }

    public WorkplacePerspectiveManager getPerspectiveManagerWithoutInitialization() {
        return this.m_perspectiveManager;
    }

    public WorkplacePerspectiveManager getPerspectiveManager() {
        this.initiallyPrepareWorkplaceForCurrentUser();
        return this.m_perspectiveManager;
    }

    @Override
    public WorkplaceFunctionSearchUI getFunctionSearchUI() {
        this.initiallyPrepareWorkplaceForCurrentUser();
        if (this.m_functionSearchUI == null) {
            this.m_functionSearchUI = new WorkplaceFunctionSearchUI(this.m_workpageDispatcher);
        }
        return this.m_functionSearchUI;
    }

    public SubWorkpageContainers getSubWorkpageContainers() {
        return this.m_subWorkpageContainers;
    }

    @Override
    public Map<String, ? extends IWorkpageContainer> getSubContainers() {
        return this.m_subWorkpageContainers;
    }

    @Override
    public IWorkpageSelector getWorkpageSelector() {
        return this.m_workpageSelector;
    }

    @Override
    public boolean getOpenWorkpagePopupsAsFrame() {
        return this.m_openWorkpagePopupsAsFrame;
    }

    @Override
    public void setOpenWorkpagePopupsAsFrame(boolean value) {
        this.m_openWorkpagePopupsAsFrame = value;
    }

    @Override
    public String getOwnSubContainerId() {
        return this.m_ownSubContainerId;
    }

    public WorkpageContainer getRootWorkpageContainer() {
        if (this.m_owner != null) {
            return this.m_owner;
        }
        return this;
    }

    public int getDefaultPopupWidth() {
        return this.m_defaultPopupWidth;
    }

    @Override
    public void setDefaultPopupWidth(int defaultPopupWidth) {
        this.m_defaultPopupWidth = defaultPopupWidth;
        for (WorkpageContainer wpc : this.m_subWorkpageContainers.values()) {
            wpc.setDefaultPopupWidth(defaultPopupWidth);
        }
    }

    public int getDefaultPopupHeight() {
        return this.m_defaultPopupHeight;
    }

    @Override
    public void setDefaultPopupHeight(int defaultPopupHeight) {
        this.m_defaultPopupHeight = defaultPopupHeight;
        for (WorkpageContainer wpc : this.m_subWorkpageContainers.values()) {
            wpc.setDefaultPopupHeight(defaultPopupHeight);
        }
    }

    public boolean getUpdateOnInnerEventOnly() {
        return this.m_updateOnInnerEventOnly;
    }

    @Override
    public void setUpdateOnInnerEventOnly(boolean value) {
        this.m_updateOnInnerEventOnly = value;
        for (WorkpageContainer wpc : this.m_subWorkpageContainers.values()) {
            wpc.setUpdateOnInnerEventOnly(value);
        }
    }

    @Override
    public void setEmptyPage(String jspPage) {
        this.m_emptyPage = jspPage;
        for (WorkpageContainer wpc : this.m_subWorkpageContainers.values()) {
            wpc.setEmptyPage(jspPage);
        }
    }

    public WorkpageInfoMap getWpim() {
        return this.m_workpageInfoMap;
    }

    @Override
    public IWorkpageContainer getSubWorkpageContainerForWorkpage(IWorkpage workpage) {
        WorkpageContainer wpc = this.getWorkpageContainerForExisitingWorkpage(workpage);
        if (wpc == null) {
            return null;
        }
        return wpc;
    }

    @Override
    public String getSubWorkpageContainerIdForWorkpage(IWorkpage workpage) {
        WorkpageContainer wpc = this.getWorkpageContainerForExisitingWorkpage(workpage);
        if (wpc == null) {
            return null;
        }
        return wpc.m_ownSubContainerId;
    }

    @Override
    public void setMaxNumberOfWorkpages(int maxNumberOfWorkpages) {
        this.m_maxNumberOfWorkpages = maxNumberOfWorkpages;
        for (WorkpageContainer wpc : this.m_subWorkpageContainers.values()) {
            wpc.setMaxNumberOfWorkpages(maxNumberOfWorkpages);
        }
    }

    @Override
    public void setMaxNumberOfWorkpagesExceededMessage(String message) {
        this.m_maxNumberOfWorkpagesExceededMessage = message;
        for (WorkpageContainer wpc : this.m_subWorkpageContainers.values()) {
            wpc.setMaxNumberOfWorkpagesExceededMessage(message);
        }
    }

    @Override
    public void moveIsolatedWorkpageBackIntoContentArea(IWorkpage workpage) {
        this.moveWorkpageIntoContentArea(workpage);
    }

    @Override
    public void moveWorkpageIntoContentArea(IWorkpage workpage) {
        WorkpageContainer wpc = null;
        try {
            wpc = this.getWorkpageContainerForExisitingWorkpage(workpage);
            if (wpc == null) {
                throw new Exception();
            }
        }
        catch (Throwable t) {
            wpc = this.getWorkpageContainerForNewWorkpage(workpage);
        }
        wpc.moveWorkpageIntoContentAreaLOCAL(workpage);
        this.m_tileManager.ensureTileForWorkpageContainerIsAvailable(wpc.m_ownSubContainerId);
    }

    protected void moveWorkpageIntoContentAreaLOCAL(IWorkpage workpage) {
        CLog.L.log(CLog.LL_INF, "Moving into contente area " + workpage);
        WorkpageInfo wpi = this.getWorkpageInfoLOCAL(workpage);
        if (!wpi.i_openedAsPopup) {
            this.switchToWorkpageLOCAL(workpage);
        } else {
            wpi.i_popup.close();
            wpi.i_openedAsPopup = false;
            wpi.i_popup = null;
            workpage.setModelessPopupOfWorkpage(null);
            this.switchToWorkpageLOCAL(workpage, false, true);
            this.updateTabbedLineLOCAL();
        }
    }

    @Override
    public void maximizeWorkpage(IWorkpage workpage, boolean value) {
        this.getWorkpageContainerForExisitingWorkpage(workpage).maximizeWorkpageLOCAL(workpage, value);
    }

    protected void maximizeWorkpageLOCAL(IWorkpage workpage, boolean value) {
        CLog.L.log(CLog.LL_INF, "Maximizing popup " + workpage);
        WorkpageInfo wpi = this.getWorkpageInfoLOCAL(workpage);
        if (wpi.i_openedAsPopup) {
            wpi.i_popup.maximize(value);
        }
    }

    public int getFocusCounter() {
        return this.m_focusCounter;
    }

    @Override
    public ModelessPopup addWorkpageAsPopup(IWorkpage workpage) {
        ModelessPopup result = this.getWorkpageContainerForNewWorkpage(workpage).addWorkpageAsPopupLOCAL(workpage);
        if (this.m_history != null) {
            this.m_history.addFavorite(workpage);
        }
        return result;
    }

    protected ModelessPopup addWorkpageAsPopupLOCAL(IWorkpage workpage) {
        if (workpage != null) {
            ClientTestLog.addClientTestLogMessage("Adding workpage " + workpage.getJspPage() + "as popup");
        }
        this.addWorkpageLOCAL(workpage, false, true);
        ModelessPopup result = this.openCurrentPageAsModelessPopupLOCAL();
        if (result == null) {
            workpage.reactOnShownInContentArea();
        }
        return result;
    }

    @Override
    public void addWorkpageAndKeepInBackground(IWorkpage workpage) {
        this.getWorkpageContainerForNewWorkpage(workpage).addWorkpageAndKeepInBackgroundLOCAL(workpage);
        for (IWorkpageContainerListener l : this.getWorkpageContainerListeners()) {
            l.reactOnWorkpageAdded(workpage);
        }
    }

    public void addWorkpageAndKeepInBackgroundLOCAL(IWorkpage workpage) {
        if (workpage != null) {
            ClientTestLog.addClientTestLogMessage("Adding workpage (and keep in background)" + workpage.getJspPage());
        }
        this.addWorkpageLOCAL(workpage, true, false);
    }

    @Override
    public void addWorkpage(IWorkpage workpage) {
        WorkpageContainer wpcLOCAL = this.getWorkpageContainerForNewWorkpage(workpage);
        boolean result = wpcLOCAL.addWorkpageLOCAL(workpage);
        if (result) {
            for (IWorkpageContainerListener l : this.getWorkpageContainerListeners()) {
                l.reactOnWorkpageAdded(workpage);
            }
            if (this.m_history != null) {
                this.m_history.addFavorite(workpage);
            }
        }
    }

    protected boolean addWorkpageLOCAL(IWorkpage workpage) {
        if (workpage != null) {
            ClientTestLog.addClientTestLogMessage("Adding workpage " + workpage.getJspPage());
        }
        return this.addWorkpageLOCAL(workpage, true, true);
    }

    protected boolean addWorkpageLOCAL(IWorkpage workpage, boolean withTrigger, boolean withSwitchToForeground) {
        CLog.L.log(CLog.LL_INF, "Adding workpage " + workpage);
        if (this.m_workpageList.size() == 0) {
            withSwitchToForeground = true;
        }
        if (this.m_workpageList.size() >= this.m_maxNumberOfWorkpages) {
            String message = this.m_maxNumberOfWorkpagesExceededMessage;
            if (message == null) {
                message = new I18N().get("WP_maxnumberofworkpagesreached");
                message = message.replace("$1$", "" + this.m_maxNumberOfWorkpages);
            }
            Statusbar.outputAlert(message);
            return false;
        }
        if (withSwitchToForeground && this.m_workpageList.size() > 0 && this.m_currentWorkpage != null && !this.m_currentWorkpage.reactOnBeforeHide()) {
            return false;
        }
        this.m_workpageList.add(workpage);
        this.sortWorkpageListBySortIndex(this.m_workpageList);
        if (withSwitchToForeground) {
            this.switchToWorkpageLOCAL(workpage, false, true);
        }
        this.updateTabbedLineLOCAL();
        if (withSwitchToForeground && withTrigger) {
            this.triggerAnimation("down");
        }
        return true;
    }

    public Trigger getAnimationValue() {
        return this.m_animationTrigger;
    }

    public Trigger getCubeAnimationValue() {
        if (this.m_withCubeRotation) {
            return this.getAnimationValue();
        }
        return null;
    }

    public String getCubeAnimationDirection() {
        return this.m_cubeAnimationDirection;
    }

    public String getCurrentJspPage() {
        if (this.m_currentWorkpage == null) {
            return this.m_emptyPage;
        }
        return this.m_currentWorkpage.getJspPage();
    }

    @Override
    public String getEmptyPage() {
        return this.m_emptyPage;
    }

    public String getCurrentClientName() {
        if (this.m_currentWorkpage != null) {
            return this.m_currentWorkpage.getClientName();
        }
        return null;
    }

    public String getContentReplaceForWorkpage(IWorkpage wp) {
        if (wp == null) {
            return null;
        }
        String s1 = this.m_workpageDispatcher.getExpressionBase();
        String s2 = wp.getDispatcher().getExpressionBase();
        s1 = s1.substring(0, s1.length() - 1) + ".";
        s2 = s2.substring(0, s2.length() - 1) + ".";
        return s1 + ":" + s2;
    }

    public void renderWorkpageNode(IWorkpage wp, ROWDYNAMICCONTENTBinding.ComponentNode parentNode, String parentNodeId) {
        ROWDYNAMICCONTENTBinding.ComponentNode outest = this.renderOutestNode(wp, parentNode, parentNodeId);
        this.renderROWTITLEBARNodeForWorkpage(wp, outest, parentNodeId);
        this.renderROWINCLUDENodeForWorkpage(wp, outest, parentNodeId);
    }

    protected ROWDYNAMICCONTENTBinding.ComponentNode renderOutestNode(IWorkpage wp, ROWDYNAMICCONTENTBinding.ComponentNode parentNode, String parentNodeId) {
        ROWNode r = new ROWNode();
        parentNode.addSubNode(r);
        r.addAttribute("id", parentNodeId + "_or");
        PANENode p = new PANENode();
        r.addSubNode(p);
        p.addAttribute("id", parentNodeId + "_op");
        p.setPadding("0");
        p.setRowdistance("0");
        p.setWidth("100%");
        p.setHeight("100%");
        return p;
    }

    protected void renderROWTITLEBARNodeForWorkpage(IWorkpage wp, ROWDYNAMICCONTENTBinding.ComponentNode parentNode, String parentNodeId) {
        if (wp.isDecorated()) {
            ROWTITLEBARNode rtb = new ROWTITLEBARNode();
            parentNode.addSubNode(rtb);
            rtb.addAttribute("id", parentNodeId + "_rtb");
            rtb.setText(wp.getTitle());
            rtb.setDragsend("CCWORKPAGE:" + wp.getUniqueTechnicalId());
            if (wp.isCloseSupported()) {
                ICONNode ic = new ICONNode();
                rtb.addSubNode(ic);
                ic.addAttribute("id", parentNodeId + "_cl");
                ic.setImage(StyleManager.getStyleValue("ccWpCloseImage"));
                ic.setReference(wp.getUniqueTechnicalId());
                ic.setActionListener("#{d.workpageContainer.onCloseWorkpage}");
            }
        }
    }

    protected void renderROWINCLUDENodeForWorkpage(IWorkpage wp, ROWDYNAMICCONTENTBinding.ComponentNode parentNode, String parentNodeId) {
        ROWINCLUDENode ri = new ROWINCLUDENode();
        parentNode.addSubNode(ri);
        ri.addAttribute("id", parentNodeId + "_ri");
        ri.setPage(wp.getJspPage());
        ri.setContentreplacedrilldown(this.getContentReplaceForWorkpage(wp));
        ri.setContentreplace(this.getContentReplaceNoDrillDown(wp));
        ri.setUpdateoninnereventonly(this.m_updateOnInnerEventOnly);
    }

    public void renderPopupMenuIntoNode(IWorkpage wp, ROWDYNAMICCONTENTBinding.ComponentNode node) {
        node.addAttribute("popupmenu", "WORKPAGETAB");
        node.addAttribute("popupmenuloadroundtrip", "true");
    }

    public String getCurrentContentReplace() {
        return this.getContentReplaceForWorkpage(this.m_currentWorkpage);
    }

    public String getContentReplaceNoDrillDown(IWorkpage wp) {
        if (wp == null) {
            return null;
        }
        if (wp instanceof WorkpageByPageBean) {
            return PageBeanUtil.buildContentReplace(((WorkpageByPageBean)wp).getPageBean());
        }
        return null;
    }

    public String getCurrentContentReplaceNoDrillDown() {
        return this.getContentReplaceNoDrillDown(this.m_currentWorkpage);
    }

    @Override
    public IWorkpage getCurrentlySelectedWorkpage() {
        try {
            return this.m_workpageList.get(this.m_tabbedLineIndex);
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Override
    public IWorkpage getCurrentWorkpage() {
        return this.m_currentWorkpage;
    }

    public boolean isCurrentWorkpageDecorated() {
        if (this.m_currentWorkpage != null) {
            return this.m_currentWorkpage.isDecorated();
        }
        return false;
    }

    public boolean isCurrentWorkpagePopupSupported() {
        if (this.m_currentWorkpage != null) {
            return this.m_currentWorkpage.isPopupSupported();
        }
        return false;
    }

    public boolean isCurrentWorkpageWpDragSupported() {
        if (this.m_currentWorkpage != null) {
            return this.m_currentWorkpage.isWpDragSupported();
        }
        return false;
    }

    public boolean isCurrentWorkpageCloseSupported() {
        if (this.m_currentWorkpage != null) {
            return this.m_currentWorkpage.isCloseSupported();
        }
        return false;
    }

    public boolean isCurrentWorkpageBlocked() {
        if (this.m_currentWorkpage != null) {
            return this.m_currentWorkpage.isBlocked();
        }
        return false;
    }

    public String getCurrentWorkpageClientNamePopupIcon() {
        if (this.m_currentWorkpage != null) {
            return "CC_WP_POPUPICON_" + this.m_currentWorkpage.getId();
        }
        return null;
    }

    public String getCurrentWorkpageClientNameWpDrag() {
        if (this.m_currentWorkpage != null) {
            return "CC_WP_WPDRAGICON_" + this.m_currentWorkpage.getId();
        }
        return null;
    }

    public String getCurrentWorkpageClientNameCloseIcon() {
        if (this.m_currentWorkpage != null) {
            return "CC_WP_CLOSEICON_" + this.m_currentWorkpage.getId();
        }
        return null;
    }

    @Override
    public void setWithWorkpageDragDrop(boolean withWorkpageDragDrop) {
        this.m_withWorkpageDragDrop = withWorkpageDragDrop;
    }

    @Override
    public boolean getWithWorkpageDragDrop() {
        return this.m_withWorkpageDragDrop;
    }

    @Override
    public IWorkpage getWorkpageForUniqueTechnicalId(String techId) {
        IWorkpage result = this.getWorkpageForUniqueTechnicalIdLOCAL(techId);
        if (result != null) {
            return result;
        }
        for (WorkpageContainer sub : this.m_subWorkpageContainers.values()) {
            result = sub.getWorkpageForUniqueTechnicalIdLOCAL(techId);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    protected IWorkpage getWorkpageForUniqueTechnicalIdLOCAL(String id) {
        for (int i = 0; i < this.m_workpageList.size(); ++i) {
            IWorkpage wp = this.m_workpageList.get(i);
            if (!wp.getUniqueTechnicalId().equals(id)) continue;
            return wp;
        }
        return null;
    }

    @Override
    public IWorkpage getWorkpageForId(String id) {
        IWorkpage result = this.getWorkpageForIdLOCAL(id);
        if (result != null) {
            return result;
        }
        for (WorkpageContainer sub : this.m_subWorkpageContainers.values()) {
            result = sub.getWorkpageForIdLOCAL(id);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    protected IWorkpage getWorkpageForIdLOCAL(String id) {
        for (int i = 0; i < this.m_workpageList.size(); ++i) {
            IWorkpage wp = this.m_workpageList.get(i);
            if (wp.getId() == null || !wp.getId().equals(id)) continue;
            return wp;
        }
        return null;
    }

    protected void showAsContentPage(IWorkpage wp) {
        this.getWorkpageContainerForExisitingWorkpage(wp).showAsContentPageLOCAL(wp);
    }

    protected void showAsContentPageLOCAL(IWorkpage wp) {
        this.m_currentWorkpage = wp;
        ++this.m_focusCounter;
        if (wp != null) {
            this.m_navigationStack.add(wp);
        }
    }

    @Override
    public void switchToWorkpage(IWorkpage wp) {
        this.getWorkpageContainerForExisitingWorkpage(wp).switchToWorkpageLOCAL(wp);
    }

    protected void switchToWorkpageLOCAL(IWorkpage wp) {
        if (wp != null) {
            ClientTestLog.addClientTestLogMessage("Switching to workpage " + wp.getJspPage());
        }
        this.switchToWorkpageLOCAL(wp, true, true);
    }

    protected void switchToWorkpageLOCAL(IWorkpage wp, boolean withTrigger, boolean withHideSignal) {
        if (wp == null) {
            this.showAsContentPageLOCAL(null);
            return;
        }
        wp.reactOnSwitchToPage();
        if (!this.getWorkpageInfoLOCAL((IWorkpage)wp).i_openedAsPopup) {
            IWorkpage previousWorkpage;
            if (this.m_currentWorkpage == wp) {
                this.m_currentWorkpage.reactOnReselectedInContentArea();
                this.triggerAnimation("down");
                return;
            }
            if (!this.m_navigationStack.isEmpty() && (previousWorkpage = this.m_navigationStack.peek()) != null && withHideSignal) {
                previousWorkpage.reactOnHide();
            }
            String navigationDirection = "left";
            try {
                int indexNow;
                IWorkpage previousWorkpage2 = this.m_navigationStack.peek();
                int indexPrev = this.m_workpageList.indexOf(previousWorkpage2);
                if (indexPrev >= 0 && indexPrev > (indexNow = this.m_workpageList.indexOf(wp))) {
                    navigationDirection = "right";
                }
            }
            catch (Throwable previousWorkpage2) {
                // empty catch block
            }
            this.showAsContentPageLOCAL(wp);
            wp.reactOnShownInContentArea();
            this.m_tabbedLineIndex = wp != null ? this.m_workpageList.indexOf(wp) : 0;
            if (withTrigger) {
                this.triggerAnimation(navigationDirection);
            }
        } else {
            this.m_tabbedLineIndex = this.m_workpageList.indexOf(wp);
            WorkpageInfo wpi = this.getWorkpageInfoLOCAL(wp);
            wpi.i_popup.requestFocus();
            if (wpi.i_popupIsHidden) {
                wpi.i_popup.setLeft(wpi.i_previousLeft);
                wpi.i_popup.setTop(wpi.i_previousTop);
                wpi.i_popup.setWidth(wpi.i_previousWidth);
                wpi.i_popup.setHeight(wpi.i_previousHeight);
                wpi.i_popupIsHidden = false;
            }
        }
        wp.reactOnDisplay();
        for (IWorkpageContainerListener wpl : this.m_workpageContainerListeners) {
            wpl.reactOnWorkpageSwitchedTo(wp);
        }
    }

    public void setTabbedLine(TABBEDLINEComponent tabbedLine) {
        if (this.m_tabbedLine == tabbedLine) {
            return;
        }
        this.m_tabbedLine = tabbedLine;
        this.updateTabbedLineLOCAL();
    }

    public int getIndexOfCurrentlySelectedWorkpage() {
        return this.m_tabbedLineIndex;
    }

    public int getTabbedLineIndex() {
        return this.m_tabbedLineIndex;
    }

    public void setTabbedLineIndex(int tabbedLineIndex) {
        this.m_previousTabbedLineIndex = this.m_tabbedLineIndex;
        this.m_tabbedLineIndex = tabbedLineIndex;
    }

    public boolean getRenderedTabbedLine() {
        return this.m_workpageSelector == null;
    }

    public boolean getRenderedWorkpageSelector() {
        return !this.getRenderedTabbedLine();
    }

    public boolean getTabbedLineEnabled() {
        return this.m_tabbedLineEnabled;
    }

    @Override
    public void setWorkpageSelectorEnabled(IWorkpage workpage, boolean tabbedLineEnabled) {
        WorkpageContainer wc = this.getWorkpageContainerForExisitingWorkpage(workpage);
        if (wc != null) {
            wc.m_tabbedLineEnabled = tabbedLineEnabled;
        }
    }

    public boolean getEnabledCloseAll() {
        List<IWorkpage> wps = this.findCloseableWorkpages();
        return wps.size() > 1;
    }

    public boolean getEnabledCloseAllLeft() {
        List<IWorkpage> wps = this.findCloseableWorkpagesLeftOfCurrent();
        return wps.size() > 0;
    }

    public boolean getEnabledCloseAllRight() {
        List<IWorkpage> wps = this.findCloseableWorkpagesRightOfCurrent();
        return wps.size() > 0;
    }

    public boolean getEnabledCloseOthers() {
        List<IWorkpage> wps = this.findCloseableWorkpagesBesidesCurrent();
        return wps.size() > 0;
    }

    public void onTabbedLineTabAction(ActionEvent ae) {
        BaseActionEvent bae = (BaseActionEvent)ae;
        if (bae instanceof BaseActionEventPopupMenuLoad) {
            this.renderDynMenuContent();
        } else if (bae instanceof BaseActionEventPopupMenuItem) {
            int index = this.m_tabbedLineIndex;
            if ("cmdCLOSEWORKPAGE".equals(bae.getCommand())) {
                this.closeWorkpageLOCAL(this.m_workpageList.get(index), false);
            }
            if ("cmdOPENASPOPUP".equals(bae.getCommand())) {
                this.onOpenCurrentPageAsModelessPopup(null);
            }
            if ("cmdCLOSEALL".equals(bae.getCommand())) {
                this.closeAllWorkpages();
            }
            if ("cmdCLOSEALLLEFT".equals(bae.getCommand())) {
                this.closeAllWorkpagesLeftOfCurrent();
            }
            if ("cmdCLOSEALLRIGHT".equals(bae.getCommand())) {
                this.closeAllWorkpagesRightOfCurrent();
            }
            if ("cmdCLOSEOTHERS".equals(bae.getCommand())) {
                this.closeAllWorkpagesBesidesCurrent();
            }
        } else if (bae instanceof BaseActionEventInvoke) {
            boolean allResult = true;
            if (this.m_previousTabbedLineIndex != this.m_tabbedLineIndex) {
                for (IWorkpageContainerListener wpcl : this.m_workpageContainerListeners) {
                    try {
                        boolean wpclResult = wpcl.reactOnSelectorUserSelection(this, this.m_previousTabbedLineIndex, this.m_tabbedLineIndex, this.m_workpageList.get(this.m_previousTabbedLineIndex), this.m_workpageList.get(this.m_tabbedLineIndex));
                        if (wpclResult) continue;
                        allResult = false;
                        break;
                    }
                    catch (Throwable t) {
                        CLog.L.log(CLog.LL_INF, t.toString());
                    }
                }
                if (allResult) {
                    try {
                        IWorkpage wp = this.m_workpageList.get(this.m_previousTabbedLineIndex);
                        boolean wpResult = wp.reactOnBeforeHide();
                        if (!wpResult) {
                            allResult = false;
                        }
                    }
                    catch (Throwable t) {
                        CLog.L.log(CLog.LL_INF, t.toString());
                    }
                }
            }
            if (allResult) {
                this.switchToWorkpageLOCAL(this.m_workpageList.get(this.m_tabbedLineIndex));
            } else {
                this.m_tabbedLineIndex = this.m_previousTabbedLineIndex;
            }
        } else if (ae instanceof BaseActionEventTabClose) {
            int index = this.m_tabbedLineIndex;
            this.closeWorkpageLOCAL(this.m_workpageList.get(index), false);
        }
    }

    public void onSwitchToLeft(ActionEvent ae) {
        try {
            int index = this.m_tabbedLineIndex;
            if (index < 1) {
                return;
            }
            this.switchToWorkpageLOCAL(this.m_workpageList.get(--index));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void onSwitchToRight(ActionEvent ae) {
        try {
            int index = this.m_tabbedLineIndex;
            if (index == this.m_workpageList.size() - 1) {
                return;
            }
            this.switchToWorkpageLOCAL(this.m_workpageList.get(++index));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void onCloseAllWorkpages(ActionEvent ae) {
        this.closeAllWorkpages();
    }

    public void onTabbedLineAction(ActionEvent ae) {
        if (ae instanceof BaseActionEventDrop) {
            BaseActionEventDrop baed = (BaseActionEventDrop)ae;
            CLog.L.log(CLog.LL_INF, "DROP WAS RECEIVED: " + baed.getDragInfo());
            String dragInfo = baed.getDragInfo();
            if (dragInfo != null && dragInfo.startsWith("CCWORKPAGE:")) {
                String techId = dragInfo.substring("CCWORKPAGE:".length());
                WorkpageContainer topWPC = this.getTopWorkpageContainerLOCAL();
                topWPC.moveWorkpage(techId, this);
            }
        }
    }

    public void moveWorkpage(String wpTechId, String toWorkpageContainerId) {
        WorkpageContainer toWpc = this;
        if (toWorkpageContainerId != null) {
            toWpc = this.m_subWorkpageContainers.get(toWorkpageContainerId);
        }
        this.moveWorkpage(wpTechId, toWpc);
    }

    protected void moveWorkpage(String wpTechId, WorkpageContainer toWpc) {
        IWorkpage wp = this.getWorkpageForUniqueTechnicalId(wpTechId);
        if (wp == null) {
            CLog.L.log(CLog.LL_ERR, "No workpage found for workpage tech id: " + wpTechId);
            return;
        }
        this.moveWorkpage(wp, toWpc);
    }

    public void moveWorkpage(IWorkpage wp, WorkpageContainer toWpc) {
        WorkpageContainer fromWpc = this.getWorkpageContainerForExisitingWorkpage(wp);
        fromWpc.removeWorkpageOpticallyLOCAL(wp);
        toWpc.addWorkpageLOCAL(wp, true, true);
        if (fromWpc.m_ownSubContainerId != null && fromWpc.m_workpageList.size() == 0) {
            for (IWorkpageContainerListener l : this.getWorkpageContainerListeners()) {
                try {
                    l.reactOnWorkpageContainerGotEmpty(fromWpc.m_ownSubContainerId);
                }
                catch (Throwable throwable) {}
            }
        }
        for (IWorkpageContainerListener wpcl : fromWpc.m_workpageContainerListeners) {
            wpcl.reactOnWorkpageMoved(wp, fromWpc, toWpc);
        }
        for (IWorkpageContainerListener wpcl : toWpc.m_workpageContainerListeners) {
            wpcl.reactOnWorkpageMoved(wp, fromWpc, toWpc);
        }
    }

    @Override
    public void closeAllWorkpages() {
        this.closeAllWorkpages(true, null);
    }

    public void closeAllWorkpagesBesidesCurrent() {
        IWorkpage current = this.getCurrentWorkpage();
        this.closeWorkpages(this.findCloseableWorkpagesBesidesCurrent(), true, null);
        this.switchToWorkpage(current);
    }

    public void closeAllWorkpagesLeftOfCurrent() {
        IWorkpage current = this.getCurrentWorkpage();
        this.closeWorkpages(this.findCloseableWorkpagesLeftOfCurrent(), true, null);
        this.switchToWorkpage(current);
    }

    protected List<IWorkpage> findCloseableWorkpages() {
        ArrayList<IWorkpage> result = new ArrayList<IWorkpage>();
        for (IWorkpage workpage : this.m_workpageList) {
            if (!workpage.isCloseSupported()) continue;
            result.add(workpage);
        }
        return result;
    }

    protected List<IWorkpage> findCloseableWorkpagesBesidesCurrent() {
        IWorkpage current = this.getCurrentWorkpage();
        ArrayList<IWorkpage> result = new ArrayList<IWorkpage>();
        for (IWorkpage workpage : this.m_workpageList) {
            if (workpage == current || !workpage.isCloseSupported()) continue;
            result.add(workpage);
        }
        return result;
    }

    protected List<IWorkpage> findCloseableWorkpagesLeftOfCurrent() {
        IWorkpage current = this.getCurrentWorkpage();
        ArrayList<IWorkpage> result = new ArrayList<IWorkpage>();
        for (IWorkpage workpage : this.m_workpageList) {
            if (workpage == current) break;
            if (!workpage.isCloseSupported()) continue;
            result.add(workpage);
        }
        return result;
    }

    public void closeAllWorkpagesRightOfCurrent() {
        IWorkpage current = this.getCurrentWorkpage();
        this.closeWorkpages(this.findCloseableWorkpagesRightOfCurrent(), true, null);
        this.switchToWorkpage(current);
    }

    protected List<IWorkpage> findCloseableWorkpagesRightOfCurrent() {
        IWorkpage current = this.getCurrentWorkpage();
        boolean foundCurrent = false;
        ArrayList<IWorkpage> result = new ArrayList<IWorkpage>();
        for (IWorkpage workpage : this.m_workpageList) {
            if (workpage == current) {
                foundCurrent = true;
                continue;
            }
            if (!foundCurrent || !workpage.isCloseSupported()) continue;
            result.add(workpage);
        }
        return result;
    }

    @Override
    public void closeAllWorkpages(boolean forcedMode, Runnable afterCloseOperation) {
        this.closeWorkpages(this.m_workpageList, forcedMode, afterCloseOperation);
    }

    public void closeWorkpages(List<IWorkpage> workpagesToBeClosed, boolean forcedMode, Runnable afterCloseOperation) {
        if (forcedMode) {
            IWorkpage[] workpages = new IWorkpage[workpagesToBeClosed.size()];
            workpagesToBeClosed.toArray(workpages);
            for (IWorkpage workpage : workpages) {
                if (!this.m_workpageList.contains(workpage) || !workpage.isCloseSupported()) continue;
                this.switchToWorkpage(workpage);
                this.removeWorkpageLOCAL(workpage, true, null, false);
            }
            if (afterCloseOperation != null) {
                afterCloseOperation.run();
            }
        } else {
            boolean success = this.closeWorkpagesWithContinueOperation(workpagesToBeClosed, new CloseAllWorkpagesContinueOperation(workpagesToBeClosed, afterCloseOperation));
            if (success && afterCloseOperation != null) {
                try {
                    afterCloseOperation.run();
                }
                catch (Throwable t) {
                    CLog.L.log(CLog.LL_ERR, "Problem when calling afterCloseOperation", t);
                }
            }
        }
        for (WorkpageContainer subWorkpageContainer : this.m_subWorkpageContainers.values()) {
            subWorkpageContainer.closeAllWorkpages(forcedMode, afterCloseOperation);
        }
    }

    protected boolean closeAllWorkpagesWithContinueOperation(Runnable continueOperation) {
        return this.closeWorkpagesWithContinueOperation(this.m_workpageList, continueOperation);
    }

    protected boolean closeWorkpagesWithContinueOperation(List<IWorkpage> workpagesToBeClosed, Runnable continueOperation) {
        IWorkpage[] workpages = new IWorkpage[workpagesToBeClosed.size()];
        workpagesToBeClosed.toArray(workpages);
        boolean closeAllInterrupted = false;
        for (IWorkpage workpage : workpages) {
            if (!this.m_workpageList.contains(workpage)) continue;
            this.switchToWorkpage(workpage);
            boolean result = this.removeWorkpageLOCAL(workpage, false, continueOperation, false);
            if (result) continue;
            closeAllInterrupted = true;
            break;
        }
        return !closeAllInterrupted;
    }

    public void onCloseWorkpage(ActionEvent ae) {
        String reference = ((BaseActionEvent)ae).getSourceReference();
        for (IWorkpage wp : this.m_workpageList) {
            if (!ValueManager.checkIfStringsAreEqual(wp.getUniqueTechnicalId(), reference)) continue;
            this.removeWorkpageLOCAL(wp, false, null, false);
            break;
        }
    }

    public void onCloseCurrentWorkpage(ActionEvent ae) {
        this.removeWorkpageLOCAL(this.m_currentWorkpage, false, null, false);
    }

    public void onPageAction(ActionEvent ae) {
        if (ae instanceof BaseActionEventDrop) {
            BaseActionEventDrop bae = (BaseActionEventDrop)ae;
            String drop = ((BaseActionEventDrop)ae).getDragInfo();
            if (drop.startsWith("workpage:")) {
                String csv = drop.substring("workpage:".length());
                if (csv != null) {
                    String[] values = ValueManager.decodeCSV(csv);
                    String page = values[0];
                    String title = values[1];
                    Workpage newWp = new Workpage(this.m_workpageDispatcher, page, page, title, null, true);
                    this.addWorkpage(newWp);
                }
            } else if (drop.startsWith("CCWORKPAGE:")) {
                String wpTechId = drop.substring("CCWORKPAGE:".length());
                HashSet<IWorkpageContainerListener> listenersClone = new HashSet<IWorkpageContainerListener>(this.getWorkpageContainerListeners());
                for (IWorkpageContainerListener listener : listenersClone) {
                    try {
                        listener.reactOnWorkpageDrop(this.m_ownSubContainerId, wpTechId, bae.getPercentageHorizontal(), bae.getPercentageVertical());
                    }
                    catch (Throwable throwable) {}
                }
            }
        } else if (ae instanceof BaseActionEventPopupMenuItem) {
            BaseActionEventPopupMenuItem e = (BaseActionEventPopupMenuItem)ae;
            if ("CCWP_CLOSE".equals(e.getCommand())) {
                this.removeWorkpageLOCAL(this.m_currentWorkpage, false, null, false);
            } else if ("CCWP_CLOSEALL".equals(e.getCommand())) {
                this.closeAllWorkpages();
            } else if ("CCWP_CLOSEALLLEFT".equals(e.getCommand())) {
                this.closeAllWorkpagesLeftOfCurrent();
            } else if ("CCWP_CLOSEALLRIGHT".equals(e.getCommand())) {
                this.closeAllWorkpagesRightOfCurrent();
            } else if ("CCWP_CLOSEALLOTHERS".equals(e.getCommand())) {
                this.closeAllWorkpagesBesidesCurrent();
            } else if ("CCWP_SWITCHLEFT".equals(e.getCommand())) {
                this.onSwitchToLeft(ae);
            } else if ("CCWP_SWITCHRIGHT".equals(e.getCommand())) {
                this.onSwitchToRight(ae);
            }
        }
    }

    public void onOpenCurrentPageAsModelessPopup(ActionEvent ae) {
        this.openCurrentPageAsModelessPopup();
    }

    public void openCurrentPageAsModelessPopup() {
        this.openCurrentPageAsModelessPopupLOCAL();
    }

    @Override
    public ModelessPopup isolateWorkpageIntoModelessPopup(IWorkpage workpage) {
        try {
            this.switchToWorkpage(workpage);
            return this.openCurrentPageAsModelessPopupLOCAL();
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problem when isolating workpage", t);
            return null;
        }
    }

    @Override
    public void destroy() {
        if (this.m_multiWorkplaceManager != null) {
            this.m_multiWorkplaceManager.destroy();
            this.m_multiWorkplaceManager = null;
        }
    }

    protected ModelessPopup openCurrentPageAsModelessPopupLOCAL() {
        if (this.m_currentWorkpage == null) {
            return null;
        }
        if (this.getWorkpageInfoLOCAL((IWorkpage)this.m_currentWorkpage).i_openedAsPopup) {
            return null;
        }
        ModelessPopup popup = ModelessPopup.createInstance();
        popup.setBgpaint(this.m_workpagePopupDefaultBgpaint);
        String fixPopupPageName = "/eclntjsfserver/includes/wp_popupinclude.jsp";
        String dispatcherName = this.m_currentWorkpage.getDispatcher().getExpressionBase();
        dispatcherName = dispatcherName.substring(2, dispatcherName.length() - 1);
        popup.open(fixPopupPageName, this.m_currentWorkpage.getTitle(), this.m_defaultPopupWidth, this.m_defaultPopupHeight, new MyModelessPopupListener(this.m_currentWorkpage, popup));
        popup.setOpenasframe(this.m_openWorkpagePopupsAsFrame);
        popup.setContentReplaceDrillDown(this.getCurrentContentReplace());
        popup.setContentReplace("@PAGE@:" + this.m_currentWorkpage.getJspPage() + ";@DISPATCHER@:" + dispatcherName);
        this.getWorkpageInfoLOCAL((IWorkpage)this.m_currentWorkpage).i_openedAsPopup = true;
        this.getWorkpageInfoLOCAL((IWorkpage)this.m_currentWorkpage).i_popup = popup;
        popup.setImage(this.m_currentWorkpage.getIconURL());
        if (SystemXml.getDialogsUseWorkpageIdAsPersistid()) {
            popup.setPersistid(this.m_currentWorkpage.getId());
        }
        if (!this.m_currentWorkpage.isPopupDecorated()) {
            popup.setUndecorated(true);
            popup.setSizeableIfUndecorated(true);
        }
        this.removeWorkpageFromNavigationStackLOCAL(this.m_currentWorkpage);
        this.m_currentWorkpage.setModelessPopupOfWorkpage(popup);
        this.m_currentWorkpage.reactOnShownInPopup();
        this.updateTabbedLineLOCAL();
        if (!this.m_navigationStack.isEmpty()) {
            IWorkpage shownWorkpage = this.m_navigationStack.peek();
            this.switchToWorkpageLOCAL(shownWorkpage, true, false);
        } else {
            this.showAsContentPageLOCAL(null);
        }
        return popup;
    }

    @Override
    public boolean closeWorkpage(IWorkpage workpage, boolean alsoCloseWorkpageWithNoCloseSupported) {
        return this.getWorkpageContainerForExisitingWorkpage(workpage).closeWorkpageLOCAL(workpage, alsoCloseWorkpageWithNoCloseSupported);
    }

    @Override
    public boolean closeWorkpage(IWorkpage workpage) {
        return this.getWorkpageContainerForExisitingWorkpage(workpage).closeWorkpageLOCAL(workpage, false);
    }

    protected boolean closeWorkpageLOCAL(IWorkpage workpage, boolean alsoCloseWorkpageWithNoCloseSupported) {
        CLog.L.log(CLog.LL_INF, "Closing " + workpage);
        if (workpage != null) {
            ClientTestLog.addClientTestLogMessage("Closing workpage " + workpage.getJspPage());
        }
        if (workpage == null) {
            return true;
        }
        if (this.m_workpageList.contains(workpage)) {
            this.switchToWorkpageLOCAL(workpage, false, true);
            this.removeWorkpageLOCAL(workpage, false, null, alsoCloseWorkpageWithNoCloseSupported);
        }
        return this.m_workpageList == null || !this.m_workpageList.contains(workpage);
    }

    @Override
    public void closeWorkpageForced(IWorkpage workpage, boolean alsoCloseWorkpageWithNoCloseSupported) {
        this.getWorkpageContainerForExisitingWorkpage(workpage).closeWorkpageForcedLOCAL(workpage, alsoCloseWorkpageWithNoCloseSupported);
    }

    @Override
    public void closeWorkpageForced(IWorkpage workpage) {
        this.getWorkpageContainerForExisitingWorkpage(workpage).closeWorkpageForcedLOCAL(workpage, false);
    }

    protected void closeWorkpageForcedLOCAL(IWorkpage workpage, boolean alsoCloseWorkpageWithNoCloseSupported) {
        if (workpage == null) {
            return;
        }
        if (this.m_workpageList.contains(workpage)) {
            this.switchToWorkpageLOCAL(workpage);
            this.removeWorkpageLOCAL(workpage, true, null, alsoCloseWorkpageWithNoCloseSupported);
        }
    }

    public void onHideAllPopups(ActionEvent ae) {
        this.hideAllPopups();
    }

    @Override
    public boolean checkIfWorkpageIsOpenedInPopup(IWorkpage workpage) {
        return this.getWorkpageContainerForExisitingWorkpage(workpage).checkIfWorkpageIsOpenedInPopupLOCAL(workpage);
    }

    protected boolean checkIfWorkpageIsOpenedInPopupLOCAL(IWorkpage workpage) {
        WorkpageInfo wpi = this.getWorkpageInfoLOCAL(workpage);
        return wpi.i_openedAsPopup;
    }

    @Override
    public List<IWorkpage> getAllWorkpages() {
        return this.m_workpageList;
    }

    @Override
    public List<IWorkpage> getAllWorkpagesIncludingSubWorkpageContainers() {
        ArrayList<IWorkpage> result = new ArrayList<IWorkpage>();
        List<IWorkpage> perContainerList = this.getAllWorkpages();
        for (IWorkpage iWorkpage : perContainerList) {
            result.add(iWorkpage);
        }
        for (IWorkpageContainer iWorkpageContainer : this.getSubContainers().values()) {
            perContainerList = iWorkpageContainer.getAllWorkpages();
            for (IWorkpage wp : perContainerList) {
                result.add(wp);
            }
        }
        return result;
    }

    @Override
    public boolean getWithCubeRotation() {
        return this.m_withCubeRotation;
    }

    @Override
    public void setWithCubeRotation(boolean withCubeRotation) {
        this.m_withCubeRotation = withCubeRotation;
    }

    public void hideAllPopups() {
        WorkpageInfo wpi;
        int counter = 0;
        boolean didHideOneNewOne = false;
        for (IWorkpage wp : this.m_workpageList) {
            wpi = this.getWorkpageInfoLOCAL(wp);
            if (!wpi.i_openedAsPopup) continue;
            if (!wpi.i_popupIsHidden) {
                wpi.i_previousLeft = wpi.i_popup.getLeft();
                wpi.i_previousTop = wpi.i_popup.getTop();
                wpi.i_previousWidth = wpi.i_popup.getWidth();
                wpi.i_previousHeight = wpi.i_popup.getHeight();
                didHideOneNewOne = true;
            }
            wpi.i_popupIsHidden = true;
            wpi.i_popup.setHeight(22);
            wpi.i_popup.setLeft(0);
            wpi.i_popup.setTop(counter * 22);
            wpi.i_popup.setWidth(100);
            ++counter;
        }
        if (!didHideOneNewOne) {
            for (IWorkpage wp : this.m_workpageList) {
                wpi = this.getWorkpageInfoLOCAL(wp);
                if (!wpi.i_openedAsPopup) continue;
                this.switchToWorkpage(wp);
            }
        }
    }

    protected WorkpageInfo getWorkpageInfoLOCAL(IWorkpage workpage) {
        WorkpageInfo result = this.m_workpageInfos.get(workpage);
        if (result == null) {
            result = new WorkpageInfo(workpage);
            this.m_workpageInfos.put(workpage, result);
        }
        return result;
    }

    public void removeWorkpageInfo(IWorkpage workpage) {
        this.getWorkpageContainerForExisitingWorkpage(workpage).removeWorkpageInfoLOCAL(workpage);
    }

    protected void removeWorkpageInfoLOCAL(IWorkpage workpage) {
        this.m_workpageInfos.remove(workpage);
    }

    protected void removeWorkpageOpticallyLOCAL(IWorkpage workpage) {
        boolean itIsTheCurrentContentPage = workpage == this.m_currentWorkpage;
        WorkpageInfo wpi = this.getWorkpageInfoLOCAL(workpage);
        boolean itIsOpenedAsPopup = wpi.i_openedAsPopup;
        if (wpi.i_openedAsPopup) {
            wpi.i_popup.close();
            wpi.i_popup = null;
            wpi.i_openedAsPopup = false;
        }
        this.m_workpageList.remove(workpage);
        this.removeWorkpageInfoLOCAL(workpage);
        this.removeWorkpageFromNavigationStackLOCAL(workpage);
        if (itIsTheCurrentContentPage) {
            if (!this.m_navigationStack.isEmpty()) {
                this.switchToWorkpageLOCAL(this.m_navigationStack.peek());
            } else {
                this.switchToWorkpageLOCAL(null);
            }
            this.triggerAnimation("up");
        }
        this.updateTabbedLineLOCAL();
    }

    protected boolean removeWorkpageLOCAL(IWorkpage workpage, boolean withCloseForced, Runnable continueOperation, boolean alsoCloseWorkpageWithNoCloseSupported) {
        boolean itIsTheCurrentContentPage;
        boolean bl = itIsTheCurrentContentPage = workpage == this.m_currentWorkpage;
        if (workpage == null) {
            return true;
        }
        if (!alsoCloseWorkpageWithNoCloseSupported && !workpage.isCloseSupported()) {
            OKPopup.createInstance(I18N.getString("WP_titleWorkpageCannotBeClosed"), I18N.getString("WP_textWorkpageCannotBeClosed"));
            return true;
        }
        if (!withCloseForced) {
            boolean result = continueOperation == null ? workpage.close() : workpage.closeAndContinue(continueOperation);
            if (!result) {
                return false;
            }
        } else {
            workpage.closeForced();
        }
        WorkpageInfo wpi = this.getWorkpageInfoLOCAL(workpage);
        boolean itIsOpenedAsPopup = wpi.i_openedAsPopup;
        if (wpi.i_openedAsPopup) {
            wpi.i_popup.close();
            wpi.i_popup = null;
            wpi.i_openedAsPopup = false;
        }
        this.m_workpageList.remove(workpage);
        this.removeWorkpageInfoLOCAL(workpage);
        this.removeWorkpageFromNavigationStackLOCAL(workpage);
        if (itIsTheCurrentContentPage) {
            if (!this.m_navigationStack.isEmpty()) {
                this.switchToWorkpageLOCAL(this.m_navigationStack.peek());
            } else {
                this.switchToWorkpageLOCAL(null);
            }
            this.triggerAnimation("up");
        }
        this.updateTabbedLineLOCAL();
        if (this.m_workpageList.size() == 0) {
            for (IWorkpageContainerListener listener : this.getWorkpageContainerListeners()) {
                try {
                    listener.reactOnWorkpageContainerGotEmpty(this.m_ownSubContainerId);
                }
                catch (Throwable throwable) {}
            }
        }
        for (IWorkpageContainerListener wpcl : this.m_workpageContainerListeners) {
            wpcl.reactOnWorkpageRemoved(workpage);
        }
        return true;
    }

    @Override
    public void throwWorkpageProcessingEvent(WorkpageProcessingEvent event) {
        if (event == null) {
            return;
        }
        CLog.L.log(CLog.LL_INF, "Workpage processing event was thrown: " + event);
        this.throwWorkpageProcessingEventLOCAL(event);
        WorkpageContainer[] wpcs = new WorkpageContainer[this.m_subWorkpageContainers.size()];
        this.m_subWorkpageContainers.values().toArray(wpcs);
        for (WorkpageContainer wpc : wpcs) {
            try {
                wpc.throwWorkpageProcessingEventLOCAL(event);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            IWorkpageDispatcher wpd = (IWorkpageDispatcher)this.m_workpageDispatcher.getTopOwner();
            wpd.getWorkpage().processWorkpageProcessingEvent(event);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problem when passing event to top dispatcher", t);
        }
    }

    protected void throwWorkpageProcessingEventLOCAL(WorkpageProcessingEvent event) {
        IWorkpage[] wps = new IWorkpage[this.m_workpageList.size()];
        this.m_workpageList.toArray(wps);
        for (IWorkpage wp : wps) {
            if (wp.getUniqueTechnicalId().equals(event.getSrcWorkpageUuid())) continue;
            CLog.L.log(CLog.LL_INF, "Delegating event to workpage");
            wp.processWorkpageProcessingEvent(event);
        }
    }

    protected void removeWorkpageFromNavigationStackLOCAL(IWorkpage workpage) {
        for (int i = this.m_navigationStack.size() - 1; i >= 0; --i) {
            IWorkpage wp = (IWorkpage)this.m_navigationStack.get(i);
            if (wp != workpage) continue;
            this.m_navigationStack.remove(wp);
        }
    }

    protected void updateTabbedLineLOCAL() {
        if (this.m_tabbedLine != null) {
            this.sortPopupWorkpagesToTheEndLOCAL();
            this.m_tabbedLine.getChildren().clear();
            for (int i = 0; i < this.m_workpageList.size(); ++i) {
                IWorkpage wp = this.m_workpageList.get(i);
                TABBEDLINETABComponentTag tltt = new TABBEDLINETABComponentTag();
                tltt.setId(this.m_uniqueId + "_TLT_" + i);
                tltt.setStylevariant("WP_WORKPAGESELECTOR");
                String textExpression = this.m_workpageDispatcher.getExpressionBase();
                textExpression = this.m_ownSubContainerId == null ? textExpression.replace("}", ".workpageContainer.wpim.p" + i + ".selectorTitle}") : textExpression.replace("}", ".workpageContainer.subContainers." + this.m_ownSubContainerId + ".wpim.p" + i + ".selectorTitle}");
                tltt.setText(textExpression);
                String bgpaintExpression = this.m_workpageDispatcher.getExpressionBase();
                bgpaintExpression = this.m_ownSubContainerId == null ? bgpaintExpression.replace("}", ".workpageContainer.wpim.p" + i + ".selectorBgpaint}") : bgpaintExpression.replace("}", ".workpageContainer.subContainers." + this.m_ownSubContainerId + ".wpim.p" + i + ".selectorBgpaint}");
                tltt.setBgpaintaddon(bgpaintExpression);
                tltt.setClientname("WorkpageTab_" + this.m_ownSubContainerId + "_" + i);
                String renderedExpression = this.m_workpageDispatcher.getExpressionBase();
                renderedExpression = this.m_ownSubContainerId == null ? renderedExpression.replace("}", ".workpageContainer.wpim.p" + i + ".rendered}") : renderedExpression.replace("}", ".workpageContainer.subContainers." + this.m_ownSubContainerId + ".wpim.p" + i + ".rendered}");
                tltt.setRendered(renderedExpression);
                String commentExpression = this.m_workpageDispatcher.getExpressionBase();
                commentExpression = this.m_ownSubContainerId == null ? commentExpression.replace("}", ".workpageContainer.wpim.p" + i + ".comment}") : commentExpression.replace("}", ".workpageContainer.subContainers." + this.m_ownSubContainerId + ".wpim.p" + i + ".comment}");
                tltt.setTooltip(commentExpression);
                String imageExpression = this.m_workpageDispatcher.getExpressionBase();
                imageExpression = this.m_ownSubContainerId == null ? imageExpression.replace("}", ".workpageContainer.wpim.p" + i + ".image}") : imageExpression.replace("}", ".workpageContainer.subContainers." + this.m_ownSubContainerId + ".wpim.p" + i + ".image}");
                tltt.setImage(imageExpression);
                tltt.setPopupmenu("WORKPAGETAB");
                tltt.setPopupmenuloadroundtrip("true");
                tltt.setActionListener(this.buildOnPopupMenuExpressionLOCAL());
                if (this.m_withWorkpageDragDrop) {
                    tltt.setDragsend("CCWORKPAGE:" + wp.getUniqueTechnicalId());
                } else {
                    tltt.setDragsend(null);
                }
                if (this.m_withTabSelectorCloseIcons) {
                    if (wp.isCloseSupported()) {
                        tltt.setWithcloseicon("true");
                    } else {
                        tltt.setWithcloseicon("false");
                    }
                    tltt.setAlign("left");
                } else {
                    tltt.setWithcloseicon("false");
                }
                this.m_tabbedLine.getChildren().add(tltt.createBaseComponent());
            }
            this.m_tabbedLineIndex = this.m_currentWorkpage != null ? this.m_workpageList.indexOf(this.m_currentWorkpage) : 0;
        }
        if (this.m_workpageSelector != null) {
            this.m_workpageSelector.update();
        }
    }

    protected String buildOnPopupMenuExpressionLOCAL() {
        String ex = this.m_workpageDispatcher.getExpressionBase();
        ex = ex.substring(0, ex.length() - 1);
        ex = this.m_ownSubContainerId == null ? ex + ".workpageContainer.onTabbedLineTabAction}" : ex + ".workpageContainer.subContainers." + this.m_ownSubContainerId + ".onTabbedLineTabAction}";
        return ex;
    }

    protected WorkpageContainer getWorkpageContainerForNewWorkpage(IWorkpage workpage) {
        if (workpage == null) {
            return this;
        }
        if (workpage.getStartSubWorkpageContainerId() == null || workpage.getStartSubWorkpageContainerId().equals("")) {
            return this;
        }
        WorkpageContainer result = this.m_subWorkpageContainers.get(workpage.getStartSubWorkpageContainerId());
        if (result != null) {
            return result;
        }
        return this;
    }

    protected WorkpageContainer getWorkpageContainerForExisitingWorkpage(IWorkpage workpage) {
        if (workpage == null) {
            return this;
        }
        if (this.m_workpageInfos.containsKey(workpage)) {
            return this;
        }
        for (WorkpageContainer sub : this.m_subWorkpageContainers.values()) {
            if (!sub.m_workpageInfos.containsKey(workpage)) continue;
            return sub;
        }
        throw new Error("The workpage " + workpage.getId() + "/" + workpage.getJspPage() + "does not exist in any workpage container.\nThis is 'by definition' not possible if properly working with the workapge container interface.\nMake sure that the workpage was added into the workpage container before working with it.");
    }

    protected WorkpageContainer getTopWorkpageContainerLOCAL() {
        if (this.m_ownSubContainerId == null) {
            return this;
        }
        return this.m_owner;
    }

    protected String findEmptyPage() {
        try {
            String user = UserAccessMgr.getCurrentUser();
            String emptyPage = WorkplaceUserInfoManager.loadUserInfo(user).getBackgroundPage();
            return emptyPage;
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Override
    public List<WorkpageStartInfo> exportCurrentWorkpages() {
        ArrayList<WorkpageStartInfo> result = new ArrayList<WorkpageStartInfo>();
        this.exportCurrentWorkpagesLOCAL(result);
        for (WorkpageContainer wpc : this.m_subWorkpageContainers.values()) {
            wpc.exportCurrentWorkpagesLOCAL(result);
        }
        return result;
    }

    protected void exportCurrentWorkpagesLOCAL(List<WorkpageStartInfo> result) {
        for (IWorkpage wp : this.m_workpageList) {
            IWorkpageStartInfo wpsi;
            if (wp.getExcludeFromSavePerspective() || (wpsi = wp.getWorkpageStartInfo()) == null) continue;
            WorkpageStartInfo newWpsi = WorkplacePageBeanStateExtractor.instance().extractWorkpageStartInfo(wp);
            result.add(newWpsi);
        }
    }

    protected void initiallyPrepareWorkplaceForCurrentUser() {
        if (!this.m_withPreparingWorkplaceForCurrentUser) {
            return;
        }
        if (!this.m_workplacePrepareWasCalled) {
            this.prepareWorkplaceForCurrentUser();
        }
    }

    protected void sortPopupWorkpagesToTheEndLOCAL() {
        if (!this.m_showPopupWorkpagesInSelector) {
            ArrayList<IWorkpage> normalWps = new ArrayList<IWorkpage>();
            ArrayList<IWorkpage> popupWps = new ArrayList<IWorkpage>();
            for (IWorkpage wp : this.m_workpageList) {
                WorkpageInfo wpi = this.getWorkpageInfoLOCAL(wp);
                if (!wpi.i_openedAsPopup) {
                    normalWps.add(wp);
                    continue;
                }
                popupWps.add(wp);
            }
            if (popupWps.size() > 0) {
                this.m_workpageList.clear();
                for (IWorkpage wp : normalWps) {
                    this.m_workpageList.add(wp);
                }
                for (IWorkpage wp : popupWps) {
                    this.m_workpageList.add(wp);
                }
            }
        }
    }

    protected void renderDynMenuContent() {
        IWorkpage wp = this.getCurrentWorkpage();
        if (wp != null) {
            MENUITEMNode min;
            MENUITEMNode min2;
            ArrayList<ROWDYNAMICCONTENTBinding.ComponentNode> l = new ArrayList<ROWDYNAMICCONTENTBinding.ComponentNode>();
            if (wp.isCloseSupported()) {
                min2 = new MENUITEMNode().setClientname("CCWPMENU_CLOSEWORKPAGE").setCommand("cmdCLOSEWORKPAGE").setImage("#{ccstylevalue.ccWpCloseImage}").setText("#{eclnti18n.WPSEL_close}");
                l.add(min2);
            }
            if (wp.isPopupSupported()) {
                min2 = new MENUITEMNode().setClientname("CCWPMENU_OPENASPOPUP").setCommand("cmdOPENASPOPUP").setImage("#{ccstylevalue.ccWpPopupImage}").setText("#{eclnti18n.WPSEL_openaspopup}");
                l.add(min2);
            }
            int sizeBeforeAll = l.size();
            if (this.getEnabledCloseAll()) {
                min = new MENUITEMNode().setClientname("CCWPMENU_CLOSEALL").setCommand("cmdCLOSEALL").setText("#{eclnti18n.WPSEL_closeall}");
                l.add(min);
            }
            if (this.getEnabledCloseOthers()) {
                min = new MENUITEMNode().setClientname("CCWPMENU_CLOSEOTHERS").setCommand("cmdCLOSEOTHERS").setText("#{eclnti18n.WPSEL_closeothers}");
                l.add(min);
            }
            if (this.getEnabledCloseAllLeft()) {
                min = new MENUITEMNode().setClientname("CCWPMENU_CLOSEALLLEFT").setCommand("cmdCLOSEALLLEFT").setText("#{eclnti18n.WPSEL_closeallleft}");
                l.add(min);
            }
            if (this.getEnabledCloseAllRight()) {
                min = new MENUITEMNode().setClientname("CCWPMENU_CLOSEALLRIGHT").setCommand("cmdCLOSEALLRIGHT").setText("#{eclnti18n.WPSEL_closeallright}");
                l.add(min);
            }
            if (sizeBeforeAll < l.size()) {
                MENUSEPARATORNode s = new MENUSEPARATORNode();
                l.add(sizeBeforeAll, s);
            }
            this.m_dynMenuContent.setContentNodes(l);
        }
    }

    protected void initWorkpageSelector() {
        block5: {
            try {
                String className = SystemXml.getWorkpageSelector();
                if (className == null) break block5;
                Class c = CCClassResolver.resolveClass(className, ENUMCallerType.CONFIGURATION);
                try {
                    Constructor con = c.getConstructor(IWorkpageDispatcher.class);
                    this.m_workpageSelector = (IWorkpageSelector)con.newInstance(this.getWorkpageDispatcher());
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                if (this.m_workpageSelector == null) {
                    this.m_workpageSelector = (IWorkpageSelector)c.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                this.m_workpageSelector.init(this);
            }
            catch (Throwable t) {
                this.m_workpageSelector = null;
                throw new Error("Problem when creating instance of IWorkpageSelector", t);
            }
        }
    }

    private void triggerAnimation(String cubeDirection) {
        if (this.m_withCubeRotation) {
            this.m_cubeAnimationDirection = cubeDirection;
        }
        this.m_animationTrigger.trigger();
    }

    @Override
    public IExtractApply creatWorkplaceExtractApply() {
        return new WorkplaceExtractApply(this);
    }

    private void sortWorkpageListBySortIndex(List<IWorkpage> workpageList) {
        Collections.sort(workpageList, new Comparator<IWorkpage>(){

            @Override
            public int compare(IWorkpage o1, IWorkpage o2) {
                int index1 = o1.getSortIndex();
                int index2 = o2.getSortIndex();
                if (index1 < 0) {
                    index1 = Integer.MAX_VALUE;
                }
                if (index2 < 0) {
                    index2 = Integer.MAX_VALUE;
                }
                return index1 - index2;
            }
        });
    }

    class CloseAllWorkpagesContinueOperation
    implements Runnable {
        Runnable i_afterCloseOperation;
        List<IWorkpage> i_workpagesToBeClosed;

        public CloseAllWorkpagesContinueOperation(List<IWorkpage> workpagesToBeClosed, Runnable afterCloseOperation) {
            this.i_workpagesToBeClosed = workpagesToBeClosed;
            this.i_afterCloseOperation = afterCloseOperation;
        }

        @Override
        public void run() {
            WorkpageContainer.this.closeWorkpages(this.i_workpagesToBeClosed, false, this.i_afterCloseOperation);
        }
    }

    public class SubWorkpageContainers
    extends HashMap<String, WorkpageContainer> {
        @Override
        public WorkpageContainer get(Object key) {
            WorkpageContainer result = (WorkpageContainer)super.get(key);
            if (result == null) {
                result = new WorkpageContainer(WorkpageContainer.this.m_workpageDispatcher, WorkpageContainer.this.m_this, key.toString());
                result.m_emptyPage = WorkpageContainer.this.m_emptyPage;
                result.m_maxNumberOfWorkpages = WorkpageContainer.this.m_maxNumberOfWorkpages;
                result.m_maxNumberOfWorkpagesExceededMessage = WorkpageContainer.this.m_maxNumberOfWorkpagesExceededMessage;
                result.m_defaultPopupWidth = WorkpageContainer.this.m_defaultPopupWidth;
                result.m_defaultPopupHeight = WorkpageContainer.this.m_defaultPopupHeight;
                result.m_openWorkpagePopupsAsFrame = WorkpageContainer.this.m_openWorkpagePopupsAsFrame;
                result.m_updateOnInnerEventOnly = WorkpageContainer.this.m_updateOnInnerEventOnly;
                result.m_showPopupWorkpagesInSelector = WorkpageContainer.this.m_showPopupWorkpagesInSelector;
                result.m_workpagePopupDefaultBgpaint = WorkpageContainer.this.m_workpagePopupDefaultBgpaint;
                result.m_hotkeyisolation = WorkpageContainer.this.m_hotkeyisolation;
                result.m_withWorkpageDragDrop = WorkpageContainer.this.m_withWorkpageDragDrop;
                result.m_rendererClassName = WorkpageContainer.this.m_rendererClassName;
                result.createRenderer();
                this.put(key.toString(), result);
            }
            return result;
        }
    }

    public class WorkpageInfoMap
    extends HashMap<String, WorkpageInfo>
    implements Serializable {
        @Override
        public WorkpageInfo get(Object key) {
            String indexString = ((String)key).substring(1);
            int index = ValueManager.decodeInt(indexString, 0);
            IWorkpage wp = WorkpageContainer.this.m_workpageList.get(index);
            return WorkpageContainer.this.getWorkpageInfoLOCAL(wp);
        }
    }

    public class WorkpageInfo
    implements Serializable {
        protected boolean i_openedAsPopup = false;
        protected boolean i_popupIsHidden = false;
        protected int i_previousWidth;
        protected int i_previousLeft;
        protected int i_previousTop;
        protected int i_previousHeight;
        protected ModelessPopup i_popup;
        protected IWorkpage i_workpage;

        public WorkpageInfo(IWorkpage workpage) {
            this.i_workpage = workpage;
        }

        public String getImage() {
            if (this.i_openedAsPopup) {
                return StyleManager.getStyleValue("ccWpPopupImageSmall");
            }
            if (this.i_workpage.getIconURL() != null) {
                return this.i_workpage.getIconURL();
            }
            if (HttpSessionAccess.checkIfCurrentClientTypeIsRisc()) {
                return "/null!";
            }
            return null;
        }

        public String getTitle() {
            return ResourceManager.findText(this.getTitleOriginal());
        }

        public String getTitleOriginal() {
            return this.i_workpage.getTitle();
        }

        public String getSelectorTitle() {
            return ResourceManager.findText(this.getSelectorTitleOriginal());
        }

        public String getSelectorBgpaint() {
            return this.i_workpage.getSelectorBgpaint();
        }

        public boolean isOpenedAsPopup() {
            return this.i_openedAsPopup;
        }

        public boolean isPopupIsHidden() {
            return this.i_popupIsHidden;
        }

        public int getPreviousWidth() {
            return this.i_previousWidth;
        }

        public int getPreviousLeft() {
            return this.i_previousLeft;
        }

        public int getPreviousTop() {
            return this.i_previousTop;
        }

        public int getPreviousHeight() {
            return this.i_previousHeight;
        }

        public void setOpenedAsPopup(boolean openedAsPopup) {
            this.i_openedAsPopup = openedAsPopup;
        }

        public void setPopupIsHidden(boolean popupIsHidden) {
            this.i_popupIsHidden = popupIsHidden;
        }

        public void setPreviousWidth(int previousWidth) {
            this.i_previousWidth = previousWidth;
        }

        public void setPreviousLeft(int previousLeft) {
            this.i_previousLeft = previousLeft;
        }

        public void setPreviousTop(int previousTop) {
            this.i_previousTop = previousTop;
        }

        public void setPreviousHeight(int previousHeight) {
            this.i_previousHeight = previousHeight;
        }

        public void setPopup(ModelessPopup popup) {
            this.i_popup = popup;
        }

        public void setWorkpage(IWorkpage workpage) {
            this.i_workpage = workpage;
        }

        public ModelessPopup getPopup() {
            return this.i_popup;
        }

        public IWorkpage getWorkpage() {
            return this.i_workpage;
        }

        public String getSelectorTitleOriginal() {
            String result = this.i_workpage.getSelectorTitle();
            if (result != null) {
                return result;
            }
            return this.getTitle();
        }

        public String getComment() {
            if (this.i_workpage != null) {
                return this.i_workpage.getComment();
            }
            return this.getSelectorTitle();
        }

        public boolean getRendered() {
            return !this.i_openedAsPopup || WorkpageContainer.this.m_showPopupWorkpagesInSelector;
        }
    }

    public class MyModelessPopupListener
    implements ModelessPopup.IModelessPopupListener,
    Serializable {
        protected IWorkpage i_workpage;
        protected ModelessPopup i_popup;

        public MyModelessPopupListener(IWorkpage workpage, ModelessPopup popup) {
            this.i_workpage = workpage;
            this.i_popup = popup;
        }

        @Override
        public void reactOnPopupClosedByUser() {
            WorkpageContainer.this.closeWorkpage(this.i_workpage);
        }
    }
}

