/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.workplace;

import java.util.ArrayList;
import java.util.List;
import javax.faces.event.ActionEvent;
import org.eclnt.jsfserver.elements.componentnodes.LABELNode;
import org.eclnt.jsfserver.elements.componentnodes.PANENode;
import org.eclnt.jsfserver.elements.componentnodes.PANEWITHSHADENode;
import org.eclnt.jsfserver.elements.componentnodes.ROWNode;
import org.eclnt.jsfserver.elements.events.BaseActionEventDrop;
import org.eclnt.jsfserver.elements.impl.ROWDYNAMICCONTENTBinding;
import org.eclnt.jsfserver.elements.util.Trigger;
import org.eclnt.jsfserver.pagebean.PageBean;
import org.eclnt.util.valuemgmt.UniqueIdCreator;
import org.eclnt.workplace.IWorkpage;
import org.eclnt.workplace.IWorkpageContainer;
import org.eclnt.workplace.IWorkpageContainerListener;
import org.eclnt.workplace.IWorkpageContainerRenderer;
import org.eclnt.workplace.WorkpageContainer;
import org.eclnt.workplace.WorkplaceTileInfo;

public class WorkpageContainerRendererVerticalMiniView
extends PageBean
implements IWorkpageContainerRenderer {
    ROWDYNAMICCONTENTBinding m_content = new ROWDYNAMICCONTENTBinding();
    WorkpageContainer m_wpContainer;
    MyWorkpageContainerListener m_wpContainerListener = new MyWorkpageContainerListener();
    List<PaneItemInfo> m_paneItemInfos = new ArrayList<PaneItemInfo>();
    String m_paneUid = UniqueIdCreator.createRandomId();

    @Override
    public String getPageName() {
        return "/eclntjsfserver/includes/wp_workpagecontainer_verticalminiview.jsp";
    }

    @Override
    public String getRootExpressionUsedInPage() {
        return "#{wpr}";
    }

    public ROWDYNAMICCONTENTBinding getContent() {
        return this.m_content;
    }

    public List<PaneItemInfo> getStackedPaneItemInfos() {
        return this.m_paneItemInfos;
    }

    @Override
    public void initWorkpageContainer(WorkpageContainer wpContainer) {
        this.m_wpContainer = wpContainer;
        this.m_wpContainer.addWorkpageContainerListener(this.m_wpContainerListener);
        this.render();
    }

    public void onScrollPaneAction(ActionEvent event) {
        BaseActionEventDrop e;
        String dragsend;
        if (event instanceof BaseActionEventDrop && (dragsend = (e = (BaseActionEventDrop)event).getDragInfo()).startsWith("CCWORKPAGE:")) {
            String wpuid = dragsend.substring("CCWORKPAGE:".length());
            this.m_wpContainer.getRootWorkpageContainer().moveWorkpage(wpuid, this.m_wpContainer.getOwnSubContainerId());
        }
    }

    public void render() {
        List<IWorkpage> wps = this.m_wpContainer.getAllWorkpages();
        ArrayList nodes = new ArrayList();
        this.m_paneItemInfos.clear();
        PANENode p = new PANENode();
        p.addAttribute("id", this.m_paneUid + "_p");
        p.setRowdistance(10);
        int counter = 0;
        for (IWorkpage wp : wps) {
            PaneItemInfo spii = new PaneItemInfo(wp);
            this.m_paneItemInfos.add(spii);
            String wpUid = wp.getUniqueTechnicalId();
            ROWNode oor = new ROWNode();
            p.addSubNode(oor);
            oor.addAttribute("id", wpUid + "_oor");
            PANENode oop = new PANENode();
            oor.addSubNode(oop);
            oop.addAttribute("id", wpUid + "_oop");
            oop.setDragsend("CCWORKPAGE:" + wp.getUniqueTechnicalId());
            ROWNode or = new ROWNode();
            oop.addSubNode(or);
            or.addAttribute("id", wpUid + "_or");
            PANEWITHSHADENode op = new PANEWITHSHADENode();
            or.addSubNode(op);
            op.addAttribute("id", wpUid + "_op");
            op.setWidth(100);
            op.setHeight(100);
            ROWNode r = new ROWNode();
            op.addSubNode(r);
            r.addAttribute("id", wpUid + "_r");
            PANENode pi = new PANENode();
            r.addSubNode(pi);
            pi.addAttribute("id", wpUid + "_pi");
            pi.setWidth("100%");
            pi.setHeight("100%");
            pi.setScale("0.125");
            this.m_wpContainer.renderWorkpageNode(wp, pi, wpUid);
            ROWNode rt = new ROWNode();
            oop.addSubNode(rt);
            rt.addAttribute("id", wpUid + "_rt");
            LABELNode l = new LABELNode();
            rt.addSubNode(l);
            l.addAttribute("id", wpUid + "l");
            l.setText(wp.getTitle());
            l.setForeground("#FFFFFF");
            l.setAlign("center");
            l.setWidth("100%");
            l.setCutwidth("true");
            ++counter;
        }
        this.m_content.setContentNode(p);
    }

    @Override
    public boolean checkIfAlsoUsedForSubContainers() {
        return false;
    }

    private void switchToWorkpage(IWorkpage workpage) {
        for (PaneItemInfo spii : this.m_paneItemInfos) {
            if (spii.i_workpage != workpage) continue;
            spii.getTrigger().trigger();
            break;
        }
    }

    public class PaneItemInfo {
        IWorkpage i_workpage;
        Trigger i_trigger = new Trigger();

        public PaneItemInfo(IWorkpage workpage) {
            this.i_workpage = workpage;
        }

        public Trigger getTrigger() {
            return this.i_trigger;
        }
    }

    class MyWorkpageContainerListener
    implements IWorkpageContainerListener {
        MyWorkpageContainerListener() {
        }

        @Override
        public void reactOnWorkpageDrop(String workpageContainerId, String workpageTechId, int horizontalPercentage, int verticalPercentage) {
        }

        @Override
        public void reactOnWorkpageAdded(IWorkpage workpage) {
            WorkpageContainerRendererVerticalMiniView.this.render();
        }

        @Override
        public void reactOnWorkpageRemoved(IWorkpage workpage) {
            WorkpageContainerRendererVerticalMiniView.this.render();
        }

        @Override
        public void reactOnWorkpageSwitchedTo(IWorkpage workpage) {
            WorkpageContainerRendererVerticalMiniView.this.switchToWorkpage(workpage);
        }

        @Override
        public void reactOnWorkpageMoved(IWorkpage workpage, IWorkpageContainer from, IWorkpageContainer to) {
            if (WorkpageContainerRendererVerticalMiniView.this.m_wpContainer == from || WorkpageContainerRendererVerticalMiniView.this.m_wpContainer == to) {
                WorkpageContainerRendererVerticalMiniView.this.render();
            }
            if (WorkpageContainerRendererVerticalMiniView.this.m_wpContainer == to) {
                WorkpageContainerRendererVerticalMiniView.this.switchToWorkpage(workpage);
            }
        }

        @Override
        public void reactOnWorkpageContainerGotEmpty(String workpageContainerId) {
        }

        @Override
        public void reactOnPerspectiveUpdate(WorkplaceTileInfo perspective) {
        }

        @Override
        public boolean reactOnSelectorUserSelection(IWorkpageContainer workpageContainer, int fromIndex, int toIndex, IWorkpage fromWorkpage, IWorkpage toWorkpage) {
            return false;
        }
    }
}

