/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.workplace;

import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.transform.Source;
import org.eclnt.jsfserver.streamstore.StreamStore;
import org.eclnt.jsfserver.util.useraccess.UserAccessMgr;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;
import org.eclnt.workplace.WorkpageStartInfo;

@XmlRootElement
public class WorkplaceFavoritesInfo
implements Serializable {
    List<WorkpageStartInfo> m_favorites = new ArrayList<WorkpageStartInfo>();

    public static WorkplaceFavoritesInfo read(String persistId) {
        try {
            String streamStoreName = WorkplaceFavoritesInfo.buildStreamStoreName(persistId);
            String xml = StreamStore.getInstance().readUTF8(streamStoreName, true);
            return WorkplaceFavoritesInfo.unmarshal(xml);
        }
        catch (Throwable t) {
            return new WorkplaceFavoritesInfo();
        }
    }

    public static void save(String persistId, WorkplaceFavoritesInfo wfi) {
        try {
            String xml = WorkplaceFavoritesInfo.marshalFunctionTreeInfo(wfi);
            String streamStoreName = WorkplaceFavoritesInfo.buildStreamStoreName(persistId);
            StreamStore.getInstance().writeUTF8(streamStoreName, xml, true);
        }
        catch (Throwable t) {
            throw new Error(t);
        }
    }

    private static WorkplaceFavoritesInfo unmarshal(String xml) {
        try {
            Source r = ValueManager.convertStringIntoXMLSource(xml);
            JAXBContext jbContext = JAXBContext.newInstance((Class[])new Class[]{WorkplaceFavoritesInfo.class});
            Unmarshaller um = jbContext.createUnmarshaller();
            WorkplaceFavoritesInfo result = (WorkplaceFavoritesInfo)um.unmarshal(r);
            return result;
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Error when reading: " + xml, t);
            throw new Error(t);
        }
    }

    private static String marshalFunctionTreeInfo(WorkplaceFavoritesInfo wfti) {
        try {
            JAXBContext jbContext = JAXBContext.newInstance((Class[])new Class[]{WorkplaceFavoritesInfo.class});
            Marshaller m = jbContext.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.setProperty("jaxb.encoding", (Object)"UTF-8");
            StringWriter writer = new StringWriter();
            m.marshal((Object)wfti, (Writer)writer);
            String xml = ((Object)writer).toString();
            return xml;
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Error when marshalling tree");
            throw new Error(t);
        }
    }

    private static String buildStreamStoreName(String persistId) {
        String user = UserAccessMgr.getCurrentUser();
        return "ccworkplace/favorites/" + user + "/" + persistId + ".xml";
    }

    public List<WorkpageStartInfo> getFavorites() {
        return this.m_favorites;
    }

    public void setFavorites(List<WorkpageStartInfo> favorites) {
        this.m_favorites = favorites;
    }
}

