/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.clientliteralloader;

import java.io.IOException;
import java.util.List;
import javax.faces.FactoryFinder;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclnt.jsfserver.clientliteralloader.IClientLiteralServerLoader;
import org.eclnt.jsfserver.clientliteralloader.LiteralInfo;
import org.eclnt.jsfserver.configuration.CCConfigurationObject;
import org.eclnt.jsfserver.managedbean.DefaultHotDeployListener;
import org.eclnt.jsfserver.managedbean.HotDeployNotifier;
import org.eclnt.jsfserver.util.CCServletBase;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.ServletUtil;
import org.eclnt.jsfserver.util.SystemXml;
import org.eclnt.jsfserver.util.TypeOfSessionMgmt;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;

public class ClientLiteralServlet
extends CCServletBase {
    private FacesContextFactory m_facesContextFactory;
    private Lifecycle m_lifecycle;
    private CCConfigurationObject<IClientLiteralServerLoader> m_loader = null;

    @Override
    public void init() throws ServletException {
        super.init();
        try {
            LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
            this.m_facesContextFactory = (FacesContextFactory)FactoryFinder.getFactory((String)"javax.faces.context.FacesContextFactory");
            this.m_lifecycle = lifecycleFactory.getLifecycle("DEFAULT");
            HotDeployNotifier.addListener(new DefaultHotDeployListener(){

                @Override
                public void onClassLoaderUpdate(ClassLoader newClassLoader) {
                    ClientLiteralServlet.this.m_loader = null;
                }
            });
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problems in init() of ClientLiteralServlet - only relevant if accessing FacesContext during servlet processing");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            TypeOfSessionMgmt.associateNORISCClientWithCurrentThread((Object)this);
            if (!this.checkIfClientLiteralsAreActive()) {
                resp.getWriter().write("");
                return;
            }
            String method = req.getMethod();
            if ("GET".equals(method)) {
                ServletUtil.ensureServletGetIsAllowed(((Object)((Object)this)).getClass());
            }
            resp.setCharacterEncoding("UTF-8");
            ServletUtil.setResponseContentType(resp, "text/plain;charset=UTF-8");
            CLog.L.log(CLog.LL_INF, "ClientLiteralServlet called via http-request");
            FacesContext context = null;
            try {
                context = this.m_facesContextFactory.getFacesContext((Object)this.getServletContext(), (Object)req, (Object)resp, this.m_lifecycle);
                FacesContext facesContext = HttpSessionAccess.getCurrentFacesContext();
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_INF, "Problems in init() of BufferedContentServlet - only relevant if accessing FacesContext during servlet processing");
            }
            String clientLanguage = req.getParameter("language");
            String clientCountry = req.getParameter("country");
            String result = this.loadClientLiterals(clientLanguage, clientCountry, req);
            resp.getWriter().write(result);
        }
        catch (Throwable t) {
            resp.getWriter().write("");
            CLog.L.log(CLog.LL_INF, "ClientLiteralServlet problem", t);
        }
        finally {
            TypeOfSessionMgmt.clearCurrentThread((Object)this);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    private boolean checkIfClientLiteralsAreActive() {
        this.initiazlizeIfRequired();
        return this.m_loader != null;
    }

    private String loadClientLiterals(String language, String country, HttpServletRequest req) {
        this.initiazlizeIfRequired();
        if (this.m_loader.instance() != null) {
            CLog.L.log(CLog.LL_INF, "Now calling client literal loader: " + language + "," + country);
            List<LiteralInfo> literals = this.m_loader.instance().loadLiteralInfos(language, country, req);
            String[] as = new String[literals.size() * 2 + 2];
            int counter = 0;
            for (LiteralInfo literal : literals) {
                as[counter] = literal.getKey();
                as[counter + 1] = literal.getText();
                counter += 2;
            }
            as[counter] = "ccsuccess";
            as[counter + 1] = "ccsuccess";
            String all = ValueManager.encodeCSV(as);
            return all;
        }
        return "";
    }

    private void initiazlizeIfRequired() {
        if (this.m_loader != null) {
            return;
        }
        try {
            if (SystemXml.getClientliteralserverloader() != null) {
                this.m_loader = new CCConfigurationObject(SystemXml.getClientliteralserverloader(), null);
                return;
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_WAR, "Problem when accessing instance of clientliteralserverloader", t);
        }
        this.m_loader = new CCConfigurationObject<Object>(null);
    }
}

