/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.defaultscreens;

import java.io.Serializable;
import java.util.ArrayList;

public interface IImageCaptureProvider
extends Serializable {
    public ImageDataBlock getImageDataBlock();

    public void reactOnCommand(ImageData var1, ImageCommand var2);

    public void reactOnImageDoubleClick();

    public void reactOnIconSelection(ImageData var1);

    public String getBgpaintSelectedAvailable();

    public String getBgpaintSelectedNotAvailable();

    public String getBgpaintUnselectedAvailable();

    public String getBgpaintUnselectedNotAvailable();

    public static class ImageDataBlock
    extends ArrayList<ImageDataRow> {
    }

    public static class ImageDataRow
    extends ArrayList<ImageData> {
    }

    public static class ImageCommandList
    extends ArrayList<ImageCommand> {
    }

    public static class ImageCommand
    implements Serializable {
        String i_id;
        String i_text;
        boolean i_enabled = true;

        public void setId(String value) {
            this.i_id = value;
        }

        public String getId() {
            return this.i_id;
        }

        public void setText(String value) {
            this.i_text = value;
        }

        public String getText() {
            return this.i_text;
        }

        public void setEnabled(boolean value) {
            this.i_enabled = value;
        }

        public boolean getEnabled() {
            return this.i_enabled;
        }
    }

    public static class ImageData {
        Object i_reference;
        String i_iconUrl;
        String i_iconTooltip;
        byte[] i_image;
        boolean i_available;
        ImageCommandList i_commands = new ImageCommandList();
        String i_postBgpaint;

        public void setReference(Object value) {
            this.i_reference = value;
        }

        public Object getReference() {
            return this.i_reference;
        }

        public String getIconUrl() {
            return this.i_iconUrl;
        }

        public void setIconUrl(String iconUrl) {
            this.i_iconUrl = iconUrl;
        }

        public String getIconTooltip() {
            return this.i_iconTooltip;
        }

        public void setIconTooltip(String iconTooltip) {
            this.i_iconTooltip = iconTooltip;
        }

        public byte[] getImage() {
            return this.i_image;
        }

        public void setImage(byte[] image) {
            this.i_image = image;
        }

        public boolean isAvailable() {
            return this.i_available;
        }

        public void setAvailable(boolean available) {
            this.i_available = available;
        }

        public ImageCommandList getCommands() {
            return this.i_commands;
        }

        public void addCommand(String id, String text) {
            ImageCommand ic = new ImageCommand();
            ic.setId(id);
            ic.setText(text);
            this.i_commands.add(ic);
        }

        public void addCommand(String id, String text, boolean enabled) {
            ImageCommand ic = new ImageCommand();
            ic.setId(id);
            ic.setText(text);
            ic.setEnabled(enabled);
            this.i_commands.add(ic);
        }

        public void setPostBgpaint(String value) {
            this.i_postBgpaint = value;
        }

        public String getPostBgpaint() {
            return this.i_postBgpaint;
        }
    }
}

