/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.elements.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.eclnt.jsfserver.util.ArrayListWithChangeIndex;
import org.eclnt.jsfserver.util.IListWithChangeIndex;
import org.eclnt.jsfserver.util.IListWithChangeIndexListener;
import org.eclnt.jsfserver.util.valuemgmt.IDynamicContentBindingObject;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;

public class SMARTTEXTAREABinding
implements Serializable,
IDynamicContentBindingObject {
    int m_caretPosition;
    int m_selectionStart;
    int m_selectionEnd;
    String m_text;
    String m_lastTextCSV;
    ArrayListWithChangeIndex<TextFormatInfo> m_formatInfos = new ArrayListWithChangeIndex();

    public SMARTTEXTAREABinding() {
        this.m_formatInfos.setListWithChangeIndexListener(new IListWithChangeIndexListener(){

            @Override
            public void listItemWasRemoved(IListWithChangeIndex list, Object concreteItem) {
                SMARTTEXTAREABinding.this.m_lastTextCSV = null;
            }

            @Override
            public void listItemWasAdded(IListWithChangeIndex list, Object concreteItem) {
                SMARTTEXTAREABinding.this.m_lastTextCSV = null;
            }

            @Override
            public void listChanged(IListWithChangeIndex list) {
                SMARTTEXTAREABinding.this.m_lastTextCSV = null;
            }
        });
    }

    public void setText(String value) {
        this.m_text = value;
        this.m_lastTextCSV = null;
    }

    public String getText() {
        return this.m_text;
    }

    public int getCaretPosition() {
        return this.m_caretPosition;
    }

    public void setCaretPosition(int caretPosition) {
        this.m_caretPosition = caretPosition;
    }

    public int getSelectionStart() {
        return this.m_selectionStart;
    }

    public void setSelectionStart(int selectionStart) {
        this.m_selectionStart = selectionStart;
    }

    public int getSelectionEnd() {
        return this.m_selectionEnd;
    }

    public void setSelectionEnd(int selectionEnd) {
        this.m_selectionEnd = selectionEnd;
    }

    public List<TextFormatInfo> getFormatInfos() {
        return this.m_formatInfos;
    }

    public void setTextCSV(String csvText) {
        try {
            String[] values = ValueManager.decodeCSV(csvText);
            this.m_text = values[0];
            this.m_formatInfos.clear();
            for (int i = 1; i < values.length; i += 3) {
                int beginOffset = ValueManager.decodeInt(values[i], 0);
                int endOffset = ValueManager.decodeInt(values[i + 1], 0);
                int format = ValueManager.decodeInt(values[i + 2], 0);
                this.m_formatInfos.add(new TextFormatInfo(beginOffset, endOffset, format));
            }
            this.m_lastTextCSV = csvText;
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "", t);
        }
    }

    public String getTextCSV() {
        if (this.m_lastTextCSV == null) {
            ArrayList<String> values = new ArrayList<String>();
            values.add(this.m_text + "");
            for (TextFormatInfo tfi : this.m_formatInfos) {
                values.add("" + tfi.i_beginOffset);
                values.add("" + tfi.i_endOffset);
                values.add("" + tfi.i_format);
            }
            this.m_lastTextCSV = ValueManager.encodeCSV(values);
        }
        return this.m_lastTextCSV;
    }

    public static class TextFormatInfo
    implements Serializable {
        int i_beginOffset;
        int i_endOffset;
        int i_format;

        public TextFormatInfo(int beginOffset, int endOffset, int format) {
            this.i_beginOffset = beginOffset;
            this.i_endOffset = endOffset;
            this.i_format = format;
        }
    }
}

