/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.elements.util;

import java.util.List;
import org.eclnt.jsfserver.elements.impl.FIXGRIDBinding;
import org.eclnt.jsfserver.elements.impl.IFIXGRIDExportSanitizer;
import org.eclnt.jsfserver.elements.util.ENUMExportType;
import org.eclnt.util.valuemgmt.ValueManager;

public class DefaultFIXGRIDExportSanitizer
implements IFIXGRIDExportSanitizer {
    @Override
    public void sanitizeStringDataBeforeExport(ENUMExportType exportType, List<List<String>> data) {
        for (List<String> row : data) {
            int valueCounter = -1;
            for (String value : row) {
                ++valueCounter;
                if (value == null) continue;
                row.set(valueCounter, this.sanitizeSingleStringValue(value));
            }
        }
    }

    @Override
    public void sanitizeValueDataBeforeExport(ENUMExportType exportType, List<List<FIXGRIDBinding.FormattedValue>> data) {
        for (List<FIXGRIDBinding.FormattedValue> row : data) {
            int valueCounter = -1;
            for (FIXGRIDBinding.FormattedValue value : row) {
                ++valueCounter;
                if (value == null || value.getValue() == null || !(value.getValue() instanceof String)) continue;
                value.setValue(this.sanitizeSingleStringValue((String)value.getValue()));
            }
        }
    }

    protected String sanitizeSingleStringValue(String value) {
        return ValueManager.removeAllHtmlTags(value);
    }
}

