/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.elements.util;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import org.eclnt.jsfserver.elements.impl.FIXGRIDBinding;
import org.eclnt.jsfserver.elements.impl.FIXGRIDExportSanitizer;
import org.eclnt.jsfserver.elements.impl.IFIXGRIDXmlExporter;
import org.eclnt.jsfserver.elements.util.ENUMExportType;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;
import org.eclnt.util.valuemgmt.XMLWriter;

public class FIXGRIDXmlExporter
implements IFIXGRIDXmlExporter {
    FIXGRIDBinding m_fixgrid;
    boolean m_selectedItemsOnly = false;

    @Override
    public String exportGrid(FIXGRIDBinding fixgrid, boolean selectedItemsOnly) {
        this.m_fixgrid = fixgrid;
        this.m_selectedItemsOnly = selectedItemsOnly;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)bos, ValueManager.CHARSET_UTF8.name());
            XMLWriter.writer_startElement(writer, null, "griddata");
            XMLWriter.writer_closeStartElement(writer, null);
            List<List<String>> headers = this.m_fixgrid.getExporter().exportToStringListHeader();
            FIXGRIDExportSanitizer.instance().sanitizeStringDataBeforeExport(ENUMExportType.XML, headers);
            this.appendToWriterXML(writer, headers, "headerrow", true);
            List<List<String>> items = this.m_fixgrid.getExporter().exportToStringListWholeGrid(this.m_selectedItemsOnly);
            FIXGRIDExportSanitizer.instance().sanitizeStringDataBeforeExport(ENUMExportType.XML, items);
            this.appendToWriterXML(writer, items, "row", false);
            List<List<String>> footers = this.m_fixgrid.getExporter().exportToStringListFooter();
            FIXGRIDExportSanitizer.instance().sanitizeStringDataBeforeExport(ENUMExportType.XML, footers);
            this.appendToWriterXML(writer, footers, "footerrow", true);
            XMLWriter.writer_endElement(writer, null, "griddata");
            writer.close();
            bos.close();
            String result = new String(bos.toByteArray(), ValueManager.CHARSET_UTF8);
            return result;
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Error happened during CSV export", t);
            return null;
        }
    }

    private void appendToWriterXML(Writer writer, List<List<String>> items, String rowtag, boolean withPlaceHolderReplacement) throws Exception {
        for (List<String> item : items) {
            XMLWriter.writer_startElement(writer, null, rowtag);
            XMLWriter.writer_closeStartElement(writer, null);
            for (String value : item) {
                if (withPlaceHolderReplacement && ".%.".equals(value)) {
                    value = "";
                }
                XMLWriter.writer_startElement(writer, null, "cell");
                XMLWriter.writer_closeStartElementWithoutLineFeed(writer, null);
                XMLWriter.writer_writeText(writer, null, value);
                XMLWriter.writer_endElement(writer, null, "cell");
            }
            XMLWriter.writer_endElement(writer, null, rowtag);
        }
    }
}

