/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.elements.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclnt.jsfserver.elements.util.IValueByToString;
import org.eclnt.jsfserver.util.valuemgmt.IDynamicContentBindingObject;
import org.eclnt.util.valuemgmt.UniqueIdCreator;
import org.eclnt.util.valuemgmt.ValueManager;

public class ValidValuesBinding
implements IValueByToString,
Serializable,
IDynamicContentBindingObject {
    long m_changeCounter = UniqueIdCreator.createCounter();
    List<ValidValue> m_validValues = new ArrayList<ValidValue>();
    String m_bufferedExportString = null;

    public void addValidValue(String value, String text) {
        this.addValidValue((Comparable)((Object)value), text);
    }

    public void addValidValue(Comparable value, String text) {
        ValidValue vv = new ValidValue();
        vv.i_value = ValueManager.convertObject2ValueString(value);
        vv.i_objectValue = value;
        vv.i_text = text;
        this.m_validValues.add(vv);
        this.indicateChange();
    }

    public void addValidValue(String value, String text, String valuecomment) {
        this.addValidValue((Comparable)((Object)value), text, valuecomment);
    }

    public void addValidValue(Comparable value, String text, String valuecomment) {
        ValidValue vv = new ValidValue();
        vv.i_value = ValueManager.convertObject2ValueString(value);
        vv.i_text = text;
        vv.i_valuecomment = valuecomment;
        vv.i_objectValue = value;
        this.m_validValues.add(vv);
        this.indicateChange();
    }

    public void addValidValue(String value, String text, String valuecomment, String image) {
        this.addValidValue((Comparable)((Object)value), text, valuecomment, image);
    }

    public void addValidValue(Comparable value, String text, String valuecomment, String image) {
        ValidValue vv = new ValidValue();
        vv.i_value = ValueManager.convertObject2ValueString(value);
        vv.i_text = text;
        vv.i_valuecomment = valuecomment;
        vv.i_image = image;
        vv.i_objectValue = value;
        this.m_validValues.add(vv);
        this.indicateChange();
    }

    public void removeValidValue(String value) {
        this.removeValidValue((Comparable)((Object)value));
    }

    public void removeValidValue(Comparable value) {
        for (int i = this.m_validValues.size() - 1; i >= 0; --i) {
            ValidValue vv = this.m_validValues.get(i);
            if (vv.i_objectValue == null && value == null) {
                this.indicateChange();
                this.m_validValues.remove(i);
                return;
            }
            if (vv.i_objectValue == null || !vv.i_objectValue.equals(value)) continue;
            this.indicateChange();
            this.m_validValues.remove(i);
            return;
        }
    }

    public void clear() {
        this.m_validValues.clear();
        this.indicateChange();
    }

    public Iterator<ValidValue> getValidValues() {
        return this.m_validValues.iterator();
    }

    public int size() {
        return this.m_validValues.size();
    }

    public long getChangeCounter() {
        return this.m_changeCounter;
    }

    public void sortByValue() {
        Collections.sort(this.m_validValues);
    }

    public void sortByValue(Comparator<String> comparator) {
        boolean updated;
        this.indicateChange();
        do {
            updated = false;
            for (int i = 0; i < this.m_validValues.size() - 1; ++i) {
                ValidValue vv = this.m_validValues.get(i);
                ValidValue nvv = this.m_validValues.get(i + 1);
                String value = vv.getValue();
                String nextValue = nvv.getValue();
                if (value == null) {
                    value = "";
                }
                if (nextValue == null) {
                    nextValue = "";
                }
                int comparisonResult = 0;
                comparisonResult = comparator == null ? nextValue.compareTo(value) : comparator.compare(nextValue, value);
                if (comparisonResult >= 0) continue;
                this.m_validValues.set(i, nvv);
                this.m_validValues.set(i + 1, vv);
                updated = true;
            }
        } while (updated);
    }

    public void sortByNumberValue() {
        boolean updated;
        this.indicateChange();
        do {
            updated = false;
            for (int i = 0; i < this.m_validValues.size() - 1; ++i) {
                ValidValue vv = this.m_validValues.get(i);
                ValidValue nvv = this.m_validValues.get(i + 1);
                String value = vv.getValue();
                String nextValue = nvv.getValue();
                float floatValue = this.numberValueOfString(value);
                float floatNextValue = this.numberValueOfString(nextValue);
                if (!(floatNextValue < floatValue)) continue;
                this.m_validValues.set(i, nvv);
                this.m_validValues.set(i + 1, vv);
                updated = true;
            }
        } while (updated);
    }

    protected float numberValueOfString(String s) {
        if (s == null) {
            return 0.0f;
        }
        return ValueManager.decodeFloat(s, 0.0f);
    }

    public void sortByName() {
        this.sortByName(null);
    }

    public void sortByName(Comparator<String> comparator) {
        boolean updated;
        this.indicateChange();
        do {
            updated = false;
            for (int i = 0; i < this.m_validValues.size() - 1; ++i) {
                ValidValue vv = this.m_validValues.get(i);
                ValidValue nvv = this.m_validValues.get(i + 1);
                String value = vv.getText();
                String nextValue = nvv.getText();
                if (value == null) {
                    value = "";
                }
                if (nextValue == null) {
                    nextValue = "";
                }
                int comparisonResult = 0;
                comparisonResult = comparator == null ? nextValue.compareTo(value) : comparator.compare(nextValue, value);
                if (comparisonResult >= 0) continue;
                this.m_validValues.set(i, nvv);
                this.m_validValues.set(i + 1, vv);
                updated = true;
            }
        } while (updated);
    }

    public ValidValue getValidValueByValue(String value) {
        return this.getValidValueByValue((Comparable)((Object)value));
    }

    public ValidValue getValidValueByValue(Comparable value) {
        for (ValidValue vv : this.m_validValues) {
            if (!ValueManager.checkIfObjectsAreEqual(value, vv.i_objectValue)) continue;
            return vv;
        }
        return null;
    }

    public ValidValue getValidValueByValueString(Comparable value) {
        String s1 = ValueManager.convertObject2ValueString(value);
        for (ValidValue vv : this.m_validValues) {
            String s2 = ValueManager.convertObject2ValueString(vv.getValue());
            if (!ValueManager.checkIfStringsAreEqual(s1, s2)) continue;
            return vv;
        }
        return null;
    }

    public ValidValue getValidValueByName(String value) {
        for (ValidValue vv : this.m_validValues) {
            if (!ValueManager.checkIfStringsAreEqual(value, vv.getText())) continue;
            return vv;
        }
        return null;
    }

    public String exportAsString() {
        ArrayList<String> cols = new ArrayList<String>();
        cols.add("v1");
        for (ValidValue vv : this.m_validValues) {
            cols.add(vv.i_value);
            cols.add(vv.i_text);
            cols.add(vv.i_valuecomment);
            cols.add(vv.i_image);
        }
        return ValueManager.encodeCSV(cols, "@null@");
    }

    public final String toString() {
        if (this.m_bufferedExportString == null) {
            this.m_bufferedExportString = this.exportAsString();
        }
        return this.m_bufferedExportString;
    }

    private void indicateChange() {
        this.m_changeCounter = UniqueIdCreator.createCounter();
        this.m_bufferedExportString = null;
    }

    public class ValidValue
    implements Serializable,
    Comparable<ValidValue> {
        String i_value;
        String i_text;
        String i_valuecomment;
        String i_image;
        Comparable i_objectValue;

        public String getValue() {
            return this.i_value;
        }

        public String getText() {
            return this.i_text;
        }

        public String getValuecomment() {
            return this.i_valuecomment;
        }

        public String getImage() {
            return this.i_image;
        }

        public Comparable getObjectValue() {
            return this.i_objectValue;
        }

        @Override
        public int compareTo(ValidValue o) {
            if (this.i_objectValue == null && o.i_objectValue == null) {
                return 0;
            }
            if (this.i_objectValue == null && o.i_objectValue != null) {
                return -1;
            }
            if (this.i_objectValue != null && o.i_objectValue == null) {
                return 1;
            }
            return this.i_objectValue.compareTo(o.i_objectValue);
        }
    }
}

