/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.polling.comet;

import java.io.Serializable;
import java.util.Date;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.comet.CometEvent;
import org.eclnt.jsfserver.polling.ILongPolling;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.ServletUtil;
import org.eclnt.util.log.CLog;

public class DefaultLongPollingComet
implements ILongPolling,
Serializable {
    static int s_idCounter = 0;
    String m_id = "cclongpollingcomet_" + new Date().getTime() + "_" + ++s_idCounter;
    boolean m_continuePolling = false;
    boolean m_wasWokenUpInNotWaitingPhase = false;
    boolean m_throwError = false;
    String m_longPollingResponse = null;
    CometEvent m_cometEvent;
    HttpServletResponse m_httpServletResponse;
    long m_lastResponseTime;

    public DefaultLongPollingComet() {
        this.updateLastResponseTime();
    }

    @Override
    public String getId() {
        return this.m_id;
    }

    @Override
    public boolean getContinuePolling() {
        return this.m_continuePolling;
    }

    @Override
    public String getURL() {
        String result = "cclongpollingcomet/" + this.m_id + ".cclongpollingcomet";
        result = ServletUtil.encodeURL(result, HttpSessionAccess.getCurrentRequest(), HttpSessionAccess.getCurrentResponse());
        result = "/" + result;
        return result;
    }

    public boolean waitForEvent(HttpServletResponse response, CometEvent event) {
        this.m_httpServletResponse = response;
        this.m_cometEvent = event;
        if (!this.m_wasWokenUpInNotWaitingPhase) {
            this.m_httpServletResponse = response;
        } else {
            this.wakeup(this.m_continuePolling);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wakeup(boolean continuePolling) {
        DefaultLongPollingComet defaultLongPollingComet = this;
        synchronized (defaultLongPollingComet) {
            this.updateLastResponseTime();
            this.m_throwError = false;
            this.m_continuePolling = continuePolling;
            if (this.m_httpServletResponse != null) {
                this.m_wasWokenUpInNotWaitingPhase = false;
                this.sendMessageToClient("" + this.m_continuePolling, true);
            } else {
                CLog.L.log(CLog.LL_INF, "##### Buffering wakeup to client " + this.m_continuePolling);
                this.m_wasWokenUpInNotWaitingPhase = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wakeupForReconnect() {
        this.m_throwError = false;
        DefaultLongPollingComet defaultLongPollingComet = this;
        synchronized (defaultLongPollingComet) {
            this.updateLastResponseTime();
            if (this.m_httpServletResponse != null) {
                this.sendMessageToClient("reconnect", true);
            }
        }
    }

    @Override
    public void abortThread() {
        if (this.m_httpServletResponse != null) {
            this.sendMessageToClient(null, true);
        }
    }

    @Override
    public void abortThreadWithErrorIfWaiting() {
        this.abortThread();
    }

    @Override
    public void abortThreadWithouContinuingPolling() {
        this.updateLastResponseTime();
        this.wakeup(false);
    }

    @Override
    public void keepAlive() {
        this.updateLastResponseTime();
        this.m_throwError = false;
        if (this.m_httpServletResponse != null) {
            this.sendMessageToClient("          ", false);
        }
    }

    @Override
    public long getLastResponseTime() {
        return this.m_lastResponseTime;
    }

    private void sendMessageToClient(String message, boolean flushAndClose) {
        CLog.L.log(CLog.LL_INF, "##### Sending message to client " + this.m_continuePolling);
        if (this.m_httpServletResponse != null) {
            try {
                if (message != null) {
                    this.m_httpServletResponse.getWriter().write(message);
                }
                if (!flushAndClose) {
                    return;
                }
                this.m_httpServletResponse.getWriter().flush();
                this.m_httpServletResponse.getWriter().close();
                this.m_cometEvent.close();
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_INF, "Problem when writing long polling response", t);
            }
            this.m_httpServletResponse = null;
            this.m_cometEvent = null;
        } else {
            CLog.L.log(CLog.LL_INF, "##### No response to write to found");
        }
    }

    private void updateLastResponseTime() {
        this.m_lastResponseTime = System.currentTimeMillis();
    }
}

