/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.tools;

import java.io.File;
import java.util.List;
import org.eclnt.util.file.FileManager;

public class SearchStyleFileForNonRGBADefinition {
    public static void main(String[] args) {
        String styleDirectory = "C:\\bmu_jtc\\git\\eclnt_clientrisc\\web\\styles";
        SearchStyleFileForNonRGBADefinition.checkFiles(styleDirectory);
    }

    private static void checkFiles(String styleDirectory) {
        List<File> files = FileManager.getFilesOfDirectory(styleDirectory);
        for (File file : files) {
            String fileName = file.getName();
            if (!fileName.endsWith(".xml")) continue;
            SearchStyleFileForNonRGBADefinition.checkFile(file);
        }
    }

    private static void checkFile(File file) {
        int index;
        System.out.println("Checking file: " + file.getAbsolutePath());
        String s = FileManager.readUTF8File(file.getAbsolutePath(), true);
        int currentIndex = 0;
        while ((index = s.indexOf("#", currentIndex)) >= 0) {
            String color = null;
            try {
                color = s.substring(index + 1, index + 9);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            boolean foundOneCharactedOutsideRange = false;
            if (color != null) {
                for (int i = 0; i < 8; ++i) {
                    char c = color.charAt(i);
                    if ("1234567890ABCDEFabcdef".contains("" + c)) continue;
                    foundOneCharactedOutsideRange = true;
                    break;
                }
            }
            if (!foundOneCharactedOutsideRange) {
                throw new Error("Wrong color definition: #" + color + " in " + file.getAbsolutePath());
            }
            currentIndex = index + 1;
        }
    }
}

