/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.eclnt.jsfserver.bufferedcontent.UploadContentServlet;
import org.eclnt.jsfserver.messages.DialogMessageBus;
import org.eclnt.jsfserver.polling.LongPollingMgr;
import org.eclnt.jsfserver.util.CCInitialize;
import org.eclnt.jsfserver.util.DialogSessionListenerMgmt;
import org.eclnt.jsfserver.util.IHttpSessionClosedReactor;
import org.eclnt.jsfserver.util.IHttpSessionListener;
import org.eclnt.jsfserver.util.IHttpSessionListener2;
import org.eclnt.jsfserver.util.SessionAbstractionHttpSession;
import org.eclnt.jsfserver.util.SubpageContext;
import org.eclnt.jsfserver.util.ThreadingSynchronization;
import org.eclnt.jsfserver.util.TypeOfSessionMgmt;
import org.eclnt.jsfserver.util.tempfile.TempFileManager;
import org.eclnt.util.log.CLog;

public class HttpSessionListenerDelegator
implements HttpSessionListener,
ServletContextListener,
Serializable {
    static boolean s_isInitialized = false;
    boolean m_isGlobalSessionListenerDelegator = true;
    Map<String, IHttpSessionClosedReactor> m_delegateTos = new HashMap<String, IHttpSessionClosedReactor>();
    Set<IHttpSessionListener> m_globalListenes = new HashSet<IHttpSessionListener>();

    public HttpSessionListenerDelegator() {
        s_isInitialized = true;
    }

    public void contextInitialized(ServletContextEvent sce) {
        CCInitialize.initializeCCEnvironment(sce.getServletContext());
    }

    public void contextDestroyed(ServletContextEvent arg0) {
    }

    public void addGlobalSessionListener(IHttpSessionListener listener) {
        this.ensureGlobalListener("addGlobalSessionListener");
        this.m_globalListenes.add(listener);
    }

    public void removeGlobalSessionListener(IHttpSessionListener listener) {
        this.ensureGlobalListener("removeGlobalSessionListener");
        this.m_globalListenes.remove(listener);
    }

    public void sessionCreated(HttpSessionEvent event) {
        CLog.L.log(CLog.LL_INF, "Session created - sessionId: " + event.getSession().getId());
        HttpSessionListenerDelegator localListener = new HttpSessionListenerDelegator();
        localListener.m_isGlobalSessionListenerDelegator = false;
        event.getSession().setAttribute(HttpSessionListenerDelegator.class.getName(), (Object)localListener);
        for (IHttpSessionListener listener : this.m_globalListenes) {
            try {
                listener.reactOnSessionCreated(event);
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_ERR, "Problem inside session listener", t);
            }
        }
        if (!TypeOfSessionMgmt.getSessionMgmtViaCookie()) {
            DialogSessionListenerMgmt.notifyDialogSessionCreated(new SessionAbstractionHttpSession(event.getSession()));
        }
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        HttpSessionListenerDelegator sessionInstance;
        CLog.L.log(CLog.LL_DBG, "Session destroyed", new Exception("This exception only is created to show the stack trace"));
        HttpSession session = event.getSession();
        for (IHttpSessionListener iHttpSessionListener : this.m_globalListenes) {
            try {
                iHttpSessionListener.reactOnSessionClosed(event);
            }
            catch (Throwable throwable) {
                CLog.L.log(CLog.LL_INF, "Problem inside session listener.\nProblem is caught and normal processing is continued.", throwable);
            }
        }
        if (!TypeOfSessionMgmt.getSessionMgmtViaCookie()) {
            DialogSessionListenerMgmt.notifyDialogSessionClosed(new SessionAbstractionHttpSession(event.getSession()));
        }
        if ((sessionInstance = (HttpSessionListenerDelegator)event.getSession().getAttribute(HttpSessionListenerDelegator.class.getName())) != null) {
            for (IHttpSessionClosedReactor iHttpSessionClosedReactor : sessionInstance.m_delegateTos.values()) {
                try {
                    iHttpSessionClosedReactor.reactOnClosed();
                }
                catch (Throwable t) {
                    CLog.L.log(CLog.LL_INF, "Problem occurred when delegating sessionDestroyed.\nProblem is caught and normal processing is continued.", t);
                }
            }
        } else {
            CLog.L.log(CLog.LL_INF, "Session instance could not be found.");
        }
        try {
            List<SubpageContext> list = SubpageContext.findAllSubpageContextInSession(event.getSession());
            for (SubpageContext spc : list) {
                try {
                    spc.invalidate(false);
                }
                catch (Throwable tt) {
                    CLog.L.log(CLog.LL_INF, "Problem when closing subsession context", tt);
                }
            }
        }
        catch (Throwable throwable) {
            CLog.L.log(CLog.LL_INF, "Problem when closing subsession context.\nProblem is caught and normal processing is continued.", throwable);
        }
        for (IHttpSessionListener iHttpSessionListener : this.m_globalListenes) {
            if (!(iHttpSessionListener instanceof IHttpSessionListener2)) continue;
            try {
                ((IHttpSessionListener2)iHttpSessionListener).reactOnSessionClosedInEndPhaseOfClosing(event);
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_INF, "Problem inside session listener processing reactOnSessionClosedInEndPhaseOfClosing.\nProblem is caught and normal processing is continued.", t);
            }
        }
        try {
            DialogMessageBus dialogMessageBus = DialogMessageBus.instance(session, new SessionAbstractionHttpSession(session), false);
            if (dialogMessageBus != null) {
                dialogMessageBus.destroy();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        LongPollingMgr.abortAllLongPollingThreadsForSession(event.getSession());
        TempFileManager.clear(event.getSession());
        UploadContentServlet.clear(event.getSession());
        ThreadingSynchronization.instance().unregisterDialogSession(event.getSession().getId());
    }

    public void addReactor(String id, IHttpSessionClosedReactor listener) {
        this.ensureLocalListener("addReactor");
        this.m_delegateTos.put(id, listener);
    }

    public void removeReactor(String id) {
        this.ensureLocalListener("removeReactor");
        this.m_delegateTos.remove(id);
    }

    public Collection<IHttpSessionClosedReactor> getReactors() {
        return this.m_delegateTos.values();
    }

    public IHttpSessionClosedReactor getReactor(String id) {
        this.ensureLocalListener("getReactor");
        return this.m_delegateTos.get(id);
    }

    public static void ensureInitialized() {
        if (s_isInitialized) {
            return;
        }
        throw new Error("The HttpSessionListenerDelegator was not intialized yet.\nSome server environments require the start-up process to be triggeredby expecting a file META-INF/services/ServletContainerInitializer thatis available in the webapp-classloader. A template fileMETA-INF/services/ServletContainerInitializer_template is availablein the eclntjsfserver*.jar library. Please make available in oneof you application's jar files (WEB-INF/lib) or direcetly in WEB-INF/classes.");
    }

    private void ensureGlobalListener(String methodName) {
        if (!this.m_isGlobalSessionListenerDelegator) {
            throw new Error(methodName + " must not be called with local session listener, but must be called with the global listener");
        }
    }

    private void ensureLocalListener(String methodName) {
        if (this.m_isGlobalSessionListenerDelegator) {
            throw new Error(methodName + " must not be called with global session listener, but must be called with instances that are created per session");
        }
    }
}

