/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclnt.jsfserver.configuration.CCConfigurationObjectLoader;
import org.eclnt.jsfserver.util.CCFilterBase;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.ICCServerConstants;
import org.eclnt.jsfserver.util.ServletUtil;
import org.eclnt.jsfserver.util.SystemXml;
import org.eclnt.jsfserver.util.TypeOfSessionMgmt;
import org.eclnt.jsfserver.util.security.StringHider;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.UniqueIdCreator;
import org.eclnt.util.valuemgmt.ValueManager;

public class SecurityFilterGeneral
extends CCFilterBase
implements Filter,
ICCServerConstants {
    static final String COOKIE_CCSESSIONCHECKID_GENERAL = "ccclientcheckidgeneral";
    static final String SESSIONATT_CCSESSIONCHECKID_REQUIRED = "ccclientcheckidgeneralNotRequired";
    static boolean s_initialized = false;
    static IExtension s_extension = null;
    static Set<IExtension> s_extensions = new HashSet<IExtension>();
    static Object SYNCHER = new Object();

    @Override
    public void init(FilterConfig arg0) throws ServletException {
    }

    @Override
    public void doFilterExecute(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            this.initExtension();
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            HttpSession session = httpRequest.getSession(false);
            boolean isLayoutRoundtrip = false;
            boolean executeCheck = true;
            boolean isFacesRequest = false;
            if (httpRequest.getRequestURI().contains("/faces/") && httpRequest.getRequestURI().contains(".jsp")) {
                isFacesRequest = true;
            }
            if (!HttpSessionAccess.checkIfCurrentClientTypeIsRisc(httpRequest)) {
                executeCheck = false;
                TypeOfSessionMgmt.associateNORISCClientWithCurrentThread(this);
            } else {
                TypeOfSessionMgmt.associateRISCClientWithCurrentThread(this);
            }
            if (session != null) {
                StringHider cookieRequired = (StringHider)session.getAttribute(SESSIONATT_CCSESSIONCHECKID_REQUIRED);
                if (cookieRequired == null) {
                    executeCheck = false;
                } else if ("false".equals(cookieRequired.getValue())) {
                    executeCheck = false;
                }
            }
            if (executeCheck && isFacesRequest) {
                String idRequest;
                String idSession = null;
                if (session == null) {
                    executeCheck = false;
                }
                if (executeCheck && (idSession = this.readCCSessionCheckIdGeneralFromSession(session)) == null) {
                    executeCheck = false;
                }
                if (executeCheck && (idRequest = SecurityFilterGeneral.readCCSessionCheckIdGeneralFromRequest(httpRequest)) == null && idSession == null) {
                    executeCheck = false;
                }
            }
            if (executeCheck && s_extension != null) {
                executeCheck = s_extension.checkIfToExecuteCheck(request);
            }
            for (IExtension extension : s_extensions) {
                if (!executeCheck) continue;
                executeCheck = extension.checkIfToExecuteCheck(request);
            }
            if (executeCheck) {
                if (session == null) {
                    CLog.L.log(CLog.LL_ERR, "Session for checking security id is not available anymore. Aborting security check with error. " + httpRequest.getRequestURI());
                    throw new Error("Session for checking security id is not available anymore: " + httpRequest.getRequestURI());
                }
                this.performCheck_ccSessionCheckIdSession(session, httpRequest);
            }
            chain.doFilter(request, response);
        }
        catch (Throwable t) {
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof ServletException) {
                throw (ServletException)t;
            }
            throw new Error(t);
        }
        finally {
            TypeOfSessionMgmt.clearCurrentThread(this);
        }
    }

    private void performCheck_ccSessionCheckIdSession(HttpSession session, HttpServletRequest httpRequest) {
        String ccSessionCheckIdSession = this.readCCSessionCheckIdGeneralFromSession(session);
        if (ccSessionCheckIdSession == null) {
            CLog.L.log(CLog.LL_ERR, "General security id is not available in session. Aborting security check with error. " + httpRequest.getRequestURI());
            throw new Error("General security id is not available in session: " + httpRequest.getRequestURI());
        }
        String ccSessionCheckIdRequest = SecurityFilterGeneral.readCCSessionCheckIdGeneralFromRequest(httpRequest);
        if (!ValueManager.checkIfStringsAreEqual(ccSessionCheckIdSession, ccSessionCheckIdRequest)) {
            CLog.L.log(CLog.LL_ERR, "Client does not send valid general security id. Request is cancelled. Aborting security check with error. " + httpRequest.getRequestURI());
            throw new Error("Client does not send valid security id. Request is cancelled: " + httpRequest.getRequestURI());
        }
    }

    private String readCCSessionCheckIdGeneralFromSession(HttpSession session) {
        if (session == null) {
            return null;
        }
        StringHider hider = (StringHider)session.getAttribute(COOKIE_CCSESSIONCHECKID_GENERAL);
        if (hider == null) {
            return null;
        }
        return hider.getValue();
    }

    public void destroy() {
    }

    @Deprecated
    public static void setSecurityFilterExtension(IExtension extension) {
        s_extension = extension;
    }

    @Deprecated
    public static IExtension getSecurityFilterExtension() {
        return s_extension;
    }

    public static synchronized void addSecurityFilterExtension(IExtension extension) {
        s_extensions.add(extension);
    }

    public static synchronized void removeSecurityFilterExtension(IExtension extension) {
        s_extensions.remove(extension);
    }

    public static void manageSecurityFilterDownloadCookie(HttpServletRequest request, HttpServletResponse response, HttpSession session) {
        if (!HttpSessionAccess.checkIfCurrentClientTypeIsRisc(request)) {
            return;
        }
        if (!SecurityFilterGeneral.checkIfFilterIsActive()) {
            return;
        }
        if (TypeOfSessionMgmt.getSessionMgmtViaCookie(session)) {
            return;
        }
        String protocol = ServletUtil.isolateOriginalProtocol(request, true);
        String server = ServletUtil.isolateOriginalServer(request, true);
        if ("https".equals(protocol) || "localhost".equals(server)) {
            session.setAttribute(SESSIONATT_CCSESSIONCHECKID_REQUIRED, (Object)new StringHider("true"));
            String checkId = SecurityFilterGeneral.readCCSessionCheckIdGeneralFromRequest(request);
            if (checkId == null) {
                checkId = UniqueIdCreator.createRandomId();
            }
            session.setAttribute(COOKIE_CCSESSIONCHECKID_GENERAL, (Object)new StringHider(checkId));
            boolean secure = true;
            if (!"https".equals(protocol)) {
                secure = false;
            }
            SecurityFilterGeneral.writeCCSessionCheckIdIntoResponse(request, response, checkId, secure);
        } else {
            session.setAttribute(SESSIONATT_CCSESSIONCHECKID_REQUIRED, (Object)new StringHider("false"));
        }
    }

    private static boolean checkIfFilterIsActive() {
        SystemXml.FilterConfiguration fc = SystemXml.getFilterConfiguration(SecurityFilterGeneral.class);
        return fc == null || fc.isActive();
    }

    private static String readCCSessionCheckIdGeneralFromRequest(HttpServletRequest httpRequest) {
        Cookie[] cookies = httpRequest.getCookies();
        if (cookies == null) {
            return null;
        }
        for (Cookie cookie : cookies) {
            if (!cookie.getName().equals(COOKIE_CCSESSIONCHECKID_GENERAL)) continue;
            return cookie.getValue();
        }
        return null;
    }

    private static void writeCCSessionCheckIdIntoResponse(HttpServletRequest request, HttpServletResponse httpResponse, String ccSessionCheckId, boolean secure) {
        String cookiePath = ServletUtil.findWebappCookiePath(request);
        String sameSite = null;
        if (secure) {
            sameSite = "None";
        }
        ServletUtil.writeCookie(httpResponse, COOKIE_CCSESSIONCHECKID_GENERAL, cookiePath, ccSessionCheckId, true, sameSite, secure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initExtension() {
        if (!s_initialized) {
            Object object = SYNCHER;
            synchronized (object) {
                if (!s_initialized) {
                    try {
                        String className = SystemXml.getSecurityfilterextensionclassnameGeneral();
                        if (className != null) {
                            s_extension = (IExtension)CCConfigurationObjectLoader.instance().loadInstance(className, true);
                        }
                    }
                    catch (Throwable t) {
                        CLog.L.log(CLog.LL_ERR, "Problem initializing the security filter extension", t);
                    }
                    s_initialized = true;
                }
            }
        }
    }

    public static interface IExtension {
        public boolean checkIfToExecuteCheck(ServletRequest var1);
    }
}

