/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import java.util.ArrayList;
import java.util.List;
import javax.faces.event.ActionEvent;
import org.eclnt.jsfserver.util.IServerSideScrollList;

public class ServerSideScrollList<ITEMCLASS>
implements IServerSideScrollList<ITEMCLASS> {
    List<ITEMCLASS> m_items;
    List<ITEMCLASS> m_clientList = new ArrayList<ITEMCLASS>();
    int m_topIndex = 0;
    int m_numberOfItems = 10;
    long m_currentBufferReference = -1L;
    long m_lastBufferReference = -1L;

    public ServerSideScrollList() {
        this.m_items = new ArrayList<ITEMCLASS>();
    }

    public ServerSideScrollList(int numberOfItems) {
        this.m_items = new ArrayList<ITEMCLASS>();
        this.m_numberOfItems = numberOfItems;
    }

    public ServerSideScrollList(List<ITEMCLASS> list, int numberOfItems) {
        this.m_items = list;
        this.m_numberOfItems = numberOfItems;
    }

    @Override
    public List<ITEMCLASS> getItems() {
        return this.m_items;
    }

    @Override
    public List<ITEMCLASS> getClientItems() {
        if (this.m_currentBufferReference >= 0L && this.m_lastBufferReference == this.m_currentBufferReference) {
            return this.m_clientList;
        }
        this.m_lastBufferReference = this.m_currentBufferReference;
        this.m_clientList.clear();
        for (int i = 0; i < this.m_numberOfItems && this.m_topIndex + i < this.m_items.size(); ++i) {
            ITEMCLASS item = this.m_items.get(this.m_topIndex + i);
            this.m_clientList.add(item);
        }
        return this.m_clientList;
    }

    @Override
    public int getTopIndex() {
        return this.m_topIndex;
    }

    public void setTopIndex(int topIndex) {
        this.m_topIndex = topIndex;
    }

    @Override
    public int getNumberOfItems() {
        return this.m_numberOfItems;
    }

    public void setNumberOfItems(int numberOfItems) {
        this.m_numberOfItems = numberOfItems;
    }

    public int getMaxIndex() {
        return this.m_items.size() - 1;
    }

    public String getPositionText() {
        int from = this.m_topIndex + 1;
        int to = this.m_topIndex + this.m_numberOfItems;
        if (to > this.m_items.size()) {
            to = this.m_items.size();
        }
        return from + "-" + to + " / " + this.m_items.size();
    }

    public boolean getScrollPossible() {
        return this.m_items.size() > this.m_numberOfItems;
    }

    public boolean getScrollFirstPossible() {
        return this.m_topIndex > 0;
    }

    public boolean getScrollPageUpPossible() {
        return this.m_topIndex > 0;
    }

    public boolean getScrollPageDownPossible() {
        return this.m_topIndex + this.m_numberOfItems < this.m_items.size();
    }

    public boolean getScrollLastPossible() {
        return this.m_topIndex + this.m_numberOfItems < this.m_items.size();
    }

    public void onScrollFirst(ActionEvent event) {
        this.m_topIndex = 0;
    }

    public void onScrollPageDownAction(ActionEvent event) {
        this.scrollPageDown();
    }

    public void onScrollPageUpAction(ActionEvent event) {
        this.scrollPageUp();
    }

    public void onScrollLast(ActionEvent event) {
        this.m_topIndex = this.m_items.size() / this.m_numberOfItems * this.m_numberOfItems;
        if (this.m_topIndex >= this.m_items.size()) {
            this.m_topIndex -= this.m_numberOfItems;
        }
        if (this.m_topIndex < 0) {
            this.m_topIndex = 0;
        }
    }

    @Override
    public void setBufferReference(long reference) {
        this.m_currentBufferReference = reference;
    }

    public void scrollPageDown() {
        int newTopIndex = this.m_topIndex + this.m_numberOfItems;
        if (newTopIndex >= this.m_items.size()) {
            return;
        }
        this.m_topIndex = newTopIndex;
    }

    public void scrollPageUp() {
        this.m_topIndex -= this.m_numberOfItems;
        if (this.m_topIndex < 0) {
            this.m_topIndex = 0;
        }
    }
}

